/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.mixins.journeymap;

import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.integration.journeymap.JourneyMapState;
import com.sinthoras.visualprospecting.integration.journeymap.buttons.LayerButton;
import com.sinthoras.visualprospecting.integration.journeymap.render.LayerRenderer;
import com.sinthoras.visualprospecting.integration.journeymap.render.WaypointProviderLayerRenderer;
import com.sinthoras.visualprospecting.integration.model.MapState;
import com.sinthoras.visualprospecting.integration.model.layers.LayerManager;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.io.ThemeFileHandler;
import journeymap.client.log.LogFormatter;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.MapChat;
import journeymap.client.ui.fullscreen.layer.LayerDelegate;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeButton;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.client.ui.theme.ThemeToolbar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.KeyBinding;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Mouse;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Fullscreen.class}, remap=false)
public abstract class FullscreenMixin
extends JmUI {
    private int oldMouseX = 0;
    private int oldMouseY = 0;
    private long timeLastClick = 0L;
    @Final
    @Shadow(remap=false)
    static GridRenderer gridRenderer;
    @Shadow(remap=false)
    ThemeToolbar mapTypeToolbar;
    @Shadow(remap=false)
    ThemeButton buttonCaves;
    @Shadow(remap=false)
    ThemeButton buttonNight;
    @Shadow(remap=false)
    ThemeButton buttonDay;
    @Shadow(remap=false)
    StatTimer drawScreenTimer;
    @Shadow(remap=false)
    MapChat chat;
    @Final
    @Shadow(remap=false)
    LayerDelegate layerDelegate;
    @Shadow(remap=false)
    boolean firstLayoutPass;
    @Shadow(remap=false)
    int mx;
    @Shadow(remap=false)
    int my;

    public FullscreenMixin() {
        super("");
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")}, remap=false, require=1)
    private void init(CallbackInfo callbackInfo) {
        MapState.instance.layers.forEach(LayerManager::forceRefresh);
    }

    @Shadow(remap=false)
    private int getMapFontScale() {
        throw new IllegalStateException("Mixin failed to shadow getMapFontScale()");
    }

    @Shadow(remap=false)
    void drawMap() {
        throw new IllegalStateException("Mixin failed to shadow drawMap()");
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")}, remap=false, require=1)
    private void onConstructed(CallbackInfo callbackInfo) {
        MapState.instance.layers.forEach(LayerManager::onOpenMap);
    }

    @Inject(method={"drawMap"}, at={@At(value="INVOKE", target="Ljourneymap/client/model/MapState;getDrawWaypointSteps()Ljava/util/List;")}, remap=false, require=1, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void onBeforeDrawJourneyMapWaypoints(CallbackInfo callbackInfo, boolean refreshReady, StatTimer timer, int xOffset, int yOffset, float drawScale) {
        int fontScale = this.getMapFontScale();
        Minecraft minecraft = Minecraft.func_71410_x();
        int centerBlockX = (int)Math.round(gridRenderer.getCenterBlockX());
        int centerBlockZ = (int)Math.round(gridRenderer.getCenterBlockZ());
        int widthBlocks = minecraft.field_71443_c >> gridRenderer.getZoom();
        int heightBlocks = minecraft.field_71440_d >> gridRenderer.getZoom();
        for (LayerManager layerManager : MapState.instance.layers) {
            if (!layerManager.isLayerActive()) continue;
            layerManager.recacheFullscreenMap(centerBlockX, centerBlockZ, widthBlocks, heightBlocks);
        }
        for (LayerRenderer layerRenderer : JourneyMapState.instance.renderers) {
            if (!layerRenderer.isLayerActive()) continue;
            gridRenderer.draw(layerRenderer.getDrawStepsCachedForRendering(), (double)xOffset, (double)yOffset, drawScale, (double)fontScale, 0.0);
        }
    }

    @Redirect(method={"initButtons"}, at=@At(value="FIELD", target="Ljourneymap/client/ui/fullscreen/Fullscreen;mapTypeToolbar:Ljourneymap/client/ui/theme/ThemeToolbar;", opcode=181), remap=false, require=1)
    private void OnCreateMapTypeToolbar(Fullscreen owner, ThemeToolbar value) {
        Theme theme = ThemeFileHandler.getCurrentTheme();
        ButtonList buttonList = new ButtonList();
        for (LayerButton layerButton : JourneyMapState.instance.buttons) {
            ThemeToggle button = new ThemeToggle(theme, layerButton.getButtonTextKey(), layerButton.getIconName());
            layerButton.setButton(button);
            button.setToggled(Boolean.valueOf(layerButton.isActive()), false);
            button.addToggleListener((unused, toggled) -> {
                layerButton.toggle();
                return true;
            });
            buttonList.add((Object)button);
        }
        buttonList.add((Object)this.buttonCaves);
        buttonList.add((Object)this.buttonNight);
        buttonList.add((Object)this.buttonDay);
        this.mapTypeToolbar = new ThemeToolbar(theme, buttonList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73863_a(int width, int height, float f) {
        try {
            WaypointProviderLayerRenderer waypointProviderLayer;
            this.func_146278_c(0);
            this.drawMap();
            this.drawScreenTimer.start();
            this.layoutButtons();
            List<String> tooltip = null;
            if (this.firstLayoutPass) {
                this.layoutButtons();
                this.firstLayoutPass = false;
            } else {
                for (int k = 0; k < this.field_146292_n.size(); ++k) {
                    Button button;
                    GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
                    guibutton.func_146112_a(this.field_146297_k, width, height);
                    if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(this.mx, this.my)) continue;
                    tooltip = button.getTooltip();
                }
            }
            int scaledMouseX = this.mx * this.field_146297_k.field_71443_c / this.field_146294_l;
            int scaledMouseY = this.my * this.field_146297_k.field_71440_d / this.field_146295_m;
            for (LayerRenderer layer : JourneyMapState.instance.renderers) {
                if (!(layer instanceof WaypointProviderLayerRenderer)) continue;
                waypointProviderLayer = (WaypointProviderLayerRenderer)layer;
                waypointProviderLayer.onMouseMove(scaledMouseX, scaledMouseY);
            }
            if (tooltip == null) {
                for (LayerRenderer layer : JourneyMapState.instance.renderers) {
                    if (!(layer instanceof WaypointProviderLayerRenderer) || !(waypointProviderLayer = (WaypointProviderLayerRenderer)layer).isLayerActive()) continue;
                    tooltip = waypointProviderLayer.getTextTooltip();
                }
            }
            if (this.chat != null) {
                this.chat.func_73863_a(width, height, f);
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.drawHoveringText(tooltip, this.mx, this.my, this.getFontRenderer());
                RenderHelper.func_74518_a();
            } else {
                for (LayerRenderer layer : JourneyMapState.instance.renderers) {
                    if (!(layer instanceof WaypointProviderLayerRenderer) || !(waypointProviderLayer = (WaypointProviderLayerRenderer)layer).isLayerActive()) continue;
                    waypointProviderLayer.drawCustomTooltip(this.getFontRenderer(), this.mx, this.my, this.field_146294_l, this.field_146295_m);
                }
            }
        }
        catch (Throwable var11) {
            this.logger.log(Level.ERROR, "Unexpected exception in jm.fullscreen.drawScreen(): " + LogFormatter.toString((Throwable)var11));
            UIManager.getInstance().closeAll();
        }
        finally {
            this.drawScreenTimer.stop();
        }
    }

    @Inject(method={"func_73869_a"}, at={@At(value="HEAD")}, remap=false, require=1, cancellable=true)
    private void onKeyPress(CallbackInfo callbackInfo) {
        if ((this.chat == null || this.chat.isHidden()) && Constants.isPressed((KeyBinding)VP.keyAction)) {
            for (LayerRenderer layer : JourneyMapState.instance.renderers) {
                if (!(layer instanceof WaypointProviderLayerRenderer)) continue;
                ((WaypointProviderLayerRenderer)layer).onActionKeyPressed();
            }
            callbackInfo.cancel();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        double blockSize;
        int scaledMouseY;
        int scaledMouseX;
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.func_73864_a(mouseX, mouseY, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (!this.isMouseOverButton(mouseX, mouseY) && !this.onMapClicked(mouseButton, scaledMouseX = this.mx * this.field_146297_k.field_71443_c / this.field_146294_l, scaledMouseY = this.my * this.field_146297_k.field_71440_d / this.field_146295_m, blockSize = Math.pow(2.0, gridRenderer.getZoom()))) {
            BlockCoordIntPair blockCoord = gridRenderer.getBlockUnderMouse((double)Mouse.getEventX(), (double)Mouse.getEventY(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
            this.layerDelegate.onMouseClicked(this.field_146297_k, (double)Mouse.getEventX(), (double)Mouse.getEventY(), gridRenderer.getWidth(), gridRenderer.getHeight(), blockCoord, mouseButton);
        }
    }

    private boolean onMapClicked(int mouseButton, int mouseX, int mouseY, double blockSize) {
        long timestamp = System.currentTimeMillis();
        boolean isDoubleClick = mouseX == this.oldMouseX && mouseY == this.oldMouseY && timestamp - this.timeLastClick < 500L;
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
        long l = this.timeLastClick = isDoubleClick ? 0L : timestamp;
        if (mouseButton != 0) {
            return false;
        }
        boolean layerHit = false;
        for (LayerRenderer layer : JourneyMapState.instance.renderers) {
            if (!(layer instanceof WaypointProviderLayerRenderer)) continue;
            ((WaypointProviderLayerRenderer)layer).onMouseMove(mouseX, mouseY);
            layerHit |= ((WaypointProviderLayerRenderer)layer).onMouseAction(isDoubleClick);
        }
        return layerHit;
    }
}

