/*
 * Decompiled with CFR 0.152.
 */
package vfyjxf.bettercrashes.mixins.minecraft;

import cpw.mods.fml.client.SplashProgress;
import cpw.mods.fml.common.Loader;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MinecraftError;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import vfyjxf.bettercrashes.BetterCrashesConfig;
import vfyjxf.bettercrashes.utils.CrashUtils;
import vfyjxf.bettercrashes.utils.GuiCrashScreen;
import vfyjxf.bettercrashes.utils.GuiInitErrorScreen;
import vfyjxf.bettercrashes.utils.StateManager;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Final
    private static Logger field_147123_G;
    @Shadow
    volatile boolean field_71425_J;
    @Shadow
    private boolean field_71434_R;
    @Shadow
    private CrashReport field_71433_S;
    @Shadow
    public static byte[] field_71444_a;
    @Shadow
    @Final
    private Queue field_152351_aB;
    @Shadow
    public EntityRenderer field_71460_t;
    @Shadow
    private long field_83002_am;
    @Shadow
    public GameSettings field_71474_y;
    @Shadow
    public GuiIngame field_71456_v;
    @Shadow
    private List field_110449_ao;
    @Shadow
    private IReloadableResourceManager field_110451_am;
    @Shadow
    public FontRenderer field_71466_p;
    @Shadow
    public TextureManager field_71446_o;
    @Shadow
    private LanguageManager field_135017_as;
    @Shadow
    private SoundHandler field_147127_av;
    @Shadow
    @Final
    private IMetadataSerializer field_110452_an;
    @Shadow
    private Framebuffer field_147124_at;
    @Shadow
    public GuiScreen field_71462_r;
    @Shadow
    private int field_71429_W;
    @Shadow
    public int field_71443_c;
    @Shadow
    public int field_71440_d;
    private int clientCrashCount = 0;
    private int serverCrashCount = 0;

    @Shadow
    protected abstract void func_71384_a() throws LWJGLException;

    @Shadow
    public abstract void func_147108_a(GuiScreen var1);

    @Shadow
    public abstract CrashReport func_71396_d(CrashReport var1);

    @Shadow
    protected abstract void func_71411_J();

    @Shadow
    public abstract NetHandlerPlayClient func_147114_u();

    @Shadow
    public abstract void func_71403_a(WorldClient var1);

    @Shadow
    public abstract void func_71398_f();

    @Shadow
    public abstract void func_71405_e();

    @Shadow
    public abstract void func_110436_a();

    @Shadow
    protected abstract void func_71361_d(String var1);

    @Shadow
    public abstract void func_147120_f();

    @Overwrite
    public void func_99999_d() {
        this.field_71425_J = true;
        try {
            this.func_71384_a();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Initializing game");
            crashReport.func_85058_a("Initialization");
            this.displayInitErrorScreen(this.func_71396_d(crashReport));
            return;
        }
        try {
            while (this.field_71425_J) {
                if (!this.field_71434_R || this.field_71433_S == null) {
                    try {
                        this.func_71411_J();
                    }
                    catch (ReportedException e) {
                        ++this.clientCrashCount;
                        this.func_71396_d(e.func_71575_a());
                        this.addInfoToCrash(e.func_71575_a());
                        this.resetGameState();
                        field_147123_G.fatal("Reported exception thrown!", (Throwable)e);
                        this.displayCrashScreen(e.func_71575_a());
                    }
                    catch (Throwable e) {
                        ++this.clientCrashCount;
                        CrashReport report = new CrashReport("Unexpected error", e);
                        this.func_71396_d(report);
                        this.addInfoToCrash(report);
                        this.resetGameState();
                        field_147123_G.fatal("Unreported exception thrown!", e);
                        this.displayCrashScreen(report);
                    }
                    continue;
                }
                ++this.serverCrashCount;
                this.addInfoToCrash(this.field_71433_S);
                this.func_71398_f();
                this.displayCrashScreen(this.field_71433_S);
                this.field_71434_R = false;
                this.field_71433_S = null;
            }
        }
        catch (MinecraftError minecraftError) {
        }
        finally {
            this.func_71405_e();
        }
    }

    public void displayCrashScreen(CrashReport report) {
        try {
            if (this.shouldGenerateCrashLog()) {
                CrashUtils.outputReport(report);
            }
            this.field_71434_R = false;
            this.field_83002_am = -1L;
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_146158_b().func_146231_a();
            this.func_147108_a(new GuiCrashScreen(report));
        }
        catch (Throwable t) {
            field_147123_G.error("An uncaught exception occurred while displaying the crash screen, making normal report instead", t);
            this.func_71377_b(report);
            System.exit(report.func_71497_f() != null ? -1 : -2);
        }
    }

    private void addInfoToCrash(CrashReport crashReport) {
        crashReport.func_85056_g().func_71500_a("Client Crashes Since Restart", () -> String.valueOf(this.clientCrashCount));
        crashReport.func_85056_g().func_71500_a("Integrated Server Crashes Since Restart", () -> String.valueOf(this.serverCrashCount));
    }

    public void resetGameState() {
        try {
            int originalMemoryReserveSize = -1;
            try {
                if (field_71444_a != null) {
                    originalMemoryReserveSize = field_71444_a.length;
                    field_71444_a = new byte[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            StateManager.resetStates();
            if (this.func_147114_u() != null) {
                this.func_147114_u().func_147298_b().func_150718_a((IChatComponent)new ChatComponentText("[BetterCrashes] Client crashed"));
            }
            this.func_71403_a(null);
            if (this.field_71460_t.func_147702_a()) {
                this.field_71460_t.func_147703_b();
            }
            this.field_152351_aB.clear();
            if (originalMemoryReserveSize != -1) {
                try {
                    field_71444_a = new byte[originalMemoryReserveSize];
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            System.gc();
        }
        catch (Throwable t) {
            field_147123_G.error("Failed to reset state after a crash", t);
            try {
                StateManager.resetStates();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void displayInitErrorScreen(CrashReport report) {
        if (this.shouldGenerateCrashLog()) {
            CrashUtils.outputReport(report);
        }
        try {
            this.field_110451_am = new SimpleReloadableResourceManager(this.field_110452_an);
            this.field_71446_o = new TextureManager((IResourceManager)this.field_110451_am);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_71446_o);
            this.field_135017_as = new LanguageManager(this.field_110452_an, this.field_71474_y.field_74363_ab);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_135017_as);
            this.func_110436_a();
            this.field_71466_p = new FontRenderer(this.field_71474_y, new ResourceLocation("textures/font/ascii.png"), this.field_71446_o, false);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_71466_p);
            this.field_147127_av = new SoundHandler((IResourceManager)this.field_110451_am, this.field_71474_y);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_147127_av);
            this.field_71425_J = true;
            try {
                SplashProgress.finish();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.runGUILoop(new GuiInitErrorScreen(report));
        }
        catch (Throwable t) {
            field_147123_G.error("An uncaught exception occured while displaying the init error screen, making normal report instead", t);
            this.func_71377_b(report);
            System.exit(report.func_71497_f() != null ? -1 : -2);
        }
    }

    private void runGUILoop(GuiScreen screen) throws IOException {
        this.func_147108_a(screen);
        while (this.field_71425_J && this.field_71462_r != null && !(this.field_71462_r instanceof GuiMainMenu) && !Loader.isModLoaded((String)"custommainmenu")) {
            if (Display.isCreated() && Display.isCloseRequested()) {
                System.exit(0);
            }
            this.field_71429_W = 10000;
            this.field_71462_r.func_146269_k();
            this.field_71462_r.func_73876_c();
            GL11.glPushMatrix();
            GL11.glClear((int)16640);
            this.field_147124_at.func_147610_a(true);
            GL11.glEnable((int)3553);
            GL11.glViewport((int)0, (int)0, (int)this.field_71443_c, (int)this.field_71440_d);
            ScaledResolution scaledResolution = new ScaledResolution((Minecraft)this, this.field_71443_c, this.field_71440_d);
            GL11.glClear((int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)scaledResolution.func_78327_c(), (double)scaledResolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            GL11.glClear((int)256);
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int mouseX = Mouse.getX() * width / this.field_71443_c;
            int mouseY = height - Mouse.getY() * height / this.field_71440_d - 1;
            this.field_71462_r.func_73863_a(mouseX, mouseY, 0.0f);
            this.field_147124_at.func_147609_e();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            this.field_147124_at.func_147615_c(this.field_71443_c, this.field_71440_d);
            GL11.glPopMatrix();
            this.func_147120_f();
            Thread.yield();
            Display.sync((int)60);
            this.func_71361_d("BetterCrashes GUI Loop");
        }
    }

    @Overwrite
    public void func_71377_b(CrashReport report) {
        if (this.shouldGenerateCrashLog()) {
            CrashUtils.outputReport(report);
        }
    }

    public boolean shouldGenerateCrashLog() {
        return this.clientCrashCount <= BetterCrashesConfig.crashLogLimitClient && this.serverCrashCount <= BetterCrashesConfig.crashLogLimitServer;
    }
}

