/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.common.gui.SubGui;
import com.creativemd.creativecore.common.gui.controls.GuiButton;
import com.creativemd.creativecore.common.gui.controls.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.GuiLabel;
import com.creativemd.creativecore.common.gui.event.ControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.ControlClickEvent;
import com.creativemd.littletiles.common.items.ItemMultiTiles;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiStructure
extends SubGui {
    public ItemStack stack;
    public LittleStructure structure;
    public Object lastListener = null;

    public SubGuiStructure(ItemStack stack) {
        this.stack = stack;
    }

    public void createControls() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("none");
        lines.addAll(LittleStructure.getStructureNames());
        this.controls.add(new GuiLabel("type:", 5, 7));
        GuiComboBox comboBox = new GuiComboBox("types", 32, 5, 70, lines);
        LittleStructure structure = ItemMultiTiles.getLTStructure(this.stack);
        if (structure != null) {
            this.structure = structure;
            comboBox.index = lines.indexOf(structure.getIDOfStructure());
            if (comboBox.index == -1) {
                comboBox.index = 0;
            } else {
                comboBox.caption = structure.getIDOfStructure();
            }
        }
        this.controls.add(comboBox);
        this.controls.add(new GuiButton("save", 120, 140, 50));
        this.onChanged();
    }

    public void onChanged() {
        LittleStructure saved;
        this.removeControls(new String[]{"type:", "types", "save"});
        String id = ((GuiComboBox)this.getControl((String)"types")).caption;
        if (this.lastListener != null) {
            this.removeListener(this.lastListener);
        }
        if ((saved = this.structure) != null && !saved.getIDOfStructure().equals(id)) {
            saved = null;
        }
        LittleStructure parser = null;
        LittleStructure.LittleStructureEntry entry = LittleStructure.getEntryByID(id);
        if (entry != null) {
            parser = entry.parser;
        }
        if (parser != null) {
            parser.createControls(this, saved);
            this.refreshControls();
            this.addListener(parser);
            this.lastListener = parser;
        }
    }

    @CustomEventSubscribe
    public void onComboChange(ControlChangedEvent event) {
        if (event.source.is("types")) {
            this.onChanged();
        }
    }

    @CustomEventSubscribe
    public void onButtonClicked(ControlClickEvent event) {
        if (event.source.is("save")) {
            String id = ((GuiComboBox)this.getControl((String)"types")).caption;
            LittleStructure parser = null;
            LittleStructure.LittleStructureEntry entry = LittleStructure.getEntryByID(id);
            if (entry != null) {
                parser = entry.parser;
            }
            if (parser != null) {
                LittleStructure structure = parser.parseStructure(this);
                if (structure != null) {
                    NBTTagCompound structureNBT = new NBTTagCompound();
                    structure.writeToNBT(structureNBT);
                    this.stack.field_77990_d.func_74782_a("structure", (NBTBase)structureNBT);
                } else {
                    this.stack.field_77990_d.func_82580_o("structure");
                }
            } else {
                this.stack.field_77990_d.func_82580_o("structure");
            }
            this.sendPacketToServer(0, this.stack.field_77990_d);
            this.closeGui();
        }
    }

    public void drawOverlay(FontRenderer fontRenderer) {
    }
}

