/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.thaumcraft;

import cpw.mods.fml.common.Loader;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class AddonThaumcraftTiles
implements IWailaDataProvider {
    private static final String CONFIG_JAR_ASPECTS = "wawla.thaumcraft.jarAspect";
    private static final String CONFIG_JAR_AMOUNTS = "wawla.thaumcraft.jarAmount";
    private static final String CONFIG_JAR_EXP = "wawla.thaumcraft.jarEXP";
    private static final String CONFIG_MIRROR_LINK_POS = "wawla.thaumcraft.mirrorLink";
    private static final String CONFIG_MIRROR_LINK_DIM = "wawla.thaumcraft.mirrorDim";
    private static final String CONFIG_WAND_ITEM = "wawla.thaumcraft.wandItem";
    private static final String CONFIG_WAND_CHARGE = "wawla.thaumcraft.wandCharge";
    private static final String CONFIG_PEDESTAL_ITEM = "wawla.thaumcraft.pedestalItem";
    private static final String CONFIG_DECONSTRUCTION_ASPECT = "wawla.thaumcraft.deconAspect";
    public Class classTileJarFillable = null;
    public Class classTileJarFillableVoid = null;
    public Class classTileMirror = null;
    public Class classTileMirrorEssentia = null;
    public Class classTileJarBrain = null;
    public Class classTileWandPedestal = null;
    public Class classTilePedestal = null;
    public Class classTileDeconstructionTable = null;
    public static Class classBlockJar = null;
    public static Class classBlockMirror = null;
    public static Class classBlockStoneDevice = null;
    public static Class classBlockTable = null;

    public AddonThaumcraftTiles() {
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            try {
                this.classTileJarFillable = Class.forName("thaumcraft.common.tiles.TileJarFillable");
                this.classTileJarFillableVoid = Class.forName("thaumcraft.common.tiles.TileJarFillableVoid");
                this.classTileMirror = Class.forName("thaumcraft.common.tiles.TileMirror");
                this.classTileMirrorEssentia = Class.forName("thaumcraft.common.tiles.TileMirrorEssentia");
                this.classTileJarBrain = Class.forName("thaumcraft.common.tiles.TileJarBrain");
                this.classTileWandPedestal = Class.forName("thaumcraft.common.tiles.TileWandPedestal");
                this.classTilePedestal = Class.forName("thaumcraft.common.tiles.TilePedestal");
                this.classTileDeconstructionTable = Class.forName("thaumcraft.common.tiles.TileDeconstructionTable");
                classBlockJar = Class.forName("thaumcraft.common.blocks.BlockJar");
                classBlockMirror = Class.forName("thaumcraft.common.blocks.BlockMirror");
                classBlockStoneDevice = Class.forName("thaumcraft.common.blocks.BlockStoneDevice");
                classBlockTable = Class.forName("thaumcraft.common.blocks.BlockTable");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return data.getStack();
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        if (data.getBlock() != null && data.getTileEntity() != null) {
            ItemStack pedestalStack;
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), this.classTileJarFillable) || Utilities.compareTileEntityByClass(data.getTileEntity(), this.classTileJarFillableVoid)) {
                String aspect = data.getNBTData().func_74779_i("Aspect");
                short amount = data.getNBTData().func_74765_d("Amount");
                if (aspect != null && !aspect.isEmpty() && cfg.getConfig(CONFIG_JAR_ASPECTS)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.thaumcraft.aspect") + ": " + Utilities.upperCase(aspect));
                }
                if (amount > 0 && cfg.getConfig(CONFIG_JAR_AMOUNTS)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.amount") + ": " + amount);
                }
            }
            if ((Utilities.compareTileEntityByClass(data.getTileEntity(), this.classTileMirror) || Utilities.compareTileEntityByClass(data.getTileEntity(), this.classTileMirrorEssentia)) && data.getNBTData().func_74767_n("linked")) {
                if (cfg.getConfig(CONFIG_MIRROR_LINK_POS)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.thaumcraft.linked") + ": X:" + data.getNBTData().func_74762_e("linkX") + " Y:" + data.getNBTData().func_74762_e("linkY") + " Z:" + data.getNBTData().func_74762_e("linkZ"));
                }
                if (cfg.getConfig(CONFIG_MIRROR_LINK_DIM)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.thaumcraft.dimension") + ": " + DimensionManager.getProvider((int)data.getNBTData().func_74762_e("linkDim")).func_80007_l());
                }
            }
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), this.classTileJarBrain) && cfg.getConfig(CONFIG_JAR_EXP)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.thaumcraft.experience") + ": " + data.getNBTData().func_74762_e("XP"));
            }
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), this.classTileDeconstructionTable) && cfg.getConfig(CONFIG_DECONSTRUCTION_ASPECT)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.thaumcraft.aspect") + ": " + (data.getNBTData().func_74764_b("Aspect") ? Utilities.upperCase(data.getNBTData().func_74779_i("Aspect")) : "None"));
            }
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), this.classTilePedestal) && cfg.getConfig(CONFIG_PEDESTAL_ITEM) && (pedestalStack = Utilities.getInventoryStacks(data.getNBTData(), 1)[0]) != null) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.item") + ": " + pedestalStack.func_82833_r());
            }
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), this.classTileWandPedestal) && (pedestalStack = Utilities.getInventoryStacks(data.getNBTData(), 1)[0]) != null && pedestalStack.func_77942_o()) {
                if (cfg.getConfig(CONFIG_WAND_ITEM)) {
                    tip.add(pedestalStack.func_82833_r());
                }
                if (pedestalStack.field_77990_d.func_74764_b("aqua") && cfg.getConfig(CONFIG_WAND_CHARGE)) {
                    String split = EnumChatFormatting.WHITE + " | ";
                    tip.add(EnumChatFormatting.YELLOW + "" + (float)pedestalStack.field_77990_d.func_74762_e("aer") / 100.0f + split + EnumChatFormatting.DARK_GREEN + "" + (float)(pedestalStack.field_77990_d.func_74762_e("terra") / 100) + split + EnumChatFormatting.RED + "" + (float)pedestalStack.field_77990_d.func_74762_e("ignis") / 100.0f + split + EnumChatFormatting.DARK_AQUA + "" + (float)pedestalStack.field_77990_d.func_74762_e("aqua") / 100.0f + split + EnumChatFormatting.GRAY + "" + (float)pedestalStack.field_77990_d.func_74762_e("ordo") / 100.0f + split + EnumChatFormatting.DARK_GRAY + "" + (float)pedestalStack.field_77990_d.func_74762_e("perditio") / 100.0f);
                }
            }
        }
        return tip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonThaumcraftTiles dataProvider = new AddonThaumcraftTiles();
        register.addConfig("Thaumcraft", CONFIG_JAR_ASPECTS);
        register.addConfig("Thaumcraft", CONFIG_JAR_AMOUNTS);
        register.addConfig("Thaumcraft", CONFIG_MIRROR_LINK_POS);
        register.addConfig("Thaumcraft", CONFIG_MIRROR_LINK_DIM);
        register.addConfig("Thaumcraft", CONFIG_JAR_EXP);
        register.addConfig("Thaumcraft", CONFIG_WAND_ITEM);
        register.addConfig("Thaumcraft", CONFIG_WAND_CHARGE);
        register.addConfig("Thaumcraft", CONFIG_PEDESTAL_ITEM);
        register.addConfig("Thaumcraft", CONFIG_DECONSTRUCTION_ASPECT);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classBlockJar);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classBlockMirror);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classBlockStoneDevice);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classBlockTable);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classBlockJar);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classBlockMirror);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classBlockStoneDevice);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classBlockTable);
    }
}

