/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.api.core.BCLog;
import buildcraft.api.recipes.IProgrammingRecipe;
import buildcraft.api.recipes.IProgrammingRecipeManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ProgrammingRecipeManager
implements IProgrammingRecipeManager {
    public static final ProgrammingRecipeManager INSTANCE = new ProgrammingRecipeManager();
    private final HashMap<String, IProgrammingRecipe> recipes = new HashMap();

    @Override
    public void addRecipe(IProgrammingRecipe recipe) {
        if (recipe == null || recipe.getId() == null) {
            return;
        }
        if (!this.recipes.containsKey(recipe.getId())) {
            this.recipes.put(recipe.getId(), recipe);
        } else {
            BCLog.logger.warn("Programming Table Recipe '" + recipe.getId() + "' seems to be duplicated! This is a bug!");
        }
    }

    @Override
    public void removeRecipe(String id) {
        this.recipes.remove(id);
    }

    @Override
    public void removeRecipe(IProgrammingRecipe recipe) {
        if (recipe == null || recipe.getId() == null) {
            return;
        }
        this.recipes.remove(recipe.getId());
    }

    @Override
    public Collection<IProgrammingRecipe> getRecipes() {
        return Collections.unmodifiableCollection(this.recipes.values());
    }

    @Override
    public IProgrammingRecipe getRecipe(String id) {
        return this.recipes.get(id);
    }
}

