/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi.em_machine;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMTransformationRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.EMAtomDefinition;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.MultiblockControl;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.em_machine.GT_MetaTileEntity_EM_machine;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.DoubleCount;

public class Behaviour_ElectromagneticSeparator
implements GT_MetaTileEntity_EM_machine.IBehaviour {
    private final byte tier;
    private int ticks;
    private byte precisionFull;
    private byte precisionMinimal;
    private double maxCapacity;
    private double maxCharge;
    private int offsetMax;
    private Parameters.Group.ParameterIn fullSetting;
    private Parameters.Group.ParameterIn minimalSetting;
    private Parameters.Group.ParameterIn offsetSetting;
    private static final INameFunction<GT_MetaTileEntity_EM_machine> fullName = (gt_metaTileEntity_em_machine, iParameter) -> "Full Precision Input [e/3]";
    private final IStatusFunction<GT_MetaTileEntity_EM_machine> fullStatus = (gt_metaTileEntity_em_machine, iParameter) -> {
        double v = iParameter.get();
        if (Double.isNaN(v)) {
            return LedStatus.STATUS_WRONG;
        }
        if (Double.isInfinite(v = (double)((int)v)) && v > 0.0) {
            return LedStatus.STATUS_TOO_HIGH;
        }
        if (v > (double)this.precisionFull) {
            return LedStatus.STATUS_HIGH;
        }
        if (v < (double)this.precisionFull) {
            return LedStatus.STATUS_TOO_LOW;
        }
        return LedStatus.STATUS_OK;
    };
    private static final INameFunction<GT_MetaTileEntity_EM_machine> minimalName = (gt_metaTileEntity_em_machine, iParameter) -> "Minimal Precision Input [e/3]";
    private final IStatusFunction<GT_MetaTileEntity_EM_machine> minimalStatus = (gt_metaTileEntity_em_machine, iParameter) -> {
        double minimal = iParameter.get();
        double full = this.fullSetting.get();
        if (Double.isInfinite(minimal) && minimal > 0.0) {
            return LedStatus.STATUS_TOO_HIGH;
        }
        if (minimal > (double)this.precisionMinimal) {
            if (minimal > full) {
                return LedStatus.STATUS_TOO_HIGH;
            }
            return LedStatus.STATUS_HIGH;
        }
        if (minimal == (double)this.precisionMinimal) {
            if (minimal > full) {
                return LedStatus.STATUS_TOO_HIGH;
            }
            return LedStatus.STATUS_OK;
        }
        if (minimal < (double)this.precisionMinimal) {
            return LedStatus.STATUS_TOO_LOW;
        }
        return LedStatus.STATUS_WRONG;
    };
    private static final INameFunction<GT_MetaTileEntity_EM_machine> offsetName = (gt_metaTileEntity_em_machine, iParameter) -> "Offset Input [e/3]";
    private final IStatusFunction<GT_MetaTileEntity_EM_machine> offsetStatus = (gt_metaTileEntity_em_machine, iParameter) -> {
        double offset = iParameter.get();
        if (offset > (double)this.offsetMax) {
            return LedStatus.STATUS_TOO_HIGH;
        }
        if (offset > 0.0) {
            return LedStatus.STATUS_HIGH;
        }
        if (offset == 0.0) {
            return LedStatus.STATUS_OK;
        }
        if (offset >= (double)(-this.offsetMax)) {
            return LedStatus.STATUS_LOW;
        }
        if (offset < (double)(-this.offsetMax)) {
            return LedStatus.STATUS_TOO_LOW;
        }
        return LedStatus.STATUS_WRONG;
    };

    public Behaviour_ElectromagneticSeparator(int desiredTier) {
        this.tier = (byte)desiredTier;
        this.ticks = Math.max(20, (1 << 12 - desiredTier) * 20);
        this.maxCapacity = EMAtomDefinition.getSomethingHeavy().getMass() * (double)(2 << this.tier) * EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED;
        this.maxCharge = 144.0 * (double)(1 << this.tier - 5);
        switch (this.tier) {
            case 12: {
                this.precisionFull = 1;
                this.precisionMinimal = 1;
                break;
            }
            case 11: {
                this.precisionFull = (byte)2;
                this.precisionMinimal = 1;
                break;
            }
            case 10: {
                this.precisionFull = (byte)3;
                this.precisionMinimal = 1;
                break;
            }
            case 9: {
                this.precisionFull = (byte)3;
                this.precisionMinimal = (byte)2;
                break;
            }
            case 8: {
                this.precisionFull = (byte)3;
                this.precisionMinimal = (byte)3;
                break;
            }
            case 7: {
                this.precisionFull = (byte)6;
                this.precisionMinimal = (byte)3;
                break;
            }
            case 6: {
                this.precisionFull = (byte)12;
                this.precisionMinimal = (byte)3;
                break;
            }
            case 5: {
                this.precisionFull = (byte)24;
                this.precisionMinimal = (byte)6;
                break;
            }
            default: {
                this.precisionMinimal = (byte)127;
                this.precisionFull = (byte)127;
            }
        }
        this.offsetMax = 1 << (this.tier - 8 << 1);
    }

    @Override
    public void parametersInstantiation(GT_MetaTileEntity_EM_machine te, Parameters parameters) {
        Parameters.Group hatch1 = parameters.getGroup(7);
        this.fullSetting = hatch1.makeInParameter(0, 0.0, fullName, this.fullStatus);
        this.minimalSetting = hatch1.makeInParameter(1, 2.0, minimalName, this.minimalStatus);
        Parameters.Group hatch2 = parameters.getGroup(8);
        this.offsetSetting = hatch2.makeInParameter(0, 0.0, offsetName, this.offsetStatus);
    }

    @Override
    public boolean checkParametersInAndSetStatuses(GT_MetaTileEntity_EM_machine te, Parameters parameters) {
        return this.fullSetting.getStatus((boolean)true).isOk && this.minimalSetting.getStatus((boolean)true).isOk && this.offsetSetting.getStatus((boolean)true).isOk;
    }

    @Override
    public MultiblockControl<EMInstanceStackMap[]> process(EMInstanceStackMap[] inputs, GT_MetaTileEntity_EM_machine te, Parameters parameters) {
        EMInstanceStackMap input = inputs[0];
        if (input == null || input.isEmpty()) {
            return null;
        }
        EMInstanceStack[] stacks = (EMInstanceStack[])input.valuesToArray();
        double inputMass = 0.0;
        for (EMInstanceStack stack : stacks) {
            inputMass += Math.abs(stack.getMass());
        }
        float excessMass = 0.0f;
        while (inputMass > this.maxCapacity) {
            EMInstanceStack randomStack = stacks[TecTech.RANDOM.nextInt(stacks.length)];
            double amountToRemove = TecTech.RANDOM.nextDouble() / 10.0 * randomStack.getAmount();
            randomStack.setAmount(DoubleCount.sub(randomStack.getAmount(), amountToRemove));
            if (randomStack.isInvalidAmount()) {
                input.removeKey(randomStack.getDefinition());
            }
            double mass = Math.abs(randomStack.getDefinition().getMass()) * amountToRemove;
            excessMass = (float)((double)excessMass + mass);
            inputMass -= mass;
        }
        double totalCharge = Math.abs(input.getCharge());
        if (totalCharge > this.maxCharge) {
            return new MultiblockControl<EMInstanceStackMap[]>(excessMass);
        }
        int mEut = (int)(totalCharge / this.maxCharge * (double)CommonValues.V[this.tier]);
        mEut = Math.max(mEut, 512);
        int mTicks = (int)((double)this.ticks * (inputMass / this.maxCapacity));
        mTicks = Math.max(mTicks, 20);
        EMInstanceStackMap[] outputs = new EMInstanceStackMap[3];
        for (int i = 0; i < 3; ++i) {
            outputs[i] = new EMInstanceStackMap();
        }
        double offsetIn = this.offsetSetting.get();
        double precisionFullIn = this.fullSetting.get();
        double precisionMinimalIn = this.minimalSetting.get();
        double levelsCountPlus1 = precisionFullIn - precisionMinimalIn + 1.0;
        for (EMInstanceStack stack : stacks = (EMInstanceStack[])input.takeAll().valuesToArray()) {
            double charge = (double)stack.getDefinition().getCharge() - offsetIn;
            if (charge < precisionMinimalIn && charge > -precisionMinimalIn) {
                outputs[1].putReplace(stack);
                continue;
            }
            if (charge >= precisionFullIn) {
                outputs[2].putReplace(stack);
                continue;
            }
            if (charge <= -precisionFullIn) {
                outputs[0].putReplace(stack);
                continue;
            }
            double amount = DoubleCount.mul(stack.getAmount(), (Math.abs(charge) - precisionMinimalIn + 1.0) / levelsCountPlus1);
            if (amount < stack.getAmount()) {
                EMInstanceStack clone = stack.clone();
                clone.setAmount(DoubleCount.sub(clone.getAmount(), amount));
                outputs[1].putReplace(clone);
                stack.setAmount(amount);
            }
            if (charge > 0.0) {
                outputs[2].putReplace(stack);
                continue;
            }
            outputs[0].putReplace(stack);
        }
        return new MultiblockControl<EMInstanceStackMap[]>(outputs, mEut, 1 + (int)Math.abs(offsetIn) / 3, 0, 10000, mTicks, 0, excessMass);
    }
}

