/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.single;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.thing.metaTileEntity.Textures;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OverflowElemental;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.TT_Utility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.common.GT_Pollution;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_DebugPollutor
extends GT_MetaTileEntity_TieredMachineBlock
implements IAddUIWidgets,
IAddGregtechLogo {
    private static GT_RenderedTexture POLLUTOR;
    public int pollution = 0;
    public float anomaly = 0.0f;

    public GT_MetaTileEntity_DebugPollutor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.pollutor.desc.0"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.pollutor.desc.1"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.pollutor.desc.2")}, new ITexture[0]);
        TT_Utility.setTier(aTier, (Object)this);
    }

    public GT_MetaTileEntity_DebugPollutor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        TT_Utility.setTier(aTier, (Object)this);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DebugPollutor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        POLLUTOR = new GT_RenderedTexture((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/POLLUTOR"));
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.MACHINE_CASINGS_TT[this.mTier][colorIndex + 1];
        iTextureArray[1] = side != facing ? (aActive ? new GT_RenderedTexture((IIconContainer)GT_MetaTileEntity_Hatch_OverflowElemental.MufflerEM) : new GT_RenderedTexture((IIconContainer)GT_MetaTileEntity_Hatch_OverflowElemental.MufflerEMidle)) : POLLUTOR;
        return iTextureArray;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("ePollution", this.pollution);
        aNBT.func_74776_a("eAnomaly", this.anomaly);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.pollution = aNBT.func_74762_e("ePollution");
        this.anomaly = aNBT.func_74760_g("eAnomaly");
        this.getBaseMetaTileEntity().setActive(this.anomaly > 0.0f || this.pollution > 0);
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(this.anomaly > 0.0f || this.pollution > 0);
            if (this.anomaly > 0.0f) {
                TecTech.anomalyHandler.addAnomaly(aBaseMetaTileEntity, (double)this.anomaly);
            }
            if (this.pollution > 0) {
                GT_Pollution.addPollution((IGregTechTileEntity)aBaseMetaTileEntity, (int)this.pollution);
            }
        } else if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (side == aBaseMetaTileEntity.getFrontFacing()) continue;
                TecTech.proxy.em_particle(aBaseMetaTileEntity, side);
                TecTech.proxy.pollutor_particle(aBaseMetaTileEntity, side);
            }
        }
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isElectric() {
        return false;
    }

    public boolean useModularUI() {
        return true;
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT_GRAY).setSize(17, 17).setPos(113, 56));
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setSize(90, 72).setPos(43, 4))).widget(TextWidget.dynamicString(() -> "Pollution: " + this.pollution).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 8))).widget(TextWidget.dynamicString(() -> "Anomaly: " + this.anomaly).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 16));
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.pollution -= val.intValue(), 512, 64, 7, 4);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.pollution /= val.intValue(), 512, 64, 7, 22);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.anomaly -= (float)val.intValue(), 512, 64, 7, 40);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.anomaly /= (float)val.intValue(), 512, 64, 7, 58);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.pollution -= val.intValue(), 16, 1, 25, 4);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.pollution /= val.intValue(), 16, 2, 25, 22);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.anomaly -= (float)val.intValue(), 16, 1, 25, 40);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.anomaly /= (float)val.intValue(), 16, 2, 25, 58);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.pollution += val.intValue(), 16, 1, 133, 4);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.pollution *= val.intValue(), 16, 2, 133, 22);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.anomaly += (float)val.intValue(), 16, 1, 133, 40);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.anomaly *= (float)val.intValue(), 16, 2, 133, 58);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.pollution += val.intValue(), 512, 64, 151, 4);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.pollution *= val.intValue(), 512, 64, 151, 22);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.anomaly += (float)val.intValue(), 512, 64, 151, 40);
        this.addChangeNumberButton(builder, (IDrawable)GT_UITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.anomaly *= (float)val.intValue(), 512, 64, 151, 58);
    }

    private void addChangeNumberButton(ModularWindow.Builder builder, IDrawable overlay, Consumer<Integer> setter, int changeNumberShift, int changeNumber, int xPos, int yPos) {
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            setter.accept(clickData.shift ? changeNumberShift : changeNumber);
            if (this.anomaly == Float.POSITIVE_INFINITY) {
                this.anomaly = Float.MAX_VALUE;
            } else if (this.anomaly == Float.NEGATIVE_INFINITY) {
                this.anomaly = -3.4028235E38f;
            }
        }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, overlay}).setSize(18, 18).setPos(xPos, yPos));
    }
}

