/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.entity.DoorFactoryTileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MalisisMessage
public class DoorFactoryMessage
implements IMessageHandler<Packet, IMessage> {
    public DoorFactoryMessage() {
        MalisisDoors.network.registerMessage((IMessageHandler)this, Packet.class, Side.SERVER);
    }

    public IMessage onMessage(Packet message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        DoorFactoryTileEntity te = (DoorFactoryTileEntity)((Object)TileEntityUtils.getTileEntity(DoorFactoryTileEntity.class, (IBlockAccess)world, (int)message.x, (int)message.y, (int)message.z));
        if (te == null) {
            return null;
        }
        if (message.type == Packet.TYPE_DOORINFOS) {
            te.setCreate(message.isCreate);
            te.setDoorMovement(DoorRegistry.getMovement(message.movement));
            te.setDoorSound(DoorRegistry.getSound(message.sound));
            te.setOpeningTime(message.openTime);
            te.setAutoCloseTime(message.autoCloseTime);
            te.setRequireRedstone(message.redstone);
            te.setDoubleDoor(message.doubleDoor);
            te.setCode(message.code);
        } else {
            te.createDoor();
        }
        return null;
    }

    public static void sendDoorInformations(DoorFactoryTileEntity te) {
        Packet packet = new Packet(Packet.TYPE_DOORINFOS, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        packet.setDoorInfos(te);
        MalisisDoors.network.sendToServer((IMessage)packet);
    }

    public static void sendCreateDoor(DoorFactoryTileEntity te) {
        Packet packet = new Packet(Packet.TYPE_CREATEDOOR, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        MalisisDoors.network.sendToServer((IMessage)packet);
    }

    public static class Packet
    implements IMessage {
        private static int TYPE_DOORINFOS = 0;
        private static int TYPE_CREATEDOOR = 1;
        private int x;
        private int y;
        private int z;
        private int type;
        private boolean isCreate;
        private String movement;
        private String sound;
        private int openTime;
        private int autoCloseTime;
        private boolean redstone;
        private boolean doubleDoor;
        private String code;

        public Packet() {
        }

        public Packet(int type, int x, int y, int z) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void setDoorInfos(DoorFactoryTileEntity te) {
            String movement = DoorRegistry.getId(te.getDoorMovement());
            String sound = DoorRegistry.getId(te.getDoorSound());
            this.isCreate = te.isCreate();
            this.movement = movement;
            this.sound = sound;
            this.openTime = te.getOpeningTime();
            this.autoCloseTime = te.getAutoCloseTime();
            this.redstone = te.requireRedstone();
            this.doubleDoor = te.isDoubleDoor();
            this.code = te.getCode();
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            this.type = buf.readInt();
            if (this.type == TYPE_DOORINFOS) {
                this.isCreate = buf.readBoolean();
                this.movement = ByteBufUtils.readUTF8String((ByteBuf)buf);
                if (this.movement.equals("")) {
                    this.movement = null;
                }
                this.sound = ByteBufUtils.readUTF8String((ByteBuf)buf);
                if (this.sound.equals("")) {
                    this.sound = null;
                }
                this.openTime = buf.readInt();
                this.autoCloseTime = buf.readInt();
                this.redstone = buf.readBoolean();
                this.doubleDoor = buf.readBoolean();
                this.code = ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
            buf.writeInt(this.type);
            if (this.type == TYPE_DOORINFOS) {
                buf.writeBoolean(this.isCreate);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.movement != null ? this.movement : ""));
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.sound != null ? this.sound : ""));
                buf.writeInt(this.openTime);
                buf.writeInt(this.autoCloseTime);
                buf.writeBoolean(this.redstone);
                buf.writeBoolean(this.doubleDoor);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.code != null ? this.code : ""));
            }
        }
    }
}

