/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealthmod.configuration;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration config;
    public static boolean showDamageParticles;
    public static boolean showAlways;
    public static Integer damageColor;
    public static Integer healColor;
    public static double size;
    private static final String[] acceptedColors;

    public static void init(String configDir) {
        if (config == null) {
            File path = new File(configDir + "/" + "torohealthmod" + ".cfg");
            config = new Configuration(path);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        showDamageParticles = config.getBoolean("Show Damage Particles", "general", true, "Show Damage Indicators");
        showAlways = config.getBoolean("Show Always Particles", "general", false, "Show Always The Damage Particles");
        size = config.get("general", "Particles Size", size, "Particles Size [default: 3.0]").getDouble();
        healColor = ConfigurationHandler.mapColor(config.getString("Heal Color", "general", "GREEN", "Heal Text Color", acceptedColors));
        damageColor = ConfigurationHandler.mapColor(config.getString("Damage Color", "general", "RED", "Damage Text Color", acceptedColors));
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangeEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("torohealthmod")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    private static int mapColor(String color) {
        if (color.equals("RED")) {
            return 0xFF0000;
        }
        if (color.equals("GREEN")) {
            return 65280;
        }
        if (color.equals("BLUE")) {
            return 255;
        }
        if (color.equals("YELLOW")) {
            return 0xFFFF00;
        }
        if (color.equals("ORANGE")) {
            return 16753920;
        }
        if (color.equals("BLACK")) {
            return 0;
        }
        if (color.equals("PURPLE")) {
            return 0x960096;
        }
        return 0xFFFFFF;
    }

    static {
        showDamageParticles = true;
        showAlways = false;
        size = 3.0;
        acceptedColors = new String[]{"RED", "GREEN", "BLUE", "YELLOW", "ORANGE", "WHITE", "BLACK", "PURPLE"};
    }
}

