/*
 * Decompiled with CFR 0.152.
 */
package io.github.legacymoddingmc.unimixins.compat.asm;

import com.google.common.primitives.Bytes;
import io.github.legacymoddingmc.unimixins.compat.CompatCore;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMRemapperTransformer
implements IClassTransformer {
    private static Set<String> interfaceWhitelist = new HashSet<String>();
    private static Set<String> packageWhitelist = new HashSet<String>();
    private static final boolean remapSelectively = Boolean.parseBoolean(System.getProperty("unimixins.compat.remapSelectively", "false"));
    private static final List<String> ASM_PACKAGE_PREFIXES = Arrays.asList("org/spongepowered/libraries/org/objectweb/asm/", "org/spongepowered/asm/lib/");
    private static String realASMPackagePrefix;

    public static void registerInterface(String itf) {
        interfaceWhitelist.add(itf.replace('.', '/'));
    }

    public static void registerPackage(String pkg) {
        packageWhitelist.add(pkg + ".");
    }

    public ASMRemapperTransformer() {
        ASMRemapperTransformer.registerInterface("org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (transformedName.startsWith("io.github.legacymoddingmc.unimixins.compat.asm.") || transformedName.startsWith("com.google.") || transformedName.startsWith("org.apache.") || transformedName.startsWith("org.objectweb.asm.")) {
            return basicClass;
        }
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        ClassReader classReaderForNode = new ClassReader(basicClass);
        classReaderForNode.accept((ClassVisitor)classNode, 0);
        boolean doRemap = false;
        if (remapSelectively) {
            if (!doRemap) {
                for (String itf : classNode.interfaces) {
                    if (!interfaceWhitelist.contains(itf)) continue;
                    doRemap = true;
                }
            }
            if (!doRemap) {
                for (String pkg : packageWhitelist) {
                    if (!transformedName.startsWith(pkg)) continue;
                    doRemap = true;
                }
            }
        } else {
            boolean bl = doRemap = Bytes.indexOf((byte[])basicClass, (byte[])ASMRemapperTransformer.getFakeASMPackagePrefix().getBytes()) != -1;
        }
        if (doRemap) {
            CompatCore.LOGGER.info("Transforming class " + transformedName + " to fit current mixin environment.");
            ClassWriter classWriter = new ClassWriter(1);
            SpongepoweredASMRemappingAdapter remapAdapter = new SpongepoweredASMRemappingAdapter(classWriter);
            classReader.accept((ClassVisitor)remapAdapter, 8);
            basicClass = classWriter.toByteArray();
        }
        return basicClass;
    }

    private static String getRealASMPackagePrefix() {
        if (realASMPackagePrefix == null) {
            try {
                ClassReader cr = new ClassReader(Launch.classLoader.getClassBytes("org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin"));
                ClassNode cn = new ClassNode();
                cr.accept((ClassVisitor)cn, 0);
                for (MethodNode m : cn.methods) {
                    if (!m.name.equals("preApply")) continue;
                    int classNodeDescStart = StringUtils.ordinalIndexOf((CharSequence)m.desc, (CharSequence)"L", (int)2);
                    int classNodeDescEnd = StringUtils.ordinalIndexOf((CharSequence)m.desc, (CharSequence)"L", (int)3);
                    String classNodeName = m.desc.substring(classNodeDescStart + 1, classNodeDescEnd - 1);
                    realASMPackagePrefix = classNodeName.substring(0, classNodeName.indexOf("tree/ClassNode"));
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to determine real package name Mixin's shaded ASM.");
            }
            finally {
                if (realASMPackagePrefix == null) {
                    realASMPackagePrefix = "UNKNOWN";
                }
                CompatCore.LOGGER.debug("Resolved real package prefix to: " + realASMPackagePrefix);
            }
        }
        return realASMPackagePrefix;
    }

    private static String getFakeASMPackagePrefix() {
        return ASM_PACKAGE_PREFIXES.get(ASM_PACKAGE_PREFIXES.get(0).equals(ASMRemapperTransformer.getRealASMPackagePrefix()) ? 1 : 0);
    }

    private static class SpongepoweredASMRemapper
    extends Remapper {
        public static final Remapper INSTANCE = new SpongepoweredASMRemapper();

        private SpongepoweredASMRemapper() {
        }

        public String map(String typeName) {
            for (String s : ASM_PACKAGE_PREFIXES) {
                if (!typeName.startsWith(s)) continue;
                String newName = ASMRemapperTransformer.getRealASMPackagePrefix() + typeName.substring(s.length());
                return newName;
            }
            return super.map(typeName);
        }
    }

    private static class SpongepoweredASMRemappingAdapter
    extends RemappingClassAdapter {
        public SpongepoweredASMRemappingAdapter(ClassWriter classWriter) {
            super((ClassVisitor)classWriter, SpongepoweredASMRemapper.INSTANCE);
        }
    }
}

