/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;

public interface IGT_RecipeMap {
    public void addDownstream(IGT_RecipeMap var1);

    @Nonnull
    public Collection<GT_Recipe> doAdd(GT_RecipeBuilder var1);

    default public IGT_RecipeMap deepCopyInput() {
        return IGT_RecipeMap.newRecipeMap(b -> this.doAdd(b.copy()));
    }

    public static IGT_RecipeMap newRecipeMap(final Function<? super GT_RecipeBuilder, Collection<GT_Recipe>> func) {
        return new IGT_RecipeMap(){
            private final Collection<IGT_RecipeMap> downstreams = new ArrayList<IGT_RecipeMap>();

            @Override
            public void addDownstream(IGT_RecipeMap downstream) {
                this.downstreams.add(downstream);
            }

            @Override
            @Nonnull
            public Collection<GT_Recipe> doAdd(GT_RecipeBuilder builder) {
                ArrayList<Collection<Collection<GT_Recipe>>> ret = new ArrayList<Collection<Collection<GT_Recipe>>>();
                Collection out = (Collection)func.apply(builder);
                ret.add(out);
                builder.clearInvalid();
                if (!out.isEmpty()) {
                    for (IGT_RecipeMap downstream : this.downstreams) {
                        ret.add(downstream.doAdd(builder));
                    }
                }
                return GT_Utility.concat(ret);
            }
        };
    }
}

