/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ApiaryModifier;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Item_03;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;

public enum GT_ApiaryUpgrade {
    speed1(UNIQUE_INDEX.SPEED_UPGRADE, 32200, 1, (mods, n) -> {
        mods.maxSpeed = 1;
    }),
    speed2(UNIQUE_INDEX.SPEED_UPGRADE, 32201, 1, (mods, n) -> {
        mods.maxSpeed = 2;
    }),
    speed3(UNIQUE_INDEX.SPEED_UPGRADE, 32202, 1, (mods, n) -> {
        mods.maxSpeed = 3;
    }),
    speed4(UNIQUE_INDEX.SPEED_UPGRADE, 32203, 1, (mods, n) -> {
        mods.maxSpeed = 4;
    }),
    speed5(UNIQUE_INDEX.SPEED_UPGRADE, 32204, 1, (mods, n) -> {
        mods.maxSpeed = 5;
    }),
    speed6(UNIQUE_INDEX.SPEED_UPGRADE, 32205, 1, (mods, n) -> {
        mods.maxSpeed = 6;
    }),
    speed7(UNIQUE_INDEX.SPEED_UPGRADE, 32206, 1, (mods, n) -> {
        mods.maxSpeed = 7;
    }),
    speed8(UNIQUE_INDEX.SPEED_UPGRADE, 32207, 1, (mods, n) -> {
        mods.maxSpeed = 8;
    }),
    speed8upgraded(UNIQUE_INDEX.SPEED_UPGRADE, 32208, 1, (mods, n) -> {
        mods.maxSpeed = 8;
        mods.production = 17.199268f;
        mods.energy = (float)((double)mods.energy * 14.75);
    }),
    production(UNIQUE_INDEX.PRODUCTION_UPGRADE, 32209, 8, (mods, n) -> {
        mods.production = 4.0f * (float)Math.pow(1.2, n.intValue());
        mods.energy = (float)((double)mods.energy * Math.pow(1.4f, n.intValue()));
    }),
    plains(UNIQUE_INDEX.PLAINS_UPGRADE, 32210, 1, (mods, n) -> {
        mods.biomeOverride = BiomeGenBase.field_76772_c;
        mods.energy *= 1.2f;
    }),
    light(UNIQUE_INDEX.LIGHT_UPGRADE, 32211, 1, (mods, n) -> {
        mods.isSelfLighted = true;
        mods.energy *= 1.05f;
    }),
    flowering(UNIQUE_INDEX.FLOWERING_UPGRADE, 32212, 8, (mods, n) -> {
        mods.flowering = (float)((double)mods.flowering * Math.pow(1.2f, n.intValue()));
        mods.energy = (float)((double)mods.energy * Math.pow(1.1f, n.intValue()));
    }),
    winter(UNIQUE_INDEX.WINTER_UPGRADE, 32213, 1, (mods, n) -> {
        mods.biomeOverride = BiomeGenBase.field_76768_g;
        mods.energy *= 1.5f;
    }),
    dryer(UNIQUE_INDEX.DRYER_UPGRADE, 32214, 16, (mods, n) -> {
        mods.humidity -= 0.125f * (float)n.intValue();
        mods.energy = (float)((double)mods.energy * Math.pow(1.025f, n.intValue()));
    }),
    automation(UNIQUE_INDEX.AUTOMATION_UPGRADE, 32215, 1, (mods, n) -> {
        mods.isAutomated = true;
        mods.energy *= 1.1f;
    }),
    humidifier(UNIQUE_INDEX.HUMIDIFIER_UPGRADE, 32216, 16, (mods, n) -> {
        mods.humidity += 0.125f * (float)n.intValue();
        mods.energy = (float)((double)mods.energy * Math.pow(1.05f, n.intValue()));
    }),
    hell(UNIQUE_INDEX.HELL_UPGRADE, 32217, 1, (mods, n) -> {
        mods.biomeOverride = BiomeGenBase.field_76778_j;
        mods.energy *= 1.5f;
    }),
    pollen(UNIQUE_INDEX.POLLEN_UPGRADE, 32218, 1, (mods, n) -> {
        mods.flowering = 0.0f;
        mods.energy *= 1.3f;
    }),
    desert(UNIQUE_INDEX.DESERT_UPGRADE, 32219, 1, (mods, n) -> {
        mods.biomeOverride = BiomeGenBase.field_76769_d;
        mods.energy *= 1.2f;
    }),
    cooler(UNIQUE_INDEX.COOLER_UPGRADE, 32220, 16, (mods, n) -> {
        mods.temperature -= 0.125f * (float)n.intValue();
        mods.energy = (float)((double)mods.energy * Math.pow(1.025f, n.intValue()));
    }),
    lifespan(UNIQUE_INDEX.LIFESPAN_UPGRADE, 32221, 4, (mods, n) -> {
        mods.lifespan = (float)((double)mods.lifespan / Math.pow(1.5, n.intValue()));
        mods.energy = (float)((double)mods.energy * Math.pow(1.05f, n.intValue()));
    }),
    seal(UNIQUE_INDEX.SEAL_UPGRADE, 32222, 1, (mods, n) -> {
        mods.isSealed = true;
        mods.energy *= 1.05f;
    }),
    stabilizer(UNIQUE_INDEX.STABILIZER_UPGRADE, 32223, 1, (mods, n) -> {
        mods.geneticDecay = 0.0f;
        mods.energy *= 2.5f;
    }),
    jungle(UNIQUE_INDEX.JUNGLE_UPGRADE, 32224, 1, (mods, n) -> {
        mods.biomeOverride = BiomeGenBase.field_76782_w;
        mods.energy *= 1.2f;
    }),
    territory(UNIQUE_INDEX.TERRITORY_UPGRADE, 32225, 4, (mods, n) -> {
        mods.territory = (float)((double)mods.territory * Math.pow(1.5, n.intValue()));
        mods.energy = (float)((double)mods.energy * Math.pow(1.05f, n.intValue()));
    }),
    ocean(UNIQUE_INDEX.OCEAN_UPGRADE, 32226, 1, (mods, n) -> {
        mods.biomeOverride = BiomeGenBase.field_76771_b;
        mods.energy *= 1.2f;
    }),
    sky(UNIQUE_INDEX.SKY_UPGRADE, 32227, 1, (mods, n) -> {
        mods.isSunlightSimulated = true;
        mods.energy *= 1.05f;
    }),
    heater(UNIQUE_INDEX.HEATER_UPGRADE, 32228, 8, (mods, n) -> {
        mods.temperature += 0.25f * (float)n.intValue();
        mods.energy = (float)((double)mods.energy * Math.pow(1.05f, n.intValue()));
    }),
    sieve(UNIQUE_INDEX.SIEVE_UPGRADE, 32229, 1, (mods, n) -> {
        mods.isCollectingPollen = true;
        mods.energy *= 1.05f;
    }),
    unlight(UNIQUE_INDEX.LIGHT_UPGRADE, 32231, 1, (mods, n) -> {
        mods.isSelfUnlighted = true;
        mods.energy *= 1.05f;
    });

    private static final EnumMap<UNIQUE_INDEX, ArrayList<GT_ApiaryUpgrade>> UNIQUE_UPGRADE_LIST;
    private int meta = 0;
    private int maxnumber = 1;
    private final GT_Utility.ItemId id;
    private final UNIQUE_INDEX unique_index;
    private final BiConsumer<GT_ApiaryModifier, Integer> applier;
    private final HashSet<GT_Utility.ItemId> blacklistedUpgrades = new HashSet();
    private static final HashMap<Integer, GT_ApiaryUpgrade> quickLookup;

    private GT_ApiaryUpgrade(UNIQUE_INDEX unique_index, int meta, int maxnumber, BiConsumer<GT_ApiaryModifier, Integer> applier) {
        this.unique_index = unique_index;
        this.meta = meta;
        this.maxnumber = maxnumber;
        this.applier = applier;
        this.id = GT_Utility.ItemId.createNoCopy(this.get(1));
    }

    private void setup_static_variables() {
        quickLookup.put(this.meta, this);
        ArrayList<GT_ApiaryUpgrade> un = UNIQUE_UPGRADE_LIST.get((Object)this.unique_index);
        if (un != null) {
            un.forEach(u -> {
                u.blacklistedUpgrades.add(this.id);
                this.blacklistedUpgrades.add(u.id);
            });
        } else {
            un = new ArrayList(1);
            UNIQUE_UPGRADE_LIST.put(this.unique_index, un);
        }
        un.add(this);
    }

    public static GT_ApiaryUpgrade getUpgrade(ItemStack s) {
        if (s == null) {
            return null;
        }
        if (!GT_ApiaryUpgrade.isUpgrade(s)) {
            return null;
        }
        return quickLookup.get(s.func_77960_j());
    }

    public boolean isAllowedToWorkWith(ItemStack s) {
        GT_Utility.ItemId id = GT_Utility.ItemId.createNoCopy(s);
        return !this.blacklistedUpgrades.contains(id);
    }

    public int getMaxNumber() {
        return this.maxnumber;
    }

    public void applyModifiers(GT_ApiaryModifier mods, ItemStack stack) {
        if (this.applier != null) {
            this.applier.accept(mods, stack.field_77994_a);
        }
    }

    public ItemStack get(int count) {
        return new ItemStack((Item)GT_MetaGenerated_Item_03.INSTANCE, count, this.meta);
    }

    public static boolean isUpgrade(ItemStack s) {
        return OrePrefixes.apiaryUpgrade.contains(s);
    }

    static {
        UNIQUE_UPGRADE_LIST = new EnumMap(UNIQUE_INDEX.class);
        quickLookup = new HashMap();
        EnumSet.allOf(GT_ApiaryUpgrade.class).forEach(GT_ApiaryUpgrade::setup_static_variables);
        GT_ApiaryUpgrade.speed8upgraded.blacklistedUpgrades.add(GT_ApiaryUpgrade.production.id);
        GT_ApiaryUpgrade.production.blacklistedUpgrades.add(GT_ApiaryUpgrade.speed8upgraded.id);
    }

    private static enum UNIQUE_INDEX {
        SPEED_UPGRADE,
        PRODUCTION_UPGRADE,
        PLAINS_UPGRADE,
        LIGHT_UPGRADE,
        FLOWERING_UPGRADE,
        WINTER_UPGRADE,
        DRYER_UPGRADE,
        AUTOMATION_UPGRADE,
        HUMIDIFIER_UPGRADE,
        HELL_UPGRADE,
        POLLEN_UPGRADE,
        DESERT_UPGRADE,
        COOLER_UPGRADE,
        LIFESPAN_UPGRADE,
        SEAL_UPGRADE,
        STABILIZER_UPGRADE,
        JUNGLE_UPGRADE,
        TERRITORY_UPGRADE,
        OCEAN_UPGRADE,
        SKY_UPGRADE,
        HEATER_UPGRADE,
        SIEVE_UPGRADE;


        void apply(Consumer<GT_ApiaryUpgrade> fn) {
            ((ArrayList)UNIQUE_UPGRADE_LIST.get((Object)this)).forEach(fn);
        }
    }
}

