/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.client.renderer.common.CommonFramingRenderer;
import com.jaquadro.minecraft.storagedrawers.core.ClientProxy;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelper;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class FramingTableRenderer
implements ISimpleBlockRenderingHandler {
    private CommonFramingRenderer framingRenderer = new CommonFramingRenderer();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        boolean depthMask;
        if (!(block instanceof BlockFramingTable)) {
            return;
        }
        BlockFramingTable framingTable = (BlockFramingTable)block;
        boolean blendEnabled = GL11.glIsEnabled((int)3042);
        if (blendEnabled) {
            GL11.glDisable((int)3042);
        }
        if (!(depthMask = GL11.glGetBoolean((int)2930))) {
            GL11.glDepthMask((boolean)true);
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.15f, (float)-0.5f, (float)-0.5f);
        GL11.glScalef((float)0.65f, (float)0.65f, (float)0.65f);
        RenderHelper.instance.state.setUVRotation(1, RenderHelper.instance.state.rotateTransform);
        this.framingRenderer.renderRight(null, 0, 0, 0, framingTable);
        this.framingRenderer.renderLeft(null, -1, 0, 0, framingTable);
        RenderHelper.instance.state.clearUVRotation(1);
        if (!blendEnabled) {
            GL11.glDisable((int)3042);
        }
        if (!depthMask) {
            GL11.glDepthMask((boolean)false);
        }
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean right;
        if (!(block instanceof BlockFramingTable)) {
            return false;
        }
        BlockFramingTable framingTable = (BlockFramingTable)block;
        int meta = world.func_72805_g(x, y, z);
        int side = meta & 7;
        boolean bl = right = (meta & 8) == 0;
        if (side == 2 || side == 3) {
            right = !right;
        }
        RenderHelper.instance.state.setRotateTransform(side, 2);
        RenderHelper.instance.state.setUVRotation(1, RenderHelper.instance.state.rotateTransform);
        if (ClientProxy.renderPass == 0) {
            if (right) {
                this.framingRenderer.renderRight(world, x, y, z, framingTable);
            } else {
                this.framingRenderer.renderLeft(world, x, y, z, framingTable);
            }
        } else if (ClientProxy.renderPass == 1) {
            if (right) {
                this.framingRenderer.renderOverlayRight(world, x, y, z, framingTable);
            } else {
                this.framingRenderer.renderOverlayLeft(world, x, y, z, framingTable);
            }
        }
        RenderHelper.instance.state.clearRotateTransform();
        RenderHelper.instance.state.clearUVRotation(1);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return StorageDrawers.proxy.framingTableRenderID;
    }
}

