/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.opencomputers;

import appeng.items.misc.ItemEncodedPattern;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.tile.TileOCPatternEditor;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.Util;
import li.cil.oc.api.driver.EnvironmentProvider;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class DriverOCPatternEditor
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return TileOCPatternEditor.class;
    }

    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection forgeDirection) {
        return new Environment((TileOCPatternEditor)world.func_147438_o(x, y, z));
    }

    public static class Environment
    extends ManagedTileEntityEnvironment<TileOCPatternEditor>
    implements NamedBlock {
        public Environment(TileOCPatternEditor tileEntity) {
            super((Object)tileEntity, "oc_pattern_editor");
        }

        private int optSlot(Arguments args, IInventory inv, int index, int def) {
            if (index >= 0 && index < args.count()) {
                int slot = args.checkInteger(index) - 1;
                if (slot < 0 || slot >= inv.func_70302_i_()) {
                    throw new IllegalArgumentException("invalid slot");
                }
                return slot;
            }
            return def;
        }

        private int checkSlot(Arguments args, IInventory inv, int index) {
            if (index >= 0 && index < args.count()) {
                int slot = args.checkInteger(index) - 1;
                if (slot < 0 || slot >= inv.func_70302_i_()) {
                    throw new IllegalArgumentException("invalid slot");
                }
                return slot;
            }
            throw new IllegalArgumentException("invalid slot");
        }

        private boolean validPattern(ItemStack pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException("No pattern here!");
            }
            Item item = pattern.func_77973_b();
            if (item instanceof ItemEncodedPattern) {
                ItemEncodedPattern iep = (ItemEncodedPattern)item;
                if (!(pattern.func_77973_b() instanceof ItemFluidEncodedPattern)) {
                    return iep.getOutput(pattern) == null;
                }
            }
            return true;
        }

        private ItemStack getStack(Arguments args) {
            if (args.count() > 1) {
                int size;
                int entry;
                String address;
                if (args.isString(0)) {
                    address = args.checkString(0);
                    entry = args.checkInteger(1);
                    size = args.optInteger(2, 1);
                } else {
                    address = args.checkString(1);
                    entry = args.checkInteger(2);
                    size = args.optInteger(3, 1);
                }
                Node node = this.node().network().node(address);
                if (node instanceof Component) {
                    if (node.host() instanceof Database) {
                        ItemStack dbStack = ((Database)node.host()).getStackInSlot(entry - 1);
                        if (dbStack == null || size < 1) {
                            return null;
                        }
                        dbStack.field_77994_a = Math.min(size, dbStack.func_77976_d());
                        return dbStack;
                    }
                    throw new IllegalArgumentException("not a database");
                }
                throw new IllegalArgumentException("no such component");
            }
            return null;
        }

        private Object[] clearInterfacePattern(Context context, Arguments args, String tag) {
            IInventory inv = ((TileOCPatternEditor)((Object)this.tileEntity)).getInternalInventory();
            ItemStack pattern = inv.func_70301_a(this.checkSlot(args, inv, 0));
            if (this.validPattern(pattern)) {
                NBTTagCompound encodedValue = pattern.func_77978_p();
                int slot = this.checkSlot(args, inv, 0);
                if (encodedValue == null) {
                    throw new IllegalArgumentException("No pattern here!");
                }
                NBTTagList nbt = encodedValue.func_150295_c(tag, 10);
                int index = args.checkInteger(1) - 1;
                if (index < 0) {
                    throw new IllegalArgumentException("Invalid index!");
                }
                nbt.func_74744_a(index);
                encodedValue.func_74782_a(tag, (NBTBase)nbt);
                pattern.func_77982_d(encodedValue);
                inv.func_70299_a(slot, null);
                inv.func_70299_a(slot, pattern);
                context.pause(0.1);
                return new Object[]{true};
            }
            throw new IllegalArgumentException("Not Fluid Encoded pattern!");
        }

        private Object[] setPatternSlot(Context context, Arguments args, String tag, boolean fluid) {
            int index;
            IInventory inv = ((TileOCPatternEditor)((Object)this.tileEntity)).getInternalInventory();
            int slot = args.isString(0) ? 0 : this.optSlot(args, inv, 0, 0);
            ItemStack stack = this.getStack(args);
            if (fluid) {
                FluidStack fluids = Util.getFluidFromItem(stack);
                stack = ItemFluidDrop.newStack(fluids);
            }
            if ((index = args.checkInteger(4) - 1) < 0 || index > 511) {
                throw new IllegalArgumentException("Invalid index!");
            }
            ItemStack pattern = inv.func_70301_a(slot);
            if (this.validPattern(pattern)) {
                NBTTagCompound encodedValue = pattern.func_77978_p();
                if (encodedValue == null) {
                    throw new IllegalArgumentException("No pattern here!");
                }
                NBTTagList inTag = encodedValue.func_150295_c(tag, 10);
                while (inTag.func_74745_c() <= index) {
                    inTag.func_74742_a((NBTBase)new NBTTagCompound());
                }
                if (stack != null) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    AEItemStack aeStack = AEItemStack.create((ItemStack)stack);
                    aeStack.writeToNBT(nbt);
                    inTag.func_150304_a(index, (NBTBase)nbt);
                } else {
                    inTag.func_74744_a(index);
                }
                encodedValue.func_74782_a(tag, (NBTBase)inTag);
                pattern.func_77982_d(encodedValue);
                inv.func_70299_a(slot, null);
                inv.func_70299_a(slot, pattern);
                context.pause(0.1);
                return new Object[]{true};
            }
            throw new IllegalArgumentException("Not Fluid Encoded pattern!");
        }

        @Callback(doc="function([slot:number]):table -- Get the configuration of the interface.")
        public Object[] getInterfaceConfiguration(Context context, Arguments args) {
            int slot;
            IInventory config = ((TileOCPatternEditor)((Object)this.tileEntity)).getInternalInventory();
            ItemStack stack = config.func_70301_a(slot = this.optSlot(args, config, 0, 0));
            if (!this.validPattern(stack)) {
                throw new IllegalArgumentException("Not Fluid Encoded pattern!");
            }
            return new Object[]{stack};
        }

        @Callback(doc="function([slot:number][, database:address, entry:number[, size:number]]):boolean -- Configure the interface.")
        public Object[] setInterfaceConfiguration(Context context, Arguments args) {
            IInventory config = ((TileOCPatternEditor)((Object)this.tileEntity)).getInternalInventory();
            int slot = args.isString(0) ? 0 : this.optSlot(args, config, 0, 0);
            config.func_70299_a(slot, this.getStack(args));
            context.pause(0.5);
            return new Object[]{true};
        }

        @Callback(doc="function([slot:number]):table -- Get the given pattern in the interface.")
        public Object[] getInterfacePattern(Context context, Arguments args) {
            IInventory inv = ((TileOCPatternEditor)((Object)this.tileEntity)).getInternalInventory();
            int slot = this.optSlot(args, inv, 0, 0);
            ItemStack stack = inv.func_70301_a(slot);
            return new Object[]{stack};
        }

        @Callback(doc="function(slot:number, database:address, entry:number, size:number, index:number):boolean -- Set the pattern item input at the given index.")
        public Object[] setInterfacePatternItemInput(Context context, Arguments args) {
            return this.setPatternSlot(context, args, "in", false);
        }

        @Callback(doc="function(slot:number, database:address, entry:number, size:number, index:number):boolean -- Set the pattern item output at the given index.")
        public Object[] setInterfacePatternItemOutput(Context context, Arguments args) {
            return this.setPatternSlot(context, args, "out", false);
        }

        @Callback(doc="function(slot:number, database:address, entry:number, size:number, index:number):boolean -- Set the pattern fluid input at the given index.")
        public Object[] setInterfacePatternFluidInput(Context context, Arguments args) {
            return this.setPatternSlot(context, args, "in", true);
        }

        @Callback(doc="function(slot:number, database:address, entry:number, size:number, index:number):boolean -- Set the pattern fluid output at the given index.")
        public Object[] setInterfacePatternFluidOutput(Context context, Arguments args) {
            return this.setPatternSlot(context, args, "out", true);
        }

        @Callback(doc="function(slot:number, index:number):boolean -- Clear pattern input at the given index.")
        public Object[] clearInterfacePatternInput(Context context, Arguments args) {
            return this.clearInterfacePattern(context, args, "in");
        }

        @Callback(doc="function(slot:number, index:number):boolean -- Clear pattern output at the given index.")
        public Object[] clearInterfacePatternOutput(Context context, Arguments args) {
            return this.clearInterfacePattern(context, args, "out");
        }

        public String preferredName() {
            return "oc_pattern_editor";
        }

        public int priority() {
            return 5;
        }
    }

    public static class Provider
    implements EnvironmentProvider {
        Provider() {
        }

        public Class<?> getEnvironment(ItemStack itemStack) {
            if (itemStack != null && itemStack.func_77969_a(ItemAndBlockHolder.OC_EDITOR.stack())) {
                return Environment.class;
            }
            return null;
        }
    }
}

