/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEFluidStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.client.gui.container.ContainerFluidMonitor;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class CPacketFluidUpdate
implements IMessage {
    private Map<Integer, IAEFluidStack> list;
    private ItemStack itemStack;
    private int slotIndex;

    public CPacketFluidUpdate() {
    }

    public CPacketFluidUpdate(Map<Integer, IAEFluidStack> data, ItemStack itemStack) {
        this.list = data;
        this.itemStack = itemStack;
        this.slotIndex = -1;
    }

    public CPacketFluidUpdate(Map<Integer, IAEFluidStack> data) {
        this.list = data;
    }

    public CPacketFluidUpdate(Map<Integer, IAEFluidStack> data, ItemStack itemStack, int slotIndex) {
        this.list = data;
        this.itemStack = itemStack;
        this.slotIndex = slotIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.list = new HashMap<Integer, IAEFluidStack>();
        try {
            Util.readFluidMapFromBuf(this.list, buf);
            if (buf.readBoolean()) {
                this.itemStack = AEItemStack.loadItemStackFromPacket((ByteBuf)buf).getItemStack();
                this.slotIndex = buf.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            Util.writeFluidMapToBuf(this.list, buf);
            if (this.itemStack != null) {
                buf.writeBoolean(true);
                AEItemStack.create((ItemStack)this.itemStack).writeToPacket(buf);
                buf.writeInt(this.slotIndex);
            } else {
                buf.writeBoolean(false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Handler
    implements IMessageHandler<CPacketFluidUpdate, IMessage> {
        public IMessage onMessage(CPacketFluidUpdate message, MessageContext ctx) {
            Container container = ctx.getServerHandler().field_147369_b.field_71070_bA;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (container instanceof ContainerFluidMonitor) {
                ItemStack item = player.field_71071_by.func_70445_o();
                ((ContainerFluidMonitor)container).postChange(new ArrayList<IAEFluidStack>(message.list.values()), message.itemStack == null ? item : message.itemStack, (EntityPlayer)player, message.slotIndex);
            }
            return null;
        }
    }
}

