/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.net;

import com.github.bartimaeusnek.bartworks.common.items.Circuit_Programmer;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GT_Packet;
import java.nio.ByteBuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CircuitProgrammerPacket
extends GT_Packet {
    private int dimID;
    private int playerID;
    private byte chipCfg;
    private boolean hasChip;

    public CircuitProgrammerPacket() {
        super(true);
    }

    public CircuitProgrammerPacket(int dimID, int playerID, boolean hasChip, byte chipCfg) {
        super(false);
        this.dimID = dimID;
        this.playerID = playerID;
        this.hasChip = hasChip;
        this.chipCfg = chipCfg;
    }

    public byte getPacketID() {
        return 1;
    }

    public byte[] encode() {
        return ByteBuffer.allocate(9).putInt(0, this.dimID).putInt(4, this.playerID).put(8, this.hasChip ? (byte)this.chipCfg : (byte)-1).array();
    }

    public GT_Packet decode(ByteArrayDataInput byteArrayDataInput) {
        byte[] ret = new byte[9];
        byteArrayDataInput.readFully(ret);
        return new CircuitProgrammerPacket(ByteBuffer.wrap(ret).getInt(0), ByteBuffer.wrap(ret).getInt(4), ByteBuffer.wrap(ret).get(8) > -1, ByteBuffer.wrap(ret).get(8));
    }

    public void process(IBlockAccess iBlockAccess) {
        Item item;
        ItemStack stack;
        WorldServer w = DimensionManager.getWorld((int)this.dimID);
        if (w != null && w.func_73045_a(this.playerID) instanceof EntityPlayer && (stack = ((EntityPlayer)w.func_73045_a(this.playerID)).func_70694_bm()) != null && stack.field_77994_a > 0 && (item = stack.func_77973_b()) instanceof Circuit_Programmer) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_74757_a("HasChip", this.hasChip);
            if (this.hasChip) {
                nbt.func_74774_a("ChipConfig", this.chipCfg);
            }
            stack.func_77982_d(nbt);
            ((EntityPlayer)w.func_73045_a((int)this.playerID)).field_71071_by.func_70299_a(((EntityPlayer)w.func_73045_a((int)this.playerID)).field_71071_by.field_70461_c, stack);
        }
    }
}

