/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.gui.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.container.Container_Grindle;
import gtPlusPlus.core.inventories.BaseInventoryGrindle;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.util.LinkedHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiBaseGrindle
extends GuiContainer {
    protected FontRenderer fontRenderer;
    private GrindleGuiButton mButtonNextPage;
    private GrindleGuiButton mButtonPreviousPage;
    private String[][] mPageDataArray;
    private short mCurrentPage = 0;
    private static final ResourceLocation iconLocation = new ResourceLocation(Mods.GTPlusPlus.ID, "textures/gui/itemGrindle.png");
    private final BaseInventoryGrindle inventory;

    public GuiBaseGrindle(Container_Grindle containerItem) {
        super((Container)containerItem);
        this.inventory = containerItem.inventory;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        this.updateButtons();
    }

    protected void func_146979_b(int par1, int par2) {
        try {
            this.field_146289_q.func_78261_a(I18n.func_135052_a((String)"Gregtech Information Transponder", (Object[])new Object[0]), 0, -12, Utils.rgbtoHexValue(255, 255, 255));
            ItemStack aStack = this.inventory.func_70301_a(0);
            if (aStack != null) {
                GrindleData aDataCurrent = new GrindleData(aStack);
                if (aDataCurrent.mValid) {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)aDataCurrent.mTitle, (Object[])new Object[0]), 10, 8, Utils.rgbtoHexValue(125, 255, 125));
                    int tTier = aDataCurrent.mExtraInformation;
                    if (tTier >= 0) {
                        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)(aDataCurrent.mTierDim + " | Page: " + this.mCurrentPage), (Object[])new Object[0]), 10, 18, Utils.rgbtoHexValue(125, 255, 125));
                        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"-------------------", (Object[])new Object[0]), 10, 23, Utils.rgbtoHexValue(125, 125, 255));
                        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)aDataCurrent.mPosInfo, (Object[])new Object[0]), 10, 29, Utils.rgbtoHexValue(125, 125, 255));
                        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"-------------------", (Object[])new Object[0]), 10, 35, Utils.rgbtoHexValue(125, 125, 255));
                        int aLastYUsed = 41;
                        int posOuter = 0;
                        int posInner = 0;
                        this.mPageDataArray = new String[MathUtils.roundToClosestInt(Math.ceil((double)aDataCurrent.mListData.size() / 9.0))][9];
                        for (String e : aDataCurrent.mListData) {
                            if (e == null) continue;
                            this.mPageDataArray[posInner][posOuter] = e;
                            if (posOuter < 8) {
                                ++posOuter;
                                continue;
                            }
                            posOuter = 0;
                            ++posInner;
                        }
                        String[] aCurrentPage = this.mPageDataArray[this.mCurrentPage];
                        if (aCurrentPage != null && aCurrentPage.length > 0) {
                            for (int i = 0; i < aCurrentPage.length; ++i) {
                                String aCP;
                                if (aLastYUsed + 9 > 124 || (aCP = aCurrentPage[i]) == null || aCP.length() <= 0 || aCP.toLowerCase().contains("empty") || aCP.toLowerCase().contains("null")) continue;
                                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)aCP, (Object[])new Object[0]), 10, aLastYUsed, Utils.rgbtoHexValue(125, 255, 125));
                                aLastYUsed += 9;
                            }
                        }
                    } else {
                        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)aDataCurrent.mTierDim, (Object[])new Object[0]), 10, 18, Utils.rgbtoHexValue(125, 255, 125));
                        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"-------------------", (Object[])new Object[0]), 10, 23, Utils.rgbtoHexValue(125, 125, 255));
                        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)aDataCurrent.mPosInfo, (Object[])new Object[0]), 10, 29, Utils.rgbtoHexValue(125, 125, 255));
                        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"-------------------", (Object[])new Object[0]), 10, 35, Utils.rgbtoHexValue(125, 125, 255));
                        int n = 41;
                    }
                } else {
                    this.field_146289_q.func_78261_a(I18n.func_135052_a((String)"Invalid data item stored in slot.", (Object[])new Object[0]), 10, 8, Utils.rgbtoHexValue(255, 125, 125));
                }
            } else {
                this.field_146289_q.func_78261_a(I18n.func_135052_a((String)"Insert device into port.", (Object[])new Object[0]), 10, 8, Utils.rgbtoHexValue(255, 125, 125));
                this.mPageDataArray = new String[][]{new String[0]};
                this.mCurrentPage = 0;
            }
            this.field_146289_q.func_78261_a(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, 131, Utils.rgbtoHexValue(255, 255, 255));
        }
        catch (Throwable t) {
            Logger.INFO("GUI CRASH - " + t);
            t.printStackTrace();
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(iconLocation);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        int k = this.field_146294_l - this.field_146999_f - this.field_146294_l / 16;
        this.mButtonNextPage = new GrindleGuiButton(1, k, 155, true);
        this.mButtonPreviousPage = new GrindleGuiButton(2, k - 20, 155, false);
        this.field_146292_n.add(this.mButtonNextPage);
        this.field_146292_n.add(this.mButtonPreviousPage);
        this.mCurrentPage = 0;
        this.updateButtons();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.mCurrentPage = 0;
        super.func_146281_b();
    }

    private void updateButtons() {
        if (this.mCurrentPage >= 0) {
            this.mButtonNextPage.field_146125_m = this.mPageDataArray != null ? this.mCurrentPage < this.mPageDataArray.length - 1 : false;
        }
        this.mButtonPreviousPage.field_146125_m = this.mCurrentPage > 0;
    }

    protected void func_146284_a(GuiButton aButton) {
        if (aButton.field_146124_l && aButton.field_146125_m) {
            if (aButton.field_146127_k == 1) {
                if (this.mCurrentPage < this.mPageDataArray.length - 1) {
                    this.mCurrentPage = (short)(this.mCurrentPage + 1);
                }
            } else if (aButton.field_146127_k == 2 && this.mCurrentPage > 0) {
                this.mCurrentPage = (short)(this.mCurrentPage - 1);
            }
            this.updateButtons();
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
    }

    protected void func_146286_b(int p_146286_1_, int p_146286_2_, int p_146286_3_) {
        super.func_146286_b(p_146286_1_, p_146286_2_, p_146286_3_);
    }

    protected void func_146285_a(ItemStack aStack, int p_146285_2_, int p_146285_3_) {
        super.func_146285_a(aStack, p_146285_2_, p_146285_3_);
    }

    public static class GrindleData {
        final boolean mValid;
        final ItemStack mStack;
        final String mTitle;
        final String mPosInfo;
        final String mTierDim;
        final AutoMap<String> mListData;
        final GrindleMode mMode;
        final int mExtraInformation;

        public GrindleData(ItemStack iStack) {
            if (iStack == null) {
                this.mValid = false;
                this.mStack = null;
                this.mTitle = null;
                this.mListData = null;
                this.mMode = null;
                this.mExtraInformation = 0;
                this.mTierDim = "";
                this.mPosInfo = "";
            } else {
                this.mStack = iStack;
                int aType = -1;
                boolean isProspecting = false;
                if (GT_Utility.areStacksEqual((ItemStack)iStack, (ItemStack)CI.getDataStick(), (boolean)true)) {
                    aType = 0;
                } else if (GT_Utility.areStacksEqual((ItemStack)iStack, (ItemStack)CI.getDataOrb(), (boolean)true)) {
                    aType = 1;
                }
                NBTTagCompound tNBT = iStack.func_77978_p();
                if (tNBT == null) {
                    tNBT = new NBTTagCompound();
                }
                String string = tNBT.func_74764_b("title") ? tNBT.func_74779_i("title") : (aType == 0 ? "Empty Data Stick" : (this.mTitle = aType == 1 ? "Empty Data Orb" : "Unknown Item"));
                if (this.mTitle.toLowerCase().contains("raw prospection data")) {
                    isProspecting = true;
                }
                int tTier = -1;
                if (isProspecting) {
                    if (!tNBT.func_74764_b("prospection_tier") && tNBT.func_74764_b("prospection")) {
                        tTier = 0;
                    } else if (tNBT.func_74764_b("prospection_tier") && !tNBT.func_74764_b("prospection")) {
                        tTier = tNBT.func_74771_c("prospection_tier");
                    }
                }
                int n = this.mExtraInformation = isProspecting ? tTier : -1;
                if (tTier >= 0) {
                    String aPositionString;
                    String aInfoString;
                    String aDim;
                    String zPos;
                    String yPos;
                    String xPos;
                    LinkedHashSet<String> aOreTypes = new LinkedHashSet<String>();
                    LinkedHashSet<String> aOilTypes = new LinkedHashSet<String>();
                    if (tTier == 0) {
                        String tData = tNBT.func_74779_i("prospection");
                        String[] tDataArray = tData.split(",");
                        xPos = tDataArray[0];
                        yPos = tDataArray[1];
                        zPos = tDataArray[2];
                        aDim = tDataArray[3];
                        aOilTypes.add("Oil Type: " + tDataArray[5]);
                        aOilTypes.add("--------------------");
                        aOreTypes.add("Ore Types: ");
                        for (int i = 6; tDataArray.length > i; ++i) {
                            aOreTypes.add("-" + tDataArray[i]);
                        }
                    } else {
                        String tOresFar;
                        String[] tOresFarData;
                        String tOresMid;
                        String[] tOresMidData;
                        String tOresNear;
                        String[] tOresNearData;
                        String tPos = tNBT.func_74779_i("prospection_pos");
                        String[] tPosData = tPos.split(" ");
                        xPos = tPosData[1];
                        yPos = tPosData[3];
                        zPos = tPosData[5];
                        aDim = tPosData[7];
                        String tOil = tNBT.func_74779_i("prospection_oils");
                        String[] tOilData = tOil.split("\\|");
                        if (tOilData.length > 0) {
                            aOilTypes.add("Oil Types:");
                            for (String s : tOilData) {
                                if (s == null) continue;
                                aOilTypes.add(s);
                            }
                            aOilTypes.add("--------------------");
                        }
                        if ((tOresNearData = (tOresNear = tNBT.func_74779_i("prospection_near")).split("\\|")).length + (tOresMidData = (tOresMid = tNBT.func_74779_i("prospection_middle")).split("\\|")).length + (tOresFarData = (tOresFar = tNBT.func_74779_i("prospection_far")).split("\\|")).length > 0) {
                            aOreTypes.add("Ore Types:");
                            if (tOresNearData.length > 0) {
                                for (String s : tOresNearData) {
                                    if (s == null) continue;
                                    aOreTypes.add("-" + s + " - Near");
                                }
                            }
                            if (tOresMidData.length > 0) {
                                for (String s : tOresMidData) {
                                    if (s == null) continue;
                                    aOreTypes.add("-" + s + " - Mid");
                                }
                            }
                            if (tOresFarData.length > 0) {
                                for (String s : tOresFarData) {
                                    if (s == null) continue;
                                    aOreTypes.add("-" + s + " - Far");
                                }
                            }
                        }
                    }
                    this.mListData = new AutoMap();
                    if (aOilTypes.size() > 0) {
                        for (String aOils : aOilTypes) {
                            if (aOils == null || aOils.length() <= 0) continue;
                            this.mListData.put(aOils);
                        }
                    }
                    if (aOreTypes.size() > 0) {
                        for (String aOres : aOreTypes) {
                            if (aOres == null || aOres.length() <= 0) continue;
                            this.mListData.put(aOres);
                        }
                    }
                    this.mMode = GrindleMode.PROSPECTING;
                    this.mTierDim = aInfoString = "Tier: " + tTier + " | Dim: " + aDim;
                    this.mPosInfo = aPositionString = "X:" + xPos + ", Y:" + yPos + ", Z:" + zPos;
                    this.mValid = true;
                } else {
                    this.mValid = true;
                    this.mListData = null;
                    this.mMode = GrindleMode.ELEMENT;
                    this.mTierDim = "PLACEHOLDER";
                    this.mPosInfo = "PLACEHOLDER";
                }
            }
        }

        public static enum GrindleMode {
            PROSPECTING(0),
            ELEMENT(1);

            private final int aModeID;

            private GrindleMode(int aMode) {
                this.aModeID = aMode;
            }

            public int getMode() {
                return this.aModeID;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class GrindleGuiButton
    extends GuiButton {
        public static final ResourceLocation mBookTexture;
        private final boolean aPageForward;

        public GrindleGuiButton(int aID, int aX, int aY, boolean aForwards) {
            this(aID, aX, aY, 20, 12, aForwards);
        }

        public GrindleGuiButton(int aID, int aX, int aY, int aWidth, int aHeight, boolean aForwards) {
            super(aID, aX, aY, aWidth, aHeight, "");
            this.aPageForward = aForwards;
        }

        public void func_146112_a(Minecraft aGame, int aX, int aY) {
            if (this.field_146125_m) {
                boolean flag = aX >= this.field_146128_h && aY >= this.field_146129_i && aX < this.field_146128_h + this.field_146120_f && aY < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                aGame.func_110434_K().func_110577_a(iconLocation);
                int k = 0;
                int l = 192;
                if (flag) {
                    k += 23;
                }
                if (!this.aPageForward) {
                    l += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 22, 12);
            }
        }

        static {
            ResourceLocation r;
            try {
                r = (ResourceLocation)ReflectionUtils.getField(GuiScreenBook.class, "bookGuiTextures").get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                r = new ResourceLocation("textures/gui/book.png");
            }
            mBookTexture = r;
        }
    }
}

