/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.dusts;

import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.material.Material;

public class BaseItemDust
extends BaseItemComponent {
    private BaseItemComponent[] mSizedDusts = new BaseItemComponent[2];

    public BaseItemDust(Material aMat) {
        this(aMat, true);
    }

    public BaseItemDust(Material aMat, boolean generateSmallDusts) {
        super(aMat, BaseItemComponent.ComponentTypes.DUST);
        if (generateSmallDusts) {
            this.mSizedDusts[0] = new BaseItemComponent(aMat, BaseItemComponent.ComponentTypes.DUSTSMALL);
            this.mSizedDusts[1] = new BaseItemComponent(aMat, BaseItemComponent.ComponentTypes.DUSTTINY);
        }
    }

    public BaseItemDust(DustState aState, Material aMat) {
        super(aMat, BaseItemComponent.ComponentTypes.DUST);
        if (aState.generatesSmallDust()) {
            this.mSizedDusts[0] = new BaseItemComponent(aMat, BaseItemComponent.ComponentTypes.DUSTSMALL);
        }
        if (aState.generatesTinyDust()) {
            this.mSizedDusts[1] = new BaseItemComponent(aMat, BaseItemComponent.ComponentTypes.DUSTTINY);
        }
    }

    private BaseItemDust(String unlocalizedName, String materialName, Material matInfo, int colour, String pileSize, int tier, boolean addRecipes) {
        super(matInfo, BaseItemComponent.ComponentTypes.DUST);
    }

    public static class DustState {
        static final int NORMAL = 1;
        static final int SMALL = 10;
        static final int TINY = 100;
        final int MIXTURE;
        final boolean[] doesThings = new boolean[3];

        public DustState(boolean genDust, boolean genSmallDust, boolean genDustTiny) {
            int aTotal = 0;
            if (genDust) {
                ++aTotal;
                this.doesThings[0] = true;
            } else {
                this.doesThings[0] = false;
            }
            if (genSmallDust) {
                aTotal += 10;
                this.doesThings[1] = true;
            } else {
                this.doesThings[1] = false;
            }
            if (genDustTiny) {
                aTotal += 100;
                this.doesThings[2] = true;
            } else {
                this.doesThings[2] = false;
            }
            this.MIXTURE = aTotal;
        }

        public boolean generatesDust() {
            return this.doesThings[0];
        }

        public boolean generatesSmallDust() {
            return this.doesThings[1];
        }

        public boolean generatesTinyDust() {
            return this.doesThings[2];
        }

        private DustState(int amount) {
            if (amount == 1) {
                this.doesThings[0] = true;
                this.doesThings[1] = false;
                this.doesThings[2] = false;
            } else if (amount == 10) {
                this.doesThings[0] = false;
                this.doesThings[1] = true;
                this.doesThings[2] = false;
            } else if (amount == 100) {
                this.doesThings[0] = false;
                this.doesThings[1] = false;
                this.doesThings[2] = true;
            } else if (amount == 11) {
                this.doesThings[0] = true;
                this.doesThings[1] = true;
                this.doesThings[2] = false;
            } else if (amount == 101) {
                this.doesThings[0] = true;
                this.doesThings[1] = false;
                this.doesThings[2] = true;
            } else if (amount == 110) {
                this.doesThings[0] = false;
                this.doesThings[1] = true;
                this.doesThings[2] = true;
            } else if (amount == 111) {
                this.doesThings[0] = true;
                this.doesThings[1] = true;
                this.doesThings[2] = true;
            } else {
                this.doesThings[0] = false;
                this.doesThings[1] = false;
                this.doesThings[2] = false;
            }
            this.MIXTURE = amount;
        }

        public DustState get(int a) {
            if (a == 1) {
                return new DustState(1);
            }
            if (a == 10) {
                return new DustState(10);
            }
            if (a == 100) {
                return new DustState(100);
            }
            return new DustState(this.MIXTURE);
        }
    }
}

