/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.sys;

public class SystemUtils {
    private static OS SystemType;

    public static OS getOS() {
        if (SystemType != null) {
            return SystemType;
        }
        SystemType = SystemUtils.getOperatingSystem();
        return SystemType;
    }

    public static void invokeGC() {
        try {
            Runtime r = Runtime.getRuntime();
            r.gc();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isWindows() {
        return SystemUtils.getOSString().indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return SystemUtils.getOSString().indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return SystemUtils.getOSString().indexOf("nix") >= 0 || SystemUtils.getOSString().indexOf("nux") >= 0 || SystemUtils.getOSString().indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return SystemUtils.getOSString().indexOf("sunos") >= 0;
    }

    public static String getOSString() {
        try {
            return System.getProperty("os.name").toLowerCase();
        }
        catch (Throwable t) {
            return "other";
        }
    }

    public static OS getOperatingSystem() {
        if (SystemUtils.isMac()) {
            return OS.MAC;
        }
        if (SystemUtils.isWindows()) {
            return OS.WINDOWS;
        }
        if (SystemUtils.isUnix()) {
            return OS.UNIX;
        }
        if (SystemUtils.isSolaris()) {
            return OS.SOLARIS;
        }
        return OS.OTHER;
    }

    public static enum OS {
        MAC(1),
        WINDOWS(2),
        UNIX(3),
        SOLARIS(4),
        OTHER(0);

        private int mID;

        private OS(int ID) {
            this.mID = ID;
        }

        public int getID() {
            return this.mID;
        }
    }
}

