/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.recipes;

import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.AddGregtechRecipe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CokeAndPyrolyseOven {
    public static void onLoadComplete() {
        CokeAndPyrolyseOven.convertPyroToCokeOven();
    }

    public static void postInit() {
        Logger.INFO("Loading Recipes for Industrial Coking Oven.");
        ArrayList aLogData = OreDictionary.getOres((String)"logWood");
        for (ItemStack stack : aLogData) {
            AddGregtechRecipe.addCokeAndPyrolyseRecipes(ItemUtils.getSimpleStack(stack, 20), 20, GT_ModHandler.getSteam((long)1000L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Charcoal, (long)24L), FluidUtils.getFluidStack("fluid.coalgas", 1440), 60, 30);
        }
        AddGregtechRecipe.addCokeAndPyrolyseRecipes(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Coal, (long)16L), 22, GT_ModHandler.getSteam((long)1000L), ItemUtils.getItemStackOfAmountFromOreDict("fuelCoke", 10), FluidUtils.getFluidStack("fluid.coalgas", 2880), 30, 120);
        CORE.RA.addCokeOvenRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Coal, (long)12L), ItemUtils.getItemStackOfAmountFromOreDict("fuelCoke", 6), GT_ModHandler.getSteam((long)2000L), FluidUtils.getFluidStack("fluid.coalgas", 5040), ItemUtils.getItemStackOfAmountFromOreDict("fuelCoke", 14), 1200, 240);
    }

    private static void convertPyroToCokeOven() {
        int aCount = 0;
        for (GT_Recipe g : GT_Recipe.GT_Recipe_Map.sPyrolyseRecipes.mRecipeList) {
            if (!AddGregtechRecipe.importPyroRecipe(g)) continue;
            ++aCount;
        }
        Logger.INFO("Converted " + aCount + " Pyrolyse recipes into Industrial Coke Oven recipes.");
    }
}

