/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.blocks.fluid;

import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

public class GregtechFluidHandler {
    protected static int cellID = 0;

    public static void run() {
        GregtechFluidHandler.start();
    }

    private static void start() {
        Logger.INFO("Adding in our own GT versions of Thermal Foundation Fluids if they do not already exist.");
        if (!FluidRegistry.isFluidRegistered((String)"cryotheum")) {
            FluidUtils.addGtFluid("cryotheum", "Gelid Cryotheum", GregtechOrePrefixes.GT_Materials.Cryotheum, 4, -1200L, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)((Object)GregtechOrePrefixes.GT_Materials.Cryotheum), (long)1L), ItemUtils.getEmptyCell(), 1000);
        }
        if (!FluidRegistry.isFluidRegistered((String)"pyrotheum")) {
            FluidUtils.addGtFluid("pyrotheum", "Blazing Pyrotheum", GregtechOrePrefixes.GT_Materials.Pyrotheum, 4, 4000L, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)((Object)GregtechOrePrefixes.GT_Materials.Pyrotheum), (long)1L), ItemUtils.getEmptyCell(), 1000);
        }
        if (!FluidRegistry.isFluidRegistered((String)"ender")) {
            FluidUtils.addGtFluid("ender", "Resonant Ender", GregtechOrePrefixes.GT_Materials.Ender, 4, 4000L, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)((Object)GregtechOrePrefixes.GT_Materials.Ender), (long)1L), ItemUtils.getEmptyCell(), 1000);
        }
        Logger.INFO("Adding in GT Fluids for various nuclear related content.");
        FluidUtils.addGtFluid("hydrofluoricAcid", "Industrial Strength Hydrofluoric Acid", GregtechOrePrefixes.GT_Materials.HydrofluoricAcid, 1, 120L, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)((Object)GregtechOrePrefixes.GT_Materials.HydrofluoricAcid), (long)1L), ItemUtils.getEmptyCell(), 1000, false);
        GregtechFluidHandler.generateIC2FluidCell("HydrofluoricAcid");
        FluidUtils.generateFluidNoPrefix("SulfurDioxide", "High Quality Sulfur Dioxide", 263, GregtechOrePrefixes.GT_Materials.SulfurDioxide.mRGBa);
        FluidUtils.addGtFluid("sulfurousAcid", "Sulfurous Acid", GregtechOrePrefixes.GT_Materials.SulfurousAcid, 4, 75L, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)((Object)GregtechOrePrefixes.GT_Materials.SulfurousAcid), (long)1L), ItemUtils.getEmptyCell(), 1000, false);
        GregtechFluidHandler.generateIC2FluidCell("SulfurousAcid");
        FluidUtils.addGtFluid("sulfuricApatite", "Sulfuric Apatite Mix", GregtechOrePrefixes.GT_Materials.SulfuricApatite, 4, 500L, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)((Object)GregtechOrePrefixes.GT_Materials.SulfuricApatite), (long)1L), ItemUtils.getEmptyCell(), 1000, false);
        GregtechFluidHandler.generateIC2FluidCell("SulfuricApatite");
        if (FluidUtils.getFluidStack("hydrogenchloride", 1) == null) {
            FluidUtils.addGtFluid("hydrogenChloride", "Industrial Strength Hydrogen Chloride", GregtechOrePrefixes.GT_Materials.HydrogenChloride, 4, 75L, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)((Object)GregtechOrePrefixes.GT_Materials.HydrogenChloride), (long)1L), ItemUtils.getEmptyCell(), 1000, false);
            GregtechFluidHandler.generateIC2FluidCell("HydrogenChloride");
        }
        FluidUtils.addGtFluid("sulfuricLithium", "Sulfuric Lithium Mix", GregtechOrePrefixes.GT_Materials.SulfuricLithium, 4, 280L, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)((Object)GregtechOrePrefixes.GT_Materials.SulfuricLithium), (long)1L), ItemUtils.getEmptyCell(), 1000, false);
        GregtechFluidHandler.generateIC2FluidCell("SulfuricLithium");
        FluidUtils.addGtFluid("lithiumHydroxide", "Lithium Hydroxide", GregtechOrePrefixes.GT_Materials.LithiumHydroxide, 4, 500L, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)((Object)GregtechOrePrefixes.GT_Materials.LithiumHydroxide), (long)1L), ItemUtils.getEmptyCell(), 1000, false);
        GregtechFluidHandler.generateIC2FluidCell("LithiumHydroxide");
    }

    private static ItemStack generateIC2FluidCell(String fluidNameWithCaps) {
        Logger.INFO("Adding a Cell for " + fluidNameWithCaps);
        return Utils.createInternalNameAndFluidCell(fluidNameWithCaps);
    }
}

