/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core;

import com.enderio.core.IEnderMod;
import com.enderio.core.api.common.config.IConfigHandler;
import com.enderio.core.common.CommonProxy;
import com.enderio.core.common.Handlers;
import com.enderio.core.common.Lang;
import com.enderio.core.common.OreDict;
import com.enderio.core.common.command.CommandReloadConfigs;
import com.enderio.core.common.command.CommandScoreboardInfo;
import com.enderio.core.common.compat.CompatRegistry;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.enchant.EnchantAutoSmelt;
import com.enderio.core.common.enchant.EnchantXPBoost;
import com.enderio.core.common.imc.IMCRegistry;
import com.enderio.core.common.network.EnderPacketHandler;
import com.enderio.core.common.util.EnderFileUtils;
import com.enderio.core.common.util.PermanentCache;
import com.enderio.core.common.util.TextureErrorRemover;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.ClientCommandHandler;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="endercore", name="EnderCore", version="0.2.17", dependencies="after:ttCore; after:gtnhlib@[0.0.10,)", guiFactory="com.enderio.core.common.config.BaseConfigFactory")
public class EnderCore
implements IEnderMod {
    public static final String MODID = "endercore";
    public static final String NAME = "EnderCore";
    public static final String BASE_PACKAGE = "com.enderio";
    public static final String VERSION = "0.2.17";
    public static final Logger logger = LogManager.getLogger((String)"EnderCore");
    public static final Lang lang = new Lang("endercore");
    @Mod.Instance(value="endercore")
    public static EnderCore instance;
    @SidedProxy(serverSide="com.enderio.core.common.CommonProxy", clientSide="com.enderio.core.client.ClientProxy")
    public static CommonProxy proxy;
    public List<IConfigHandler> configs = Lists.newArrayList();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"ttCore")) {
            proxy.throwModCompatibilityError(lang.localize("error.ttcore.1"), lang.localize("error.ttcore.2"), lang.localize("error.ttcore.3"));
        }
        if (event.getSide().isClient()) {
            TextureErrorRemover.beginIntercepting();
        }
        if (!(ConfigHandler.configFile = new File((ConfigHandler.enderConfigFolder = new File((ConfigHandler.configFolder = event.getModConfigurationDirectory()).getPath() + "/" + MODID)).getPath() + "/" + event.getSuggestedConfigurationFile().getName())).exists() && event.getSuggestedConfigurationFile().exists()) {
            try {
                FileUtils.copyFile((File)event.getSuggestedConfigurationFile(), (File)ConfigHandler.configFile);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            EnderFileUtils.safeDelete(event.getSuggestedConfigurationFile());
        }
        ConfigHandler.instance().initialize(ConfigHandler.configFile);
        Handlers.preInit(event);
        CompatRegistry.INSTANCE.handle((FMLStateEvent)event);
        OreDict.registerVanilla();
        EnchantXPBoost.INSTANCE.register();
        EnchantAutoSmelt.INSTANCE.register();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EnderPacketHandler.init();
        for (IConfigHandler c : this.configs) {
            c.initHook();
        }
        Handlers.register(event);
        CompatRegistry.INSTANCE.handle((FMLStateEvent)event);
        ClientCommandHandler.instance.func_71560_a((ICommand)CommandReloadConfigs.CLIENT);
        if (event.getSide().isServer()) {
            ((CommandHandler)MinecraftServer.func_71276_C().func_71187_D()).func_71560_a((ICommand)CommandReloadConfigs.SERVER);
        }
        IMCRegistry.INSTANCE.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (IConfigHandler c : this.configs) {
            c.postInitHook();
        }
        CompatRegistry.INSTANCE.handle((FMLStateEvent)event);
        ConfigHandler.instance().loadRightClickCrops();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandScoreboardInfo());
        PermanentCache.saveCaches();
    }

    @Mod.EventHandler
    public void onIMCEvent(FMLInterModComms.IMCEvent event) {
        IMCRegistry.INSTANCE.handleEvent(event);
    }

    @Override
    public String modid() {
        return MODID;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String version() {
        return VERSION;
    }
}

