/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.arboriculture.tiles.TileSapling;
import forestry.plugins.PluginArboriculture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class RenderSaplingBlock
implements ISimpleBlockRenderingHandler {
    private static int renderLayer = 0;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (modelId != this.getRenderId()) {
            return false;
        }
        TileSapling tile = BlockSapling.getSaplingTile(world, x, y, z);
        if (tile == null || tile.getTree() == null) {
            return true;
        }
        IAlleleTreeSpecies species = tile.getTree().getGenome().getPrimary();
        RenderSaplingBlock.renderCrossedSquares(species, world, block, x, y, z);
        renderLayer = 1;
        RenderSaplingBlock.renderCrossedSquares(species, world, block, x, y, z);
        renderLayer = 0;
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return PluginArboriculture.modelIdSaplings;
    }

    private static boolean renderCrossedSquares(IAlleleTreeSpecies species, IBlockAccess world, Block block, int x, int y, int z) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78380_c(block.func_149677_c(world, x, y, z));
        int colourMultiplier = species.getGermlingColour(EnumGermlingType.SAPLING, renderLayer);
        float r = (float)(colourMultiplier >> 16 & 0xFF) / 255.0f;
        float g = (float)(colourMultiplier >> 8 & 0xFF) / 255.0f;
        float b = (float)(colourMultiplier & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            r = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            g = (r * 30.0f + g * 70.0f) / 100.0f;
            b = (r * 30.0f + b * 70.0f) / 100.0f;
        }
        tess.func_78386_a(r, g, b);
        RenderSaplingBlock.drawCrossedSquares(species, x, y, z, 1.0f);
        return true;
    }

    private static void drawCrossedSquares(IAlleleTreeSpecies species, double par3, double par5, double par7, float mod) {
        Tessellator tess = Tessellator.field_78398_a;
        IIcon icon = species.getGermlingIcon(EnumGermlingType.SAPLING, renderLayer);
        double d3 = icon.func_94209_e();
        double d4 = icon.func_94206_g();
        double d5 = icon.func_94212_f();
        double d6 = icon.func_94210_h();
        double d7 = 0.45 * (double)mod;
        double d8 = par3 + 0.5 - d7;
        double d9 = par3 + 0.5 + d7;
        double d10 = par7 + 0.5 - d7;
        double d11 = par7 + 0.5 + d7;
        tess.func_78374_a(d8, par5 + (double)mod, d10, d3, d4);
        tess.func_78374_a(d8, par5 + 0.0, d10, d3, d6);
        tess.func_78374_a(d9, par5 + 0.0, d11, d5, d6);
        tess.func_78374_a(d9, par5 + (double)mod, d11, d5, d4);
        tess.func_78374_a(d9, par5 + (double)mod, d11, d3, d4);
        tess.func_78374_a(d9, par5 + 0.0, d11, d3, d6);
        tess.func_78374_a(d8, par5 + 0.0, d10, d5, d6);
        tess.func_78374_a(d8, par5 + (double)mod, d10, d5, d4);
        tess.func_78374_a(d8, par5 + (double)mod, d11, d3, d4);
        tess.func_78374_a(d8, par5 + 0.0, d11, d3, d6);
        tess.func_78374_a(d9, par5 + 0.0, d10, d5, d6);
        tess.func_78374_a(d9, par5 + (double)mod, d10, d5, d4);
        tess.func_78374_a(d9, par5 + (double)mod, d10, d3, d4);
        tess.func_78374_a(d9, par5 + 0.0, d10, d3, d6);
        tess.func_78374_a(d8, par5 + 0.0, d11, d5, d6);
        tess.func_78374_a(d8, par5 + (double)mod, d11, d5, d4);
    }
}

