/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.TileEntityCopperChest;
import cpw.mods.ironchest.TileEntityCrystalChest;
import cpw.mods.ironchest.TileEntityDiamondChest;
import cpw.mods.ironchest.TileEntityDirtChest;
import cpw.mods.ironchest.TileEntityGoldChest;
import cpw.mods.ironchest.TileEntityIronChest;
import cpw.mods.ironchest.TileEntityObsidianChest;
import cpw.mods.ironchest.TileEntitySteelChest;
import cpw.mods.ironchest.ValidatingSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.util.IIcon;

public enum IronChestType {
    IRON(54, 9, true, "Iron Chest", "ironchest.png", 0, Arrays.asList("ingotIron", "ingotRefinedIron"), TileEntityIronChest.class, "mmmmPmmmm", "mGmG3GmGm"),
    GOLD(81, 9, true, "Gold Chest", "goldchest.png", 1, Arrays.asList("ingotGold"), TileEntityGoldChest.class, "mmmmPmmmm", "mGmG4GmGm"),
    DIAMOND(108, 12, true, "Diamond Chest", "diamondchest.png", 2, Arrays.asList("gemDiamond"), TileEntityDiamondChest.class, "GGGmPmGGG", "GGGG4Gmmm"),
    COPPER(45, 9, false, "Copper Chest", "copperchest.png", 3, Arrays.asList("ingotCopper"), TileEntityCopperChest.class, "mmmmCmmmm"),
    STEEL(72, 9, false, "Steel Chest", "silverchest.png", 4, Arrays.asList("ingotSteel"), TileEntitySteelChest.class, "mmmm3mmmm", "mGmG0GmGm"),
    CRYSTAL(108, 12, true, "Crystal Chest", "crystalchest.png", 5, Arrays.asList("blockGlass"), TileEntityCrystalChest.class, "GGGGPGGGG"),
    OBSIDIAN(108, 12, false, "Obsidian Chest", "obsidianchest.png", 6, Arrays.asList("obsidian"), TileEntityObsidianChest.class, "mmmm2mmmm"),
    DIRTCHEST9000(1, 1, false, "Dirt Chest 9000", "dirtchest.png", 7, Arrays.asList("dirt"), TileEntityDirtChest.class, Item.func_150898_a((Block)Blocks.field_150346_d), "mmmmCmmmm"),
    WOOD(0, 0, false, "", "", -1, Arrays.asList("plankWood"), null, new String[0]);

    final int size;
    private final int rowLength;
    public final String friendlyName;
    private final boolean tieredChest;
    private final String modelTexture;
    private final int textureRow;
    public final Class<? extends TileEntityIronChest> clazz;
    private final String[] recipes;
    private final ArrayList<String> matList;
    private final Item itemFilter;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private static final String[] sideNames;
    private static final int[] sideMapping;

    private IronChestType(int size, int rowLength, boolean tieredChest, String friendlyName, String modelTexture, int textureRow, List<String> mats, Class<? extends TileEntityIronChest> clazz, String ... recipes) {
        this(size, rowLength, tieredChest, friendlyName, modelTexture, textureRow, mats, clazz, (Item)null, recipes);
    }

    private IronChestType(int size, int rowLength, boolean tieredChest, String friendlyName, String modelTexture, int textureRow, List<String> mats, Class<? extends TileEntityIronChest> clazz, Item itemFilter, String ... recipes) {
        this.size = size;
        this.rowLength = rowLength;
        this.tieredChest = tieredChest;
        this.friendlyName = friendlyName;
        this.modelTexture = modelTexture;
        this.textureRow = textureRow;
        this.clazz = clazz;
        this.itemFilter = itemFilter;
        this.recipes = recipes;
        this.matList = new ArrayList();
        this.matList.addAll(mats);
    }

    public String getModelTexture() {
        return this.modelTexture;
    }

    public int getTextureRow() {
        return this.textureRow;
    }

    public static TileEntityIronChest makeEntity(int metadata) {
        int chesttype = IronChestType.validateMeta(metadata);
        if (chesttype == metadata) {
            try {
                return IronChestType.values()[chesttype].clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void registerBlocksAndRecipes(BlockIronChest blockResult) {
        String previous = "chestWood";
        for (IronChestType typ : IronChestType.values()) {
            ItemStack chest = new ItemStack((Block)blockResult, 1, typ.ordinal());
            if (typ.isValidForCreativeMode()) {
                GameRegistry.registerCustomItemStack((String)typ.friendlyName, (ItemStack)chest);
            }
            if (!typ.tieredChest) continue;
            previous = chest;
        }
    }

    public static Object translateOreName(String mat) {
        if (mat.equals("obsidian")) {
            return Blocks.field_150343_Z;
        }
        if (mat.equals("dirt")) {
            return Blocks.field_150346_d;
        }
        return mat;
    }

    public static void addRecipe(ItemStack is, Object ... parts) {
    }

    public int getRowCount() {
        return this.size / this.rowLength;
    }

    public int getRowLength() {
        return this.rowLength;
    }

    public boolean isTransparent() {
        return this == CRYSTAL;
    }

    public List<String> getMatList() {
        return this.matList;
    }

    public static int validateMeta(int i) {
        if (i < IronChestType.values().length && IronChestType.values()[i].size > 0) {
            return i;
        }
        return 0;
    }

    public boolean isValidForCreativeMode() {
        return IronChestType.validateMeta(this.ordinal()) == this.ordinal();
    }

    public boolean isExplosionResistant() {
        return this == OBSIDIAN;
    }

    @SideOnly(value=Side.CLIENT)
    public void makeIcons(IIconRegister par1IconRegister) {
        if (this.isValidForCreativeMode()) {
            this.icons = new IIcon[3];
            int i = 0;
            for (String s : sideNames) {
                if (this.name().equalsIgnoreCase("steel")) {
                    this.icons[i++] = par1IconRegister.func_94245_a(String.format("ironchest:silver_%s", s));
                    continue;
                }
                this.icons[i++] = par1IconRegister.func_94245_a(String.format("ironchest:%s_%s", this.name().toLowerCase(), s));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side) {
        return this.icons[sideMapping[side]];
    }

    public Slot makeSlot(IInventory chestInventory, int index, int x, int y) {
        return new ValidatingSlot(chestInventory, index, x, y, this);
    }

    public boolean acceptsStack(ItemStack itemstack) {
        return this.itemFilter == null || itemstack == null || itemstack.func_77973_b() == this.itemFilter;
    }

    public void adornItemDrop(ItemStack item) {
        if (this == DIRTCHEST9000) {
            item.func_77983_a("dirtchest", (NBTBase)new NBTTagByte(1));
        }
    }

    static {
        sideNames = new String[]{"top", "front", "side"};
        sideMapping = new int[]{0, 0, 2, 1, 2, 2, 2};
    }
}

