/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.GuiListBiomes;
import com.chaosthedude.naturescompass.gui.GuiListBiomesEntry;
import com.chaosthedude.naturescompass.gui.GuiTransparentButton;
import com.chaosthedude.naturescompass.gui.GuiTransparentTextField;
import com.chaosthedude.naturescompass.items.ItemNaturesCompass;
import com.chaosthedude.naturescompass.network.PacketCompassSearch;
import com.chaosthedude.naturescompass.network.PacketTeleport;
import com.chaosthedude.naturescompass.sorting.CategoryName;
import com.chaosthedude.naturescompass.sorting.ISortingCategory;
import com.chaosthedude.naturescompass.util.BiomeSearchWorker;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.EnumCompassState;
import com.chaosthedude.naturescompass.util.PlayerUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiNaturesCompass
extends GuiScreen {
    private World world;
    private EntityPlayer player;
    private ItemStack stack;
    private ItemNaturesCompass natureCompass;
    private List<BiomeGenBase> allowedBiomes;
    private List<BiomeGenBase> biomesMatchingSearch;
    private GuiButton searchButton;
    private GuiButton teleportButton;
    private GuiButton infoButton;
    private GuiButton cancelButton;
    private GuiButton sortByButton;
    private GuiTransparentTextField searchTextField;
    private GuiListBiomes selectionList;
    private ISortingCategory sortingCategory;

    public GuiNaturesCompass(World world, EntityPlayer player, ItemStack stack, ItemNaturesCompass natureCompass, List<BiomeGenBase> allowedBiomes) {
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.natureCompass = natureCompass;
        this.allowedBiomes = allowedBiomes;
        this.sortingCategory = new CategoryName();
        this.biomesMatchingSearch = new ArrayList<BiomeGenBase>(allowedBiomes);
        this.updateBiomesEntry();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.setupButtons();
        this.setupTextFields();
        this.selectionList = new GuiListBiomes(this, this.field_146297_k, this.field_146294_l + 110, this.field_146295_m, 40, this.field_146295_m, 36);
    }

    public void func_73876_c() {
        this.searchTextField.func_146178_a();
        this.teleportButton.field_146125_m = NaturesCompass.canTeleport || PlayerUtils.cheatModeEnabled(this.player);
        this.teleportButton.field_146124_l = this.natureCompass.getState(this.stack) == EnumCompassState.FOUND;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            GuiListBiomesEntry biomesEntry = this.selectionList.getSelectedBiome();
            if (button == this.searchButton) {
                if (biomesEntry != null) {
                    biomesEntry.selectBiome();
                }
            } else if (button == this.teleportButton) {
                this.teleport();
            } else if (button == this.infoButton) {
                biomesEntry.viewInfo();
            } else if (button == this.sortByButton) {
                this.sortingCategory = this.sortingCategory.next();
                this.sortByButton.field_146126_j = I18n.func_135052_a((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName();
                this.selectionList.refreshList();
            } else if (button == this.cancelButton) {
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.selectionList.func_148128_a(mouseX, mouseY, partialTicks);
        this.searchTextField.func_146194_f();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.selectBiome", (Object[])new Object[0]), 65, 15, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.selectionList.func_148179_a(mouseX, mouseY, mouseButton);
        this.searchTextField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        if (this.searchTextField.func_146206_l()) {
            this.searchTextField.func_146201_a(typedChar, keyCode);
            this.processSearchTerm();
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void selectBiome(GuiListBiomesEntry entry) {
        boolean enable;
        this.searchButton.field_146124_l = enable = entry != null;
        this.infoButton.field_146124_l = enable;
    }

    public void searchForBiome(BiomeGenBase biome) {
        NaturesCompass.network.sendToServer((IMessage)new PacketCompassSearch(biome.field_76756_M, (int)this.player.field_70165_t, (int)this.player.field_70161_v));
        this.field_146297_k.func_147108_a(null);
    }

    public void updateBiomesEntry() {
        if (BiomeSearchWorker.completedSearch && BiomeSearchWorker.oldDimensionId == this.world.field_73011_w.field_76574_g && BiomeSearchWorker.availableBiomes != null) {
            this.biomesMatchingSearch = new ArrayList<BiomeGenBase>(BiomeSearchWorker.availableBiomes);
            this.allowedBiomes = this.biomesMatchingSearch;
        }
    }

    public void teleport() {
        NaturesCompass.network.sendToServer((IMessage)new PacketTeleport());
        this.field_146297_k.func_147108_a(null);
    }

    public ISortingCategory getSortingCategory() {
        return this.sortingCategory;
    }

    private Set<BiomeGenBase> findMatchedBiomes(String category, String value) {
        HashSet<BiomeGenBase> biomeMatching;
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        biomeMatching = new HashSet<BiomeGenBase>();
                                        if (!category.equals(I18n.func_135052_a((String)"string.naturescompass.name", (Object[])new Object[0]).toLowerCase())) break block8;
                                        for (BiomeGenBase biome : this.allowedBiomes) {
                                            if (!BiomeUtils.getBiomeName(biome).toLowerCase().contains(value)) continue;
                                            biomeMatching.add(biome);
                                        }
                                        break block9;
                                    }
                                    if (!category.equals(I18n.func_135052_a((String)"string.naturescompass.climate", (Object[])new Object[0]).toLowerCase())) break block10;
                                    for (BiomeGenBase biome : this.allowedBiomes) {
                                        if (!BiomeUtils.getBiomeClimate(biome).toLowerCase().contains(value)) continue;
                                        biomeMatching.add(biome);
                                    }
                                    break block9;
                                }
                                if (!category.equals(I18n.func_135052_a((String)"string.naturescompass.baseHeight", (Object[])new Object[0]).toLowerCase()) && !category.equals("bh")) break block11;
                                for (BiomeGenBase biome : this.allowedBiomes) {
                                    if (!String.valueOf(biome.field_76748_D).contains(value)) continue;
                                    biomeMatching.add(biome);
                                }
                                break block9;
                            }
                            if (!category.equals(I18n.func_135052_a((String)"string.naturescompass.heightVariation", (Object[])new Object[0]).toLowerCase()) && !category.equals("hv")) break block12;
                            for (BiomeGenBase biome : this.allowedBiomes) {
                                if (!String.valueOf(biome.field_76749_E).contains(value)) continue;
                                biomeMatching.add(biome);
                            }
                            break block9;
                        }
                        if (!category.equals(I18n.func_135052_a((String)"string.naturescompass.rainfall", (Object[])new Object[0]).toLowerCase()) && !category.equals("rain")) break block13;
                        for (BiomeGenBase biome : this.allowedBiomes) {
                            if (!String.valueOf(biome.field_76751_G).contains(value)) continue;
                            biomeMatching.add(biome);
                        }
                        break block9;
                    }
                    if (!category.equals(I18n.func_135052_a((String)"string.naturescompass.temperature", (Object[])new Object[0]).toLowerCase()) && !category.equals("temp")) break block14;
                    for (BiomeGenBase biome : this.allowedBiomes) {
                        if (!String.valueOf(biome.field_76750_F).contains(value)) continue;
                        biomeMatching.add(biome);
                    }
                    break block9;
                }
                if (!category.equals(I18n.func_135052_a((String)"string.naturescompass.humidity", (Object[])new Object[0]).toLowerCase())) break block15;
                for (BiomeGenBase biome : this.allowedBiomes) {
                    if (!BiomeUtils.getBiomeHumidity(biome).toLowerCase().contains(value)) continue;
                    biomeMatching.add(biome);
                }
                break block9;
            }
            if (!category.equals(I18n.func_135052_a((String)"string.naturescompass.tags", (Object[])new Object[0]).toLowerCase()) && !category.equals("tag")) break block9;
            for (BiomeGenBase biome : this.allowedBiomes) {
                if (!BiomeUtils.getListBiomeTags(biome).contains(value)) continue;
                biomeMatching.add(biome);
            }
        }
        return biomeMatching;
    }

    public void processSearchTerm() {
        String text = this.searchTextField.func_146179_b().toLowerCase();
        String[] arrayText = text.trim().split("\\s*,\\s*");
        HashSet<BiomeGenBase> biomeMatchingTemp2 = new HashSet<BiomeGenBase>(this.allowedBiomes);
        for (String part : arrayText) {
            String[] arrayPart = part.trim().split("\\s*:\\s*", 2);
            Set<Object> biomeMatchingTemp1 = new HashSet();
            if (arrayText.length == 1 && arrayPart.length == 1) {
                biomeMatchingTemp1 = this.findMatchedBiomes(this.getSortingCategory().getLocalizedName().toLowerCase(), arrayPart[0]);
            } else if (arrayPart.length == 2) {
                biomeMatchingTemp1 = this.findMatchedBiomes(arrayPart[0], arrayPart[1]);
            }
            biomeMatchingTemp2.retainAll(biomeMatchingTemp1);
        }
        this.biomesMatchingSearch = new ArrayList<BiomeGenBase>(biomeMatchingTemp2);
        this.selectionList.refreshList();
    }

    public List<BiomeGenBase> sortBiomes() {
        List<BiomeGenBase> biomes = this.biomesMatchingSearch;
        Collections.sort(biomes, new CategoryName());
        Collections.sort(biomes, this.sortingCategory);
        return biomes;
    }

    protected <T extends GuiButton> T addButton(T button) {
        this.field_146292_n.add(button);
        return button;
    }

    private void setupButtons() {
        this.field_146292_n.clear();
        this.cancelButton = this.addButton(new GuiTransparentButton(0, 10, this.field_146295_m - 30, 110, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.sortByButton = this.addButton(new GuiTransparentButton(1, 10, 90, 110, 20, I18n.func_135052_a((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName()));
        this.infoButton = this.addButton(new GuiTransparentButton(2, 10, 65, 110, 20, I18n.func_135052_a((String)"string.naturescompass.info", (Object[])new Object[0])));
        this.searchButton = this.addButton(new GuiTransparentButton(3, 10, 40, 110, 20, I18n.func_135052_a((String)"string.naturescompass.search", (Object[])new Object[0])));
        this.teleportButton = this.addButton(new GuiTransparentButton(4, 10, this.field_146295_m - 55, 110, 20, I18n.func_135052_a((String)"string.naturescompass.teleport", (Object[])new Object[0])));
        this.searchButton.field_146124_l = false;
        this.infoButton.field_146124_l = false;
        this.teleportButton.field_146125_m = NaturesCompass.canTeleport || PlayerUtils.cheatModeEnabled(this.player);
    }

    private void setupTextFields() {
        this.searchTextField = new GuiTransparentTextField(this.field_146289_q, 130, 10, this.field_146294_l - 200, 20);
        this.searchTextField.setLabel(I18n.func_135052_a((String)"string.naturescompass.search", (Object[])new Object[0]));
    }
}

