/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.charms.handler;

import chylex.hee.init.ItemList;
import chylex.hee.mechanics.charms.CharmPouchInfo;
import chylex.hee.mechanics.charms.handler.CharmEvents;
import chylex.hee.system.util.ItemUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public final class CharmPouchHandler {
    private static CharmPouchHandler instance;
    private final Map<UUID, CharmPouchInfo> activePouchIDs = new HashMap<UUID, CharmPouchInfo>();
    private final CharmEvents events = new CharmEvents();
    private boolean isHandlerActive;
    private boolean refresh;

    public static void register() {
        instance = new CharmPouchHandler();
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    public static void setActivePouch(EntityPlayer player, ItemStack is) {
        if (is == null) {
            CharmPouchHandler.instance.activePouchIDs.remove(player.func_146103_bH().getId());
        } else {
            CharmPouchHandler.instance.activePouchIDs.put(player.func_146103_bH().getId(), new CharmPouchInfo(is));
        }
        CharmPouchHandler.instance.refresh = true;
    }

    public static CharmPouchInfo getActivePouch(EntityPlayer player) {
        return CharmPouchHandler.instance.activePouchIDs.get(player.func_146103_bH().getId());
    }

    private CharmPouchHandler() {
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.END || !this.refresh) {
            return;
        }
        if (!this.isHandlerActive && !this.activePouchIDs.isEmpty()) {
            this.isHandlerActive = true;
            MinecraftForge.EVENT_BUS.register((Object)this.events);
            FMLCommonHandler.instance().bus().register((Object)this.events);
        } else if (this.isHandlerActive && this.activePouchIDs.isEmpty()) {
            this.isHandlerActive = false;
            this.events.onDisabled();
            MinecraftForge.EVENT_BUS.unregister((Object)this.events);
            FMLCommonHandler.instance().bus().unregister((Object)this.events);
        }
        this.refresh = false;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        ItemStack[] mainInv = e.player.field_71071_by.field_70462_a;
        for (int a = 0; a < mainInv.length; ++a) {
            if (mainInv[a] == null || mainInv[a].func_77973_b() != ItemList.charm_pouch || !ItemUtil.getTagRoot(mainInv[a], false).func_74767_n("isPouchActive")) continue;
            CharmPouchHandler.setActivePouch(e.player, mainInv[a]);
            break;
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        if (this.activePouchIDs.remove(e.player.func_146103_bH().getId()) != null) {
            this.refresh = true;
        }
    }
}

