/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.compat.IByteIO;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.FoodSet;
import squeek.spiceoflife.foodtracker.MaxHealthHandler;
import squeek.spiceoflife.foodtracker.ProgressInfo;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.foodtracker.foodqueue.FixedSizeQueue;
import squeek.spiceoflife.foodtracker.foodqueue.FoodQueue;
import squeek.spiceoflife.helpers.FoodHelper;
import squeek.spiceoflife.helpers.MiscHelper;
import squeek.spiceoflife.interfaces.IPackable;
import squeek.spiceoflife.interfaces.ISaveable;

public class FoodHistory
implements IExtendedEntityProperties,
ISaveable,
IPackable {
    public static final String TAG_KEY = "SpiceOfLifeHistory";
    public final EntityPlayer player;
    public int totalFoodsEatenAllTime = 0;
    public boolean wasGivenFoodJournal = false;
    public long ticksActive = 0L;
    protected FoodQueue recentHistory = FoodHistory.getNewFoodQueue();
    protected FoodSet fullHistory = new FoodSet();
    @Nullable
    private ProgressInfo cachedProgressInfo;

    public FoodHistory() {
        this(null);
    }

    public FoodHistory(EntityPlayer player) {
        this.player = player;
        if (player != null) {
            player.registerExtendedProperties(TAG_KEY, (IExtendedEntityProperties)this);
        }
    }

    public static FoodHistory get(EntityPlayer player) {
        FoodHistory foodHistory = (FoodHistory)player.getExtendedProperties(TAG_KEY);
        if (foodHistory == null) {
            foodHistory = new FoodHistory(player);
        }
        return foodHistory;
    }

    public boolean hasEverEaten(ItemStack food) {
        return this.fullHistory.contains(new FoodEaten(food));
    }

    public ProgressInfo getProgressInfo() {
        if (this.cachedProgressInfo == null) {
            this.cachedProgressInfo = new ProgressInfo(this);
        }
        return this.cachedProgressInfo;
    }

    public void onHistoryTypeChanged() {
        FoodQueue oldHistory = this.recentHistory;
        this.recentHistory = FoodHistory.getNewFoodQueue();
        this.recentHistory.addAll(oldHistory);
    }

    public int getFoodCountForFoodGroup(ItemStack food, FoodGroup foodGroup) {
        int count = 0;
        for (FoodEaten foodEaten : this.recentHistory) {
            if (foodEaten.itemStack == null || !food.func_77969_a(foodEaten.itemStack) && !foodEaten.getFoodGroups().contains(foodGroup)) continue;
            ++count;
        }
        return count;
    }

    public static FoodQueue getNewFoodQueue() {
        return new FixedSizeQueue(ModConfig.FOOD_HISTORY_LENGTH);
    }

    public void deltaTicksActive(long delta) {
        this.ticksActive += delta;
    }

    public int getFoodCountIgnoringFoodGroups(ItemStack food) {
        return this.getFoodCountForFoodGroup(food, null);
    }

    public boolean containsFoodOrItsFoodGroups(ItemStack food) {
        Set<FoodGroup> foodGroups = FoodGroupRegistry.getFoodGroupsForFood(food);
        for (FoodEaten foodEaten : this.recentHistory) {
            if (foodEaten.itemStack == null || !food.func_77969_a(foodEaten.itemStack) && !MiscHelper.collectionsOverlap(foodGroups, foodEaten.getFoodGroups())) continue;
            return true;
        }
        return false;
    }

    public FoodValues getTotalFoodValuesForFoodGroup(ItemStack food, FoodGroup foodGroup) {
        int totalHunger = 0;
        float totalSaturation = 0.0f;
        for (FoodEaten foodEaten : this.recentHistory) {
            if (foodEaten.itemStack == null || !food.func_77969_a(foodEaten.itemStack) && !foodEaten.getFoodGroups().contains(foodGroup)) continue;
            totalHunger += foodEaten.foodValues.hunger;
            totalSaturation += foodEaten.foodValues.getSaturationIncrement();
        }
        if (totalHunger == 0) {
            return new FoodValues(0, 0.0f);
        }
        return new FoodValues(totalHunger, totalSaturation);
    }

    public FoodValues getTotalFoodValuesIgnoringFoodGroups(ItemStack food) {
        return this.getTotalFoodValuesForFoodGroup(food, null);
    }

    public int getHistoryLength() {
        return this.recentHistory.size();
    }

    public FoodEaten getLastEatenFood() {
        return (FoodEaten)this.recentHistory.peekLast();
    }

    public Set<FoodGroup> getDistinctFoodGroups() {
        HashSet<FoodGroup> distinctFoodGroups = new HashSet<FoodGroup>();
        for (FoodEaten foodEaten : this.recentHistory) {
            if (foodEaten.itemStack == null) continue;
            distinctFoodGroups.addAll(foodEaten.getFoodGroups());
        }
        return distinctFoodGroups;
    }

    public void reset() {
        this.recentHistory.clear();
        this.fullHistory.clear();
        this.invalidateProgressInfo();
        this.totalFoodsEatenAllTime = 0;
        this.wasGivenFoodJournal = false;
        this.ticksActive = 0L;
    }

    public void invalidateProgressInfo() {
        this.cachedProgressInfo = null;
    }

    public void validate() {
        ArrayList<FoodEaten> invalidFoods = new ArrayList<FoodEaten>();
        for (FoodEaten foodEaten : this.recentHistory) {
            if (FoodHelper.isValidFood(foodEaten.itemStack)) continue;
            invalidFoods.add(foodEaten);
        }
        this.recentHistory.removeAll(invalidFoods);
        this.totalFoodsEatenAllTime -= invalidFoods.size();
    }

    @Override
    public void pack(IByteIO data) {
        data.writeLong(this.ticksActive);
        data.writeShort(this.getRecentHistory().size());
        for (FoodEaten foodEaten : this.getRecentHistory()) {
            foodEaten.pack(data);
        }
        data.writeShort(this.getFullHistory().size());
        this.getFullHistory().forEach(f -> f.pack(data));
    }

    public FoodQueue getRecentHistory() {
        return this.recentHistory;
    }

    public Set<FoodEaten> getFullHistory() {
        return this.fullHistory;
    }

    @Override
    public void unpack(IByteIO data) {
        this.ticksActive = data.readLong();
        int historySize = data.readShort();
        for (int i = 0; i < historySize; ++i) {
            FoodEaten foodEaten = new FoodEaten();
            foodEaten.unpack(data);
            this.addFood(foodEaten);
        }
        int fullHistorySize = data.readShort();
        for (int i = 0; i < fullHistorySize; ++i) {
            FoodEaten foodEaten = new FoodEaten();
            foodEaten.unpack(data);
            this.addFoodFullHistory(foodEaten);
        }
    }

    public void addFood(FoodEaten foodEaten) {
        this.addFood(foodEaten, true);
    }

    public void addFoodFullHistory(FoodEaten foodEaten) {
        boolean hasTriedNewFood = this.fullHistory.add(foodEaten);
        if (this.player != null && hasTriedNewFood) {
            this.invalidateProgressInfo();
            boolean newMilestoneReached = MaxHealthHandler.updateFoodHPModifier(this.player);
            if (newMilestoneReached) {
                FoodHistory.spawnParticles(this.player, "heart", 12);
                FoodHistory.spawnParticles(this.player, "happyVillager", 12);
                this.player.field_70170_p.func_72956_a((Entity)this.player, "random.levelup", 1.0f, 1.0f);
            } else {
                FoodHistory.spawnParticles(this.player, "heart", 12);
            }
        }
    }

    public void addFood(FoodEaten foodEaten, boolean countsTowardsAllTime) {
        if (countsTowardsAllTime) {
            ++this.totalFoodsEatenAllTime;
        }
        this.addFoodRecent(foodEaten);
        this.addFoodFullHistory(foodEaten);
    }

    public void addFoodRecent(FoodEaten foodEaten) {
        this.recentHistory.add(foodEaten);
    }

    public void saveNBTData(NBTTagCompound compound) {
        this.writeToNBTData(compound);
    }

    private static void spawnParticles(EntityPlayer player, String type, int count) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!(player.field_70170_p instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)player.field_70170_p;
        world.func_147487_a(type, (double)((float)player.field_70165_t), (double)((float)player.field_70163_u + 2.0f), (double)((float)player.field_70161_v), count, 1.0, 1.0, 1.0, (double)0.2f);
    }

    @Override
    public void writeToNBTData(NBTTagCompound data) {
        NBTTagCompound rootPersistentCompound = this.player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound nonPersistentCompound = new NBTTagCompound();
        NBTTagCompound persistentCompound = new NBTTagCompound();
        if (this.recentHistory.size() > 0 && (data != null || ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH)) {
            NBTTagCompound nbtHistory = new NBTTagCompound();
            this.recentHistory.writeToNBTData(nbtHistory);
            if (ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH) {
                persistentCompound.func_74782_a("History", (NBTBase)nbtHistory);
            } else {
                nonPersistentCompound.func_74782_a("History", (NBTBase)nbtHistory);
            }
        }
        if (this.fullHistory.size() > 0) {
            NBTTagCompound nbtFullHistory = new NBTTagCompound();
            this.fullHistory.writeToNBTData(nbtFullHistory);
            persistentCompound.func_74782_a("FullHistory", (NBTBase)nbtFullHistory);
        }
        if (this.totalFoodsEatenAllTime > 0) {
            persistentCompound.func_74768_a("Total", this.totalFoodsEatenAllTime);
        }
        if (this.wasGivenFoodJournal) {
            persistentCompound.func_74757_a("FoodJournal", this.wasGivenFoodJournal);
        }
        if (this.ticksActive > 0L) {
            persistentCompound.func_74772_a("Ticks", this.ticksActive);
        }
        if (data != null && !nonPersistentCompound.func_82582_d()) {
            data.func_74782_a(TAG_KEY, (NBTBase)nonPersistentCompound);
        }
        if (!persistentCompound.func_82582_d()) {
            rootPersistentCompound.func_74782_a(TAG_KEY, (NBTBase)persistentCompound);
        }
        if (!this.player.getEntityData().func_74764_b("PlayerPersisted")) {
            this.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)rootPersistentCompound);
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.readFromNBTData(compound);
    }

    public void init(Entity entity, World world) {
    }

    @Override
    public void readFromNBTData(NBTTagCompound data) {
        NBTTagCompound rootPersistentCompound = this.player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound persistentCompound = rootPersistentCompound.func_74775_l(TAG_KEY);
        if (data != null && data.func_74764_b(TAG_KEY) || rootPersistentCompound.func_74764_b(TAG_KEY)) {
            NBTTagCompound nonPersistentCompound = data != null ? data.func_74775_l(TAG_KEY) : new NBTTagCompound();
            NBTTagCompound nbtHistory = ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH ? persistentCompound.func_74775_l("History") : nonPersistentCompound.func_74775_l("History");
            this.recentHistory.readFromNBTData(nbtHistory);
            this.totalFoodsEatenAllTime = persistentCompound.func_74762_e("Total");
            this.wasGivenFoodJournal = persistentCompound.func_74767_n("FoodJournal");
            this.ticksActive = persistentCompound.func_74763_f("Ticks");
        }
        this.fullHistory.readFromNBTData(persistentCompound.func_74775_l("FullHistory"));
    }
}

