/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ItemViewCell;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.IPartitionList;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class SlotCraftingTerm
extends AppEngCraftingSlot {
    private final IInventory craftInv;
    private final IInventory pattern;
    private final BaseActionSource mySrc;
    private final IEnergySource energySrc;
    private final IStorageMonitorable storage;
    private final IContainerCraftingPacket container;

    public SlotCraftingTerm(EntityPlayer player, BaseActionSource mySrc, IEnergySource energySrc, IStorageMonitorable storage, IInventory cMatrix, IInventory secondMatrix, IInventory output, int x, int y, IContainerCraftingPacket ccp) {
        super(player, cMatrix, output, 0, x, y);
        this.energySrc = energySrc;
        this.storage = storage;
        this.mySrc = mySrc;
        this.pattern = cMatrix;
        this.craftInv = secondMatrix;
        this.container = ccp;
    }

    public IInventory getCraftingMatrix() {
        return this.craftInv;
    }

    @Override
    public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
        return false;
    }

    @Override
    public void func_82870_a(EntityPlayer p, ItemStack is) {
    }

    public void doClick(InventoryAction action, EntityPlayer who) {
        ItemStack res;
        if (this.func_75211_c() == null) {
            return;
        }
        if (Platform.isClient()) {
            return;
        }
        IMEMonitor<IAEItemStack> inv = this.storage.getItemInventory();
        int howManyPerCraft = this.func_75211_c().field_77994_a;
        int maxTimesToCraft = 0;
        InventoryAdaptor ia = null;
        if (action == InventoryAction.CRAFT_SHIFT) {
            ia = InventoryAdaptor.getAdaptor(who, null);
            maxTimesToCraft = (int)Math.floor((double)this.func_75211_c().func_77976_d() / (double)howManyPerCraft);
        } else if (action == InventoryAction.CRAFT_STACK) {
            ia = new AdaptorPlayerHand(who);
            maxTimesToCraft = (int)Math.floor((double)this.func_75211_c().func_77976_d() / (double)howManyPerCraft);
        } else {
            ia = new AdaptorPlayerHand(who);
            maxTimesToCraft = 1;
        }
        maxTimesToCraft = this.capCraftingAttempts(maxTimesToCraft);
        if (ia == null) {
            return;
        }
        ItemStack rs = Platform.cloneItemStack(this.func_75211_c());
        if (rs == null) {
            return;
        }
        rs.field_77994_a *= maxTimesToCraft;
        if (ia.simulateAdd(rs) != null) {
            return;
        }
        IItemList<IAEItemStack> all = inv.getStorageList();
        while ((res = this.craftItem(who, rs, inv, all)) != null) {
            rs.field_77994_a -= res.field_77994_a;
            ItemStack extra = ia.addItems(res);
            if (extra != null) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                drops.add(extra);
                Platform.spawnDrops(who.field_70170_p, (int)who.field_70165_t, (int)who.field_70163_u, (int)who.field_70161_v, drops);
                break;
            }
            if (rs.field_77994_a > 0) continue;
        }
    }

    private int capCraftingAttempts(int maxTimesToCraft) {
        return maxTimesToCraft;
    }

    private ItemStack craftItem(EntityPlayer p, ItemStack request, IMEMonitor<IAEItemStack> inv, IItemList all) {
        ItemStack is = this.func_75211_c();
        if (is != null && Platform.isSameItem(request, is)) {
            ItemStack[] set = new ItemStack[this.getPattern().func_70302_i_()];
            int multiple = request.field_77994_a / is.field_77994_a;
            if (Platform.isServer()) {
                IPartitionList<IAEItemStack> filter;
                InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
                for (int x = 0; x < 9; ++x) {
                    ic.func_70299_a(x, this.getPattern().func_70301_a(x));
                }
                IRecipe r = Platform.findMatchingRecipe(ic, p.field_70170_p);
                if (r == null) {
                    if (request.field_77994_a > is.field_77994_a) {
                        return null;
                    }
                    Item target = request.func_77973_b();
                    if (target.func_77645_m() && target.isRepairable()) {
                        boolean isBad = false;
                        for (int x = 0; x < ic.func_70302_i_(); ++x) {
                            ItemStack pis = ic.func_70301_a(x);
                            if (pis == null || pis.func_77973_b() == target) continue;
                            isBad = true;
                        }
                        if (!isBad) {
                            super.func_82870_a(p, is);
                            p.field_71070_bA.func_75130_a(this.craftInv);
                            return request;
                        }
                    }
                    return null;
                }
                is = r.func_77572_b(ic);
                if (inv != null && !this.extractItems(p, inv, all, is, set, multiple, ic, r, filter = ItemViewCell.createFilter(this.container.getViewCells()))) {
                    this.cleanup(p, inv, set);
                    multiple = 1;
                    this.extractItems(p, inv, all, is, set, 1, ic, r, filter);
                }
            }
            int crafted = 0;
            if (this.preCraft(p, inv, set, is)) {
                for (int i = 0; i < multiple; ++i) {
                    this.makeItem(p, is);
                    ++crafted;
                    if (!this.postCraft(p, inv, set, is) && i < multiple - 1) break;
                }
            }
            is.field_77994_a *= crafted;
            this.cleanup(p, inv, set);
            p.field_71070_bA.func_75130_a(this.craftInv);
            return is;
        }
        return null;
    }

    private boolean extractItems(EntityPlayer p, IMEMonitor<IAEItemStack> inv, IItemList all, ItemStack is, ItemStack[] set, int multiple, InventoryCrafting ic, IRecipe r, IPartitionList<IAEItemStack> filter) {
        for (int x = 0; x < this.getPattern().func_70302_i_(); ++x) {
            if (this.getPattern().func_70301_a(x) == null) continue;
            set[x] = Platform.extractItemsByRecipe(this.energySrc, this.mySrc, inv, p.field_70170_p, r, is, ic, this.getPattern().func_70301_a(x), x, all, Actionable.MODULATE, filter, multiple);
            if (set[x] != null) continue;
            if (multiple > 1) {
                return false;
            }
            set[x] = this.getPattern().func_70301_a(x).func_77946_l();
            set[x].field_77994_a = 0;
        }
        return true;
    }

    private boolean preCraft(EntityPlayer p, IMEMonitor<IAEItemStack> inv, ItemStack[] set, ItemStack result) {
        return true;
    }

    private void makeItem(EntityPlayer p, ItemStack is) {
        super.func_82870_a(p, is);
    }

    private boolean postCraft(EntityPlayer p, IMEMonitor<IAEItemStack> inv, ItemStack[] set, ItemStack result) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        boolean hadEmptyStacks = false;
        if (Platform.isServer()) {
            for (int x = 0; x < this.craftInv.func_70302_i_(); ++x) {
                if (this.craftInv.func_70301_a(x) == null) {
                    if (set[x] == null) continue;
                    if (set[x].field_77994_a > 0) {
                        ItemStack s = set[x].func_77946_l();
                        s.field_77994_a = 1;
                        this.craftInv.func_70299_a(x, s);
                        --set[x].field_77994_a;
                    }
                    hadEmptyStacks |= set[x].field_77994_a == 0;
                    continue;
                }
                if (set[x] == null || Platform.isSameItem(this.craftInv.func_70301_a(x), set[x])) continue;
                IAEItemStack fail = inv.injectItems(AEItemStack.create(set[x]), Actionable.MODULATE, this.mySrc);
                if (fail != null) {
                    drops.add(fail.getItemStack());
                }
                set[x] = null;
                hadEmptyStacks = true;
            }
        }
        if (drops.size() > 0) {
            Platform.spawnDrops(p.field_70170_p, (int)p.field_70165_t, (int)p.field_70163_u, (int)p.field_70161_v, drops);
        }
        return !hadEmptyStacks;
    }

    private void cleanup(EntityPlayer p, IMEMonitor<IAEItemStack> inv, ItemStack[] set) {
        if (Platform.isServer()) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (ItemStack itemStack : set) {
                IAEItemStack fail;
                if (itemStack == null || itemStack.field_77994_a <= 0 || (fail = (IAEItemStack)inv.injectItems(AEItemStack.create(itemStack), Actionable.MODULATE, this.mySrc)) == null) continue;
                drops.add(fail.getItemStack());
            }
            if (drops.size() > 0) {
                Platform.spawnDrops(p.field_70170_p, (int)p.field_70165_t, (int)p.field_70163_u, (int)p.field_70161_v, drops);
            }
        }
    }

    IInventory getPattern() {
        return this.pattern;
    }
}

