/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.gregtech;

import gregtech.GT_Mod;
import gregtech.api.objects.GT_UO_Dimension;
import gregtech.api.objects.GT_UO_Fluid;
import gregtech.api.objects.XSTR;
import gregtech.common.GT_Proxy;
import gregtech.common.GT_UndergroundOil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class UndergroundFluidsWrapper {
    private static final boolean isGTNHGregTechUndergroundFluids;
    private static final float MODE_READ_ONLY = -1.0f;

    public static FluidStack prospectFluid(World world, int chunkX, int chunkZ) {
        if (isGTNHGregTechUndergroundFluids) {
            return GT_UndergroundOil.undergroundOil((World)world, (int)chunkX, (int)chunkZ, (float)-1.0f);
        }
        return UndergroundFluidsWrapper.vanillaProspectFluid(world, chunkX, chunkZ);
    }

    private static FluidStack vanillaProspectFluid(World world, int chunkX, int chunkZ) {
        FluidStack fluidInChunk;
        ChunkCoordIntPair chunkCoordinate = new ChunkCoordIntPair(chunkX, chunkZ);
        int dimensionId = world.field_73011_w.field_76574_g;
        GT_UO_Dimension dimension = GT_Mod.gregtechproxy.mUndergroundOil.GetDimension(dimensionId);
        if (dimension == null) {
            return null;
        }
        Map chunkData = GT_Proxy.dimensionWiseChunkData.computeIfAbsent(dimensionId, k -> new HashMap(1024));
        int[] tInts = (int[])chunkData.get(chunkCoordinate);
        if (tInts == null) {
            tInts = GT_Proxy.getDefaultChunkDataOnCreation();
        } else if (tInts[3] == 0) {
            return new FluidStack(FluidRegistry.getFluid((int)tInts[2]), 0);
        }
        XSTR tRandom = new XSTR(world.func_72905_C() + (long)dimensionId * 2L + (long)(chunkX >> 3) + 8267L * (long)(chunkZ >> 3));
        GT_UO_Fluid uoFluid = dimension.getRandomFluid((Random)tRandom);
        if (uoFluid == null || uoFluid.getFluid() == null) {
            tInts[2] = Integer.MAX_VALUE;
            tInts[3] = 0;
            chunkData.put(chunkCoordinate, tInts);
            return null;
        }
        if (tInts[2] == uoFluid.getFluid().getID()) {
            fluidInChunk = new FluidStack(uoFluid.getFluid(), tInts[3]);
        } else {
            fluidInChunk = new FluidStack(uoFluid.getFluid(), uoFluid.getRandomAmount((Random)tRandom));
            fluidInChunk.amount = (int)((float)fluidInChunk.amount * (0.75f + XSTR.XSTR_INSTANCE.nextFloat() / 2.0f));
        }
        tInts[3] = fluidInChunk.amount;
        tInts[2] = fluidInChunk.getFluidID();
        if (fluidInChunk.amount <= 5000) {
            fluidInChunk.amount = 0;
            tInts[3] = 0;
        } else {
            fluidInChunk.amount /= 5000;
        }
        chunkData.put(chunkCoordinate, tInts);
        return fluidInChunk;
    }

    static {
        boolean foundMethod;
        try {
            GT_UndergroundOil.class.getDeclaredMethod("undergroundOil", World.class, Integer.TYPE, Integer.TYPE, Float.TYPE);
            foundMethod = true;
        }
        catch (NoSuchMethodException e) {
            foundMethod = false;
        }
        isGTNHGregTechUndergroundFluids = foundMethod;
    }
}

