/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.journeymap.drawsteps;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.integration.DrawUtils;
import com.sinthoras.visualprospecting.integration.journeymap.drawsteps.ClickableDrawStep;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import com.sinthoras.visualprospecting.integration.model.locations.OreVeinLocation;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class OreVeinDrawStep
implements ClickableDrawStep {
    private static final ResourceLocation depletedTextureLocation = new ResourceLocation("visualprospecting", "textures/depleted.png");
    private final OreVeinLocation oreVeinLocation;
    private double iconX;
    private double iconY;
    private double iconSize;

    public OreVeinDrawStep(OreVeinLocation oreVeinLocation) {
        this.oreVeinLocation = oreVeinLocation;
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (this.oreVeinLocation.isDepleted()) {
            tooltip.add(this.oreVeinLocation.getDepletedHint());
        }
        if (this.oreVeinLocation.isActiveAsWaypoint()) {
            tooltip.add(this.oreVeinLocation.getActiveWaypointHint());
        }
        tooltip.add(this.oreVeinLocation.getName());
        if (!this.oreVeinLocation.isDepleted()) {
            tooltip.addAll(this.oreVeinLocation.getMaterialNames());
        }
        tooltip.add(this.oreVeinLocation.getToggleDepletedHint());
        return tooltip;
    }

    @Override
    public void drawTooltip(FontRenderer fontRenderer, int mouseX, int mouseY, int displayWidth, int displayHeight) {
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return (double)mouseX >= this.iconX && (double)mouseX <= this.iconX + this.iconSize && (double)mouseY >= this.iconY && (double)mouseY <= this.iconY + this.iconSize;
    }

    @Override
    public void onActionKeyPressed() {
        this.oreVeinLocation.toggleOreVein();
    }

    @Override
    public IWaypointAndLocationProvider getLocationProvider() {
        return this.oreVeinLocation;
    }

    public void draw(double draggedPixelX, double draggedPixelY, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
        this.iconSize = 32.0 * fontScale;
        double iconSizeHalf = this.iconSize / 2.0;
        Point2D.Double blockAsPixel = gridRenderer.getBlockPixelInGrid(this.oreVeinLocation.getBlockX(), this.oreVeinLocation.getBlockZ());
        Point2D.Double pixel = new Point2D.Double(blockAsPixel.getX() + draggedPixelX, blockAsPixel.getY() + draggedPixelY);
        if (gridRenderer.getZoom() >= Config.minZoomLevelForOreLabel && !this.oreVeinLocation.isDepleted()) {
            int fontColor = this.oreVeinLocation.drawSearchHighlight() ? 0xFFFFFF : 0x7F7F7F;
            DrawUtil.drawLabel((String)this.oreVeinLocation.getName(), (double)pixel.getX(), (double)(pixel.getY() - this.iconSize), (DrawUtil.HAlign)DrawUtil.HAlign.Center, (DrawUtil.VAlign)DrawUtil.VAlign.Middle, (Integer)0, (int)180, (Integer)fontColor, (int)255, (double)fontScale, (boolean)false, (double)rotation);
        }
        this.iconX = pixel.getX() - iconSizeHalf;
        this.iconY = pixel.getY() - iconSizeHalf;
        IIcon blockIcon = Blocks.field_150348_b.func_149691_a(0, 0);
        DrawUtils.drawQuad(blockIcon, this.iconX, this.iconY, this.iconSize, this.iconSize, 0xFFFFFF, 255.0f);
        DrawUtils.drawQuad(this.oreVeinLocation.getIconFromPrimaryOre(), this.iconX, this.iconY, this.iconSize, this.iconSize, this.oreVeinLocation.getColor(), 255.0f);
        if (!this.oreVeinLocation.drawSearchHighlight() || this.oreVeinLocation.isDepleted()) {
            DrawUtil.drawRectangle((double)this.iconX, (double)this.iconY, (double)this.iconSize, (double)this.iconSize, (int)0, (int)150);
            if (this.oreVeinLocation.isDepleted()) {
                DrawUtils.drawQuad(depletedTextureLocation, this.iconX, this.iconY, this.iconSize, this.iconSize, 0xFFFFFF, 255.0f);
            }
        }
        if (this.oreVeinLocation.isActiveAsWaypoint()) {
            double thickness = this.iconSize / 8.0;
            int borderAlpha = 204;
            int color = 16766720;
            DrawUtil.drawRectangle((double)(this.iconX - thickness), (double)(this.iconY - thickness), (double)(this.iconSize + thickness), (double)thickness, (int)16766720, (int)204);
            DrawUtil.drawRectangle((double)(this.iconX + this.iconSize), (double)(this.iconY - thickness), (double)thickness, (double)(this.iconSize + thickness), (int)16766720, (int)204);
            DrawUtil.drawRectangle((double)this.iconX, (double)(this.iconY + this.iconSize), (double)(this.iconSize + thickness), (double)thickness, (int)16766720, (int)204);
            DrawUtil.drawRectangle((double)(this.iconX - thickness), (double)this.iconY, (double)thickness, (double)(this.iconSize + thickness), (int)16766720, (int)204);
        }
    }
}

