/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector.types;

import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.detector.DetectorSecured;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.signals.IRouter;
import mods.railcraft.common.blocks.signals.IRoutingTile;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.items.ItemRoutingTable;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class DetectorRouting
extends DetectorSecured
implements IRouter,
IRoutingTile {
    private RoutingLogic logic;
    private final StandaloneInventory inv = new StandaloneInventory(1, null, new StandaloneInventory.Callback(){

        @Override
        public void markDirty() {
            DetectorRouting.this.logic = null;
            DetectorRouting.this.tile.func_70296_d();
        }

        @Override
        public String getInventoryName() {
            return DetectorRouting.this.tile.getName();
        }
    });
    private final MultiButtonController<IRouter.RoutingButtonState> routingController = new MultiButtonController(0, (IMultiButtonState[])IRouter.RoutingButtonState.values());
    private boolean powered;

    @Override
    public MultiButtonController<IRouter.RoutingButtonState> getRoutingController() {
        return this.routingController;
    }

    @Override
    public EnumDetector getType() {
        return EnumDetector.ROUTING;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null && current.func_77973_b() instanceof ItemRoutingTable && this.inv.func_70301_a(0) == null) {
            ItemStack copy = current.func_77946_l();
            copy.field_77994_a = 1;
            this.inv.func_70299_a(0, copy);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                player.field_71071_by.func_70296_d();
            }
            return true;
        }
        this.openGui(EnumGui.DETECTOR_ROUTING, player);
        return true;
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        InvTools.dropInventory(this.inv, this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
    }

    @Override
    protected boolean shouldTest() {
        this.refreshLogic();
        return this.logic != null && this.logic.isValid();
    }

    @Override
    public int testCarts(List<EntityMinecart> carts) {
        if (this.logic == null || !this.logic.isValid()) {
            return 0;
        }
        for (EntityMinecart cart : carts) {
            if (this.routingController.getButtonState() == IRouter.RoutingButtonState.PRIVATE && !this.getOwner().equals((Object)CartTools.getCartOwner(cart)) || !this.logic.matches(this, cart)) continue;
            return 15;
        }
        return 0;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.checkPower();
    }

    private void checkPower() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side == this.tile.direction || !PowerPlugin.isBlockBeingPowered(this.getWorld(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, side)) continue;
            this.powered = true;
            return;
        }
        this.powered = false;
    }

    @Override
    public RoutingLogic getLogic() {
        this.refreshLogic();
        return this.logic;
    }

    @Override
    public void resetLogic() {
        this.logic = null;
    }

    private void refreshLogic() {
        if (this.logic == null && this.inv.func_70301_a(0) != null) {
            this.logic = ItemRoutingTable.getLogic(this.inv.func_70301_a(0));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.inv.writeToNBT("inv", data);
        this.routingController.writeToNBT(data, "railwayType");
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inv.readFromNBT("inv", data);
        this.routingController.readFromNBT(data, "railwayType");
    }

    @Override
    public IInventory getInventory() {
        return this.inv;
    }
}

