/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketKeyPress
extends RailcraftPacket {
    private EntityPlayerMP player;
    private EnumKeyBinding binding;

    public PacketKeyPress(EntityPlayerMP player) {
        this.player = player;
    }

    public PacketKeyPress(EnumKeyBinding binding) {
        this.binding = binding;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeByte(this.binding.ordinal());
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        block7: {
            Train train;
            block10: {
                EntityPlayerMP entityPlayer;
                block9: {
                    block8: {
                        byte type = data.readByte();
                        this.binding = EnumKeyBinding.VALUES[type];
                        entityPlayer = this.player;
                        if (entityPlayer == null) {
                            return;
                        }
                        if (!(entityPlayer.field_70154_o instanceof EntityMinecart)) {
                            return;
                        }
                        train = Train.getTrain((EntityMinecart)entityPlayer.field_70154_o);
                        if (this.binding != EnumKeyBinding.LOCOMOTIVE_INCREASE_SPEED) break block8;
                        for (EntityMinecart cart : train) {
                            EntityLocomotive loco;
                            if (!(cart instanceof EntityLocomotive) || !(loco = (EntityLocomotive)cart).canControl(entityPlayer.func_146103_bH())) continue;
                            loco.increaseSpeed();
                        }
                        break block7;
                    }
                    if (this.binding != EnumKeyBinding.LOCOMOTIVE_DECREASE_SPEED) break block9;
                    for (EntityMinecart cart : train) {
                        EntityLocomotive loco;
                        if (!(cart instanceof EntityLocomotive) || !(loco = (EntityLocomotive)cart).canControl(entityPlayer.func_146103_bH())) continue;
                        loco.decreaseSpeed();
                    }
                    break block7;
                }
                if (this.binding != EnumKeyBinding.LOCOMOTIVE_MODE_CHANGE) break block10;
                for (EntityMinecart cart : train) {
                    EntityLocomotive loco;
                    if (!(cart instanceof EntityLocomotive) || !(loco = (EntityLocomotive)cart).canControl(entityPlayer.func_146103_bH())) continue;
                    EntityLocomotive.LocoMode mode = loco.getMode();
                    if (mode == EntityLocomotive.LocoMode.RUNNING) {
                        loco.setMode(EntityLocomotive.LocoMode.IDLE);
                        continue;
                    }
                    loco.setMode(EntityLocomotive.LocoMode.RUNNING);
                }
                break block7;
            }
            if (this.binding != EnumKeyBinding.LOCOMOTIVE_WHISTLE) break block7;
            for (EntityMinecart cart : train) {
                if (!(cart instanceof EntityLocomotive)) continue;
                EntityLocomotive loco = (EntityLocomotive)cart;
                loco.whistle();
                break;
            }
        }
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.KEY_PRESS.ordinal();
    }

    public static enum EnumKeyBinding {
        LOCOMOTIVE_INCREASE_SPEED,
        LOCOMOTIVE_DECREASE_SPEED,
        LOCOMOTIVE_MODE_CHANGE,
        LOCOMOTIVE_WHISTLE;

        public static final EnumKeyBinding[] VALUES;

        static {
            VALUES = EnumKeyBinding.values();
        }
    }
}

