/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class AEInterfaceInventoryHandler
extends SpecialInventoryHandler {
    private final ITileStorageMonitorable tile;
    private final boolean hideOnePerStack;
    private final MachineSource source;
    private final ForgeDirection dir;
    public boolean init = false;
    ArrayList<Map.Entry<ItemIdentifier, Integer>> cached;

    private AEInterfaceInventoryHandler(TileEntity tile, ForgeDirection dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        if (dir.equals((Object)ForgeDirection.UNKNOWN)) {
            throw new IllegalArgumentException("The direction must not be unknown");
        }
        this.tile = (ITileStorageMonitorable)tile;
        this.hideOnePerStack = hideOnePerStack || hideOne;
        this.source = new MachineSource((IActionHost)new LPActionHost(((IGridHost)tile).getGridNode(dir)));
        this.dir = dir;
    }

    public AEInterfaceInventoryHandler() {
        this.tile = null;
        this.hideOnePerStack = false;
        this.source = null;
        this.dir = ForgeDirection.UNKNOWN;
    }

    @Override
    public boolean init() {
        this.init = true;
        return true;
    }

    @Override
    public boolean isType(TileEntity tile) {
        return tile instanceof ITileStorageMonitorable && tile instanceof IGridHost;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, ForgeDirection dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new AEInterfaceInventoryHandler(tile, dir, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        return this.getItemsAndCount(false);
    }

    private Map<ItemIdentifier, Integer> getItemsAndCount(boolean linked) {
        HashMap result = linked ? new LinkedHashMap() : new HashMap();
        IStorageMonitorable tmp = this.tile.getMonitorable(this.dir, (BaseActionSource)this.source);
        if (tmp == null || tmp.getItemInventory() == null || tmp.getItemInventory().getStorageList() == null) {
            return result;
        }
        for (IAEItemStack items : tmp.getItemInventory().getStorageList()) {
            ItemIdentifier ident = ItemIdentifier.get(items.getItemStack());
            Integer count = (Integer)result.get(ident);
            if (count != null) {
                result.put((ItemIdentifier)ident, (int)((long)count.intValue() + items.getStackSize() - (long)(this.hideOnePerStack ? 1 : 0)));
                continue;
            }
            result.put((ItemIdentifier)ident, (int)(items.getStackSize() - (long)(this.hideOnePerStack ? 1 : 0)));
        }
        return result;
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        IStorageMonitorable tmp = this.tile.getMonitorable(this.dir, (BaseActionSource)this.source);
        if (tmp == null || tmp.getItemInventory() == null || tmp.getItemInventory().getStorageList() == null) {
            return result;
        }
        for (IAEItemStack items : tmp.getItemInventory().getStorageList()) {
            ItemIdentifier ident = ItemIdentifier.get(items.getItemStack());
            result.add(ident);
        }
        return result;
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier item) {
        IStorageMonitorable tmp = this.tile.getMonitorable(this.dir, (BaseActionSource)this.source);
        if (tmp == null || tmp.getItemInventory() == null) {
            return null;
        }
        IAEItemStack stack = AEApi.instance().storage().createItemStack(item.makeNormalStack(1));
        IAEItemStack extract = (IAEItemStack)tmp.getItemInventory().extractItems((IAEStack)stack, Actionable.MODULATE, (BaseActionSource)this.source);
        if (extract == null) {
            return null;
        }
        return extract.getItemStack();
    }

    @Override
    public ItemStack getMultipleItems(ItemIdentifier item, int count) {
        IStorageMonitorable tmp = this.tile.getMonitorable(this.dir, (BaseActionSource)this.source);
        if (tmp == null || tmp.getItemInventory() == null) {
            return null;
        }
        IAEItemStack stack = AEApi.instance().storage().createItemStack(item.makeNormalStack(count));
        IAEItemStack extract = (IAEItemStack)tmp.getItemInventory().extractItems((IAEStack)stack, Actionable.MODULATE, (BaseActionSource)this.source);
        if (extract == null) {
            return null;
        }
        return extract.getItemStack();
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier item) {
        IStorageMonitorable tmp = this.tile.getMonitorable(this.dir, (BaseActionSource)this.source);
        if (tmp == null || tmp.getItemInventory() == null || tmp.getItemInventory().getStorageList() == null) {
            return false;
        }
        for (IAEItemStack items : tmp.getItemInventory().getStorageList()) {
            ItemIdentifier ident = ItemIdentifier.get(items.getItemStack());
            if (ident == null || !ident.equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, item.getMaxStackSize());
    }

    @Override
    public int roomForItem(ItemIdentifier item, int count) {
        IStorageMonitorable tmp = this.tile.getMonitorable(this.dir, (BaseActionSource)this.source);
        if (tmp == null || tmp.getItemInventory() == null) {
            return 0;
        }
        while (count > 0) {
            IAEItemStack stack = AEApi.instance().storage().createItemStack(item.makeNormalStack(count));
            if (tmp.getItemInventory().canAccept((IAEStack)stack)) {
                return count;
            }
            --count;
        }
        return 0;
    }

    @Override
    public ItemStack add(ItemStack stack, ForgeDirection from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        IAEItemStack tst = AEApi.instance().storage().createItemStack(stack);
        IStorageMonitorable tmp = this.tile.getMonitorable(this.dir, (BaseActionSource)this.source);
        if (tmp == null || tmp.getItemInventory() == null) {
            return st;
        }
        IAEItemStack overflow = (IAEItemStack)tmp.getItemInventory().injectItems((IAEStack)tst, Actionable.MODULATE, (BaseActionSource)this.source);
        if (overflow != null) {
            st.field_77994_a = (int)((long)st.field_77994_a - overflow.getStackSize());
        }
        return st;
    }

    @Override
    public boolean isSpecialInventory() {
        return true;
    }

    @Override
    public int getSizeInventory() {
        if (this.cached == null) {
            this.initCache();
        }
        return this.cached.size();
    }

    public void initCache() {
        Map<ItemIdentifier, Integer> map = this.getItemsAndCount(true);
        this.cached = new ArrayList();
        this.cached.addAll(map.entrySet());
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        Map.Entry<ItemIdentifier, Integer> entry;
        if (this.cached == null) {
            this.initCache();
        }
        if ((entry = this.cached.get(i)).getValue() == 0) {
            return null;
        }
        return entry.getKey().makeNormalStack(entry.getValue());
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.cached == null) {
            this.initCache();
        }
        Map.Entry<ItemIdentifier, Integer> entry = this.cached.get(i);
        ItemStack extracted = this.getMultipleItems(entry.getKey(), j);
        entry.setValue(entry.getValue() - j);
        return extracted;
    }

    private static class LPActionHost
    implements IActionHost {
        public IGridNode node;

        public LPActionHost(IGridNode node) {
            this.node = node;
        }

        public void securityBreak() {
        }

        public IGridNode getGridNode(ForgeDirection paramForgeDirection) {
            return null;
        }

        public AECableType getCableConnectionType(ForgeDirection paramForgeDirection) {
            return null;
        }

        public IGridNode getActionableNode() {
            return this.node;
        }
    }
}

