/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.impl;

public class LockObject {
    boolean unlocked = false;
    Thread lockThread;

    public synchronized void unlock() {
        this.unlocked = true;
        this.notifyAll();
    }

    public synchronized void lock() {
        this.unlocked = false;
        this.lockThread = Thread.currentThread();
    }

    public synchronized void waitForUnlock(Runnable then) throws InterruptedException {
        if (this.unlocked) {
            then.run();
            return;
        }
        if (Thread.currentThread().equals(this.lockThread)) {
            throw new UnsupportedOperationException("Attempted to wait on thread that's locking.");
        }
        while (!this.unlocked) {
            this.wait();
        }
        then.run();
    }
}

