/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.migration;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.HashMapBuilder;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.google.gson.JsonElement;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.migration.DataMigrator;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;

public class Legacy2Modern
implements DataMigrator {
    private final File configFile;
    private final String encoding;
    private final Properties properties = new Properties();
    private final Predicate<String> IS_TEXT = id -> id.equalsIgnoreCase("text");
    private final Predicate<String> IS_ICON = id -> id.equalsIgnoreCase("icon");
    private final Predicate<String> IS_DIM_MODULE = e -> e.equals("dimensionMessages");
    private final Predicate<String> IS_BIOME_MODULE = e -> e.equals("biomeMessages");
    private final Predicate<String> IS_SERVER_MODULE = e -> e.equals("serverMessages");
    private final Predicate<String> IS_SCREEN_MODULE = e -> e.equals("guiMessages");
    private final Predicate<String> IS_ITEM_MODULE = e -> e.equals("itemMessages");
    private final Predicate<String> IS_ENTITY_TARGET_MODULE = e -> e.equals("entityTargetMessages");
    private final Predicate<String> IS_ENTITY_RIDING_MODULE = e -> e.equals("entityRidingMessages");
    private final List<Tuple<Pair<String, String>, Predicate<String>, Predicate<String>>> placeholderMappings = Arrays.asList(this.generatePair("&DEFAULT&", "{general.icon}", this.IS_ICON), this.generatePair("&MAINMENU&", "{menu.message}", this.IS_TEXT), this.generatePair("&MAINMENU&", "{menu.icon}", this.IS_ICON), this.generatePair("&BRAND&", "{general.brand}", this.IS_TEXT), this.generatePair("&MCVERSION&", "{general.title}", this.IS_TEXT), this.generatePair("&IGN&", "{custom.player_info_out}", this.IS_TEXT), this.generatePair("&IGN&", "{player.icon}", this.IS_ICON), this.generatePair("&IGN:NAME&", "{player.name}", this.IS_TEXT), this.generatePair("&NAME&", "{player.name}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerOuterInfoPlaceholder")), this.generatePair("&IGN:UUID&", "{player.uuid.short}", this.IS_TEXT), this.generatePair("&UUID&", "{player.uuid.short}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerOuterInfoPlaceholder")), this.generatePair("&IGN:UUID_FULL&", "{player.uuid.full}", this.IS_TEXT), this.generatePair("&UUID_FULL&", "{player.uuid.full}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerOuterInfoPlaceholder")), this.generatePair("&MODS&", "{custom.mods}", this.IS_TEXT), this.generatePair("&MODS:MODCOUNT&", "{general.mods}", this.IS_TEXT), this.generatePair("&MODCOUNT&", "{general.mods}", this.IS_TEXT, e -> e.equalsIgnoreCase("modsPlaceholder")), this.generatePair("&PACK&", "{custom.pack}", this.IS_TEXT), this.generatePair("&PACK&", "{pack.icon}", this.IS_ICON), this.generatePair("&PACK:NAME&", "{pack.name}", this.IS_TEXT), this.generatePair("&NAME&", "{pack.name}", this.IS_TEXT, e -> e.equalsIgnoreCase("modpackMessage")), this.generatePair("&DIMENSION:DIMENSION&", "{dimension.name}", this.IS_TEXT), this.generatePair("&DIMENSION&", "{dimension.name}", this.IS_TEXT, this.IS_DIM_MODULE), this.generatePair("&DIMENSION&", "{dimension.message}", this.IS_TEXT), this.generatePair("&DIMENSION:ICON&", "{dimension.icon}", this.IS_ICON), this.generatePair("&ICON&", "{dimension.icon}", this.IS_ICON, this.IS_DIM_MODULE), this.generatePair("&DIMENSION&", "{dimension.icon}", this.IS_ICON), this.generatePair("&BIOME:BIOME&", "{biome.name}", this.IS_TEXT), this.generatePair("&BIOME&", "{biome.name}", this.IS_TEXT, this.IS_BIOME_MODULE), this.generatePair("&BIOME&", "{biome.message}", this.IS_TEXT), this.generatePair("&BIOME:ICON&", "{biome.icon}", this.IS_ICON), this.generatePair("&ICON&", "{biome.icon}", this.IS_ICON, this.IS_BIOME_MODULE), this.generatePair("&BIOME&", "{biome.icon}", this.IS_ICON), this.generatePair("&SERVER:IP&", "{server.address.short}", this.IS_TEXT), this.generatePair("&IP&", "{server.address.short}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER:NAME&", "{server.name}", this.IS_TEXT), this.generatePair("&NAME&", "{server.name}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER:MOTD&", "{server.motd.raw}", this.IS_TEXT), this.generatePair("&MOTD&", "{server.motd.raw}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER&", "{server.message}", this.IS_TEXT), this.generatePair("&SERVER:ICON&", "{server.icon}", this.IS_ICON), this.generatePair("&ICON&", "{server.icon}", this.IS_ICON, this.IS_SERVER_MODULE), this.generatePair("&SERVER&", "{server.icon}", this.IS_ICON), this.generatePair("&SERVER:PLAYERS&", "{custom.players}", this.IS_TEXT), this.generatePair("&PLAYERS&", "{custom.players}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER:WORLDINFO&", "{custom.world_info}", this.IS_TEXT), this.generatePair("&WORLDINFO&", "{custom.world_info}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER:PLAYERINFO&", "{custom.player_info_in}", this.IS_TEXT), this.generatePair("&PLAYERINFO&", "{custom.player_info_in}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&SERVER:PLAYERINFO:COORDS&", "{custom.player_info_coordinate}", this.IS_TEXT), this.generatePair("&PLAYERINFO:COORDS&", "{custom.player_info_coordinate}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&COORDS&", "{custom.player_info_coordinate}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerInnerInfoPlaceholder")), this.generatePair("&SERVER:PLAYERINFO:HEALTH&", "{custom.player_info_health}", this.IS_TEXT), this.generatePair("&PLAYERINFO:HEALTH&", "{custom.player_info_health}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&HEALTH&", "{custom.player_info_health}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerInnerInfoPlaceholder")), this.generatePair("&SERVER:PLAYERINFO:COORDS:xPosition&", "{player.position.x}", this.IS_TEXT), this.generatePair("&PLAYERINFO:COORDS:xPosition&", "{player.position.x}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&COORDS:xPosition&", "{player.position.x}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerInnerInfoPlaceholder")), this.generatePair("&xPosition&", "{player.position.x}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerCoordinatePlaceholder")), this.generatePair("&SERVER:PLAYERINFO:COORDS:yPosition&", "{player.position.y}", this.IS_TEXT), this.generatePair("&PLAYERINFO:COORDS:yPosition&", "{player.position.y}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&COORDS:yPosition&", "{player.position.y}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerInnerInfoPlaceholder")), this.generatePair("&yPosition&", "{player.position.y}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerCoordinatePlaceholder")), this.generatePair("&SERVER:PLAYERINFO:COORDS:zPosition&", "{player.position.z}", this.IS_TEXT), this.generatePair("&PLAYERINFO:COORDS:zPosition&", "{player.position.z}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&COORDS:zPosition&", "{player.position.z}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerInnerInfoPlaceholder")), this.generatePair("&zPosition&", "{player.position.z}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerCoordinatePlaceholder")), this.generatePair("&SERVER:PLAYERINFO:HEALTH:CURRENT&", "{player.health.current}", this.IS_TEXT), this.generatePair("&PLAYERINFO:HEALTH:CURRENT&", "{player.health.current}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&HEALTH:CURRENT&", "{player.health.current}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerInnerInfoPlaceholder")), this.generatePair("&CURRENT&", "{player.health.current}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerHealthPlaceholder")), this.generatePair("&SERVER:PLAYERINFO:HEALTH:MAX&", "{player.health.max}", this.IS_TEXT), this.generatePair("&PLAYERINFO:HEALTH:MAX&", "{player.health.max}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&HEALTH:MAX&", "{player.health.max}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerInnerInfoPlaceholder")), this.generatePair("&MAX&", "{player.health.max}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerHealthPlaceholder")), this.generatePair("&SERVER:PLAYERS:CURRENT&", "{server.players.current}", this.IS_TEXT), this.generatePair("&PLAYERS:CURRENT&", "{server.players.current}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&CURRENT&", "{server.players.current}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerListPlaceholder")), this.generatePair("&SERVER:PLAYERS:MAX&", "{server.players.max}", this.IS_TEXT), this.generatePair("&PLAYERS:MAX&", "{server.players.max}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&MAX&", "{server.players.max}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerListPlaceholder")), this.generatePair("&SERVER:WORLDINFO:DIFFICULTY&", "{world.difficulty}", this.IS_TEXT), this.generatePair("&WORLDINFO:DIFFICULTY&", "{world.difficulty}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&DIFFICULTY&", "{world.difficulty}", this.IS_TEXT, e -> e.equalsIgnoreCase("worldDataPlaceholder")), this.generatePair("&SERVER:WORLDINFO:WORLDNAME&", "{world.name}", this.IS_TEXT), this.generatePair("&WORLDINFO:WORLDNAME&", "{world.name}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&WORLDNAME&", "{world.name}", this.IS_TEXT, e -> e.equalsIgnoreCase("worldDataPlaceholder")), this.generatePair("&SERVER:WORLDINFO:WORLDTIME&", "{world.time.format_24}", this.IS_TEXT), this.generatePair("&WORLDINFO:WORLDTIME&", "{world.time.format_24}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&WORLDTIME&", "{world.time.format_24}", this.IS_TEXT, e -> e.equalsIgnoreCase("worldDataPlaceholder")), this.generatePair("&SERVER:WORLDINFO:WORLDTIME12&", "{world.time.format_12}", this.IS_TEXT), this.generatePair("&WORLDINFO:WORLDTIME12&", "{world.time.format_12}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&WORLDTIME12&", "{world.time.format_12}", this.IS_TEXT, e -> e.equalsIgnoreCase("worldDataPlaceholder")), this.generatePair("&SERVER:WORLDINFO:WORLDDAY&", "{world.time.day}", this.IS_TEXT), this.generatePair("&WORLDINFO:WORLDDAY&", "{world.time.day}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&WORLDDAY&", "{world.time.day}", this.IS_TEXT, e -> e.equalsIgnoreCase("worldDataPlaceholder")), this.generatePair("&SCREEN:SCREEN&", "{screen.name}", this.IS_TEXT), this.generatePair("&SCREEN&", "{screen.name}", this.IS_TEXT, this.IS_SCREEN_MODULE), this.generatePair("&SCREEN&", "{screen.message}", this.IS_TEXT), this.generatePair("&SCREEN:ICON&", "{screen.icon}", this.IS_ICON), this.generatePair("&ICON&", "{screen.icon}", this.IS_ICON, this.IS_SCREEN_MODULE), this.generatePair("&SCREEN&", "{screen.icon}", this.IS_ICON), this.generatePair("&SCREEN:CLASS&", "{getClass(data.screen.instance)}", this.IS_TEXT), this.generatePair("&CLASS&", "{getClass(data.screen.instance)}", this.IS_TEXT, this.IS_SERVER_MODULE), this.generatePair("&TARGETENTITY:ENTITY&", "{entity.target.name}", this.IS_TEXT), this.generatePair("&ENTITY&", "{entity.target.name}", this.IS_TEXT, this.IS_ENTITY_TARGET_MODULE), this.generatePair("&TARGETENTITY&", "{entity.target.message}", this.IS_TEXT), this.generatePair("&TARGETENTITY:ICON&", "{entity.target.icon}", this.IS_ICON), this.generatePair("&ICON&", "{entity.target.icon}", this.IS_ICON, this.IS_ENTITY_TARGET_MODULE), this.generatePair("&TARGETENTITY&", "{entity.target.icon}", this.IS_ICON), this.generatePair("&RIDINGENTITY:ENTITY&", "{entity.riding.name}", this.IS_TEXT), this.generatePair("&ENTITY&", "{entity.riding.name}", this.IS_TEXT, this.IS_ENTITY_RIDING_MODULE), this.generatePair("&RIDINGENTITY&", "{entity.riding.message}", this.IS_TEXT), this.generatePair("&RIDINGENTITY:ICON&", "{entity.riding.icon}", this.IS_ICON), this.generatePair("&ICON&", "{entity.riding.icon}", this.IS_ICON, this.IS_ENTITY_RIDING_MODULE), this.generatePair("&RIDINGENTITY&", "{entity.riding.icon}", this.IS_ICON), this.generatePair("&TILEENTITY:MAIN&", "{item.main_hand.message}", this.IS_TEXT), this.generatePair("&MAIN&", "{item.main_hand.message}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerItemsPlaceholder")), this.generatePair("&TILEENTITY:OFFHAND&", "{item.off_hand.message}", this.IS_TEXT), this.generatePair("&OFFHAND&", "{item.off_hand.message}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerItemsPlaceholder")), this.generatePair("&TILEENTITY:HELMET&", "{item.helmet.message}", this.IS_TEXT), this.generatePair("&HELMET&", "{item.helmet.message}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerItemsPlaceholder")), this.generatePair("&TILEENTITY:CHEST&", "{item.chestplate.message}", this.IS_TEXT), this.generatePair("&CHEST&", "{item.chestplate.message}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerItemsPlaceholder")), this.generatePair("&TILEENTITY:CHEST&", "{item.chestplate.message}", this.IS_TEXT), this.generatePair("&CHEST&", "{item.chestplate.message}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerItemsPlaceholder")), this.generatePair("&TILEENTITY:LEGS&", "{item.leggings.message}", this.IS_TEXT), this.generatePair("&LEGS&", "{item.leggings.message}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerItemsPlaceholder")), this.generatePair("&TILEENTITY:BOOTS&", "{item.boots.message}", this.IS_TEXT), this.generatePair("&BOOTS&", "{item.boots.message}", this.IS_TEXT, e -> e.equalsIgnoreCase("playerItemsPlaceholder")), this.generatePair("&TILEENTITY&", "{item.message.default}", this.IS_TEXT), this.generatePair("&ITEM&", "{item.message.holding}", this.IS_TEXT, this.IS_ITEM_MODULE));
    private final Map<String, String> configNameMappings = new HashMapBuilder<String, String>().put("lastMcVersionId", "_lastMCVersionId").put("detectCurseManifest", "generalSettings.detectCurseManifest").put("detectMultimcInstance", "generalSettings.detectMultiMCManifest").put("detectMcupdaterInstance", "generalSettings.detectMCUpdaterInstance").put("detectTechnicPack", "generalSettings.detectTechnicPack").put("detectBiomeData", "generalSettings.detectBiomeData").put("detectDimensionData", "generalSettings.detectDimensionData").put("detectWorldData", "generalSettings.detectWorldData").put("clientId", "generalSettings.clientId").put("defaultIcon", "generalSettings.defaultIcon").put("enableJoinRequests", "generalSettings.enableJoinRequests").put("partyPrivacy", "generalSettings.partyPrivacyLevel").put("preferredClient", "generalSettings.preferredClientLevel").put("resetTimeOnInit", "generalSettings.resetTimeOnInit").put("autoRegister", "generalSettings.autoRegister").put("defaultBiomeIcon", "biomeSettings.fallbackBiomeIcon").put("biomeMessages", "biomeSettings.biomeData").put("defaultDimensionIcon", "dimensionSettings.fallbackDimensionIcon").put("dimensionMessages", "dimensionSettings.dimensionData").put("defaultServerIcon", "serverSettings.fallbackServerIcon").put("defaultServerName", "serverSettings.fallbackServerName").put("defaultServerMotd", "serverSettings.fallbackServerMotd").put("serverMessages", "serverSettings.serverData").put("mainMenuMessage", "statusMessages.mainMenuData.textOverride").put("loadingMessage", "statusMessages.loadingData.textOverride").put("lanGameMessage", "statusMessages.lanData.textOverride").put("singleplayerGameMessage", "statusMessages.singleplayerData.textOverride").put("modpackMessage", "displaySettings.dynamicVariables.pack").put("playerOuterInfoPlaceholder", "displaySettings.dynamicVariables.player_info_out").put("playerInnerInfoPlaceholder", "displaySettings.dynamicVariables.player_info_in").put("playerCoordinatePlaceholder", "displaySettings.dynamicVariables.player_info_coordinate").put("playerHealthPlaceholder", "displaySettings.dynamicVariables.player_info_health").put("playerListPlaceholder", "displaySettings.dynamicVariables.players").put("playerItemsPlaceholder", "displaySettings.dynamicVariables.player_info_items").put("worldDataPlaceholder", "displaySettings.dynamicVariables.world_info").put("modsPlaceholder", "displaySettings.dynamicVariables.mods").put("enablePerGuiSystem", "advancedSettings.enablePerGui").put("enablePerItemSystem", "advancedSettings.enablePerItem").put("enablePerEntitySystem", "advancedSettings.enablePerEntity").put("formatWords", "advancedSettings.formatWords").put("debugMode", "advancedSettings.debugMode").put("verboseMode", "advancedSettings.verboseMode").put("refreshRate", "advancedSettings.refreshRate").put("allowPlaceholderPreviews", "advancedSettings.allowPlaceholderPreviews").put("allowPlaceholderOperators", "advancedSettings.allowPlaceholderOperators").put("guiMessages", "advancedSettings.guiSettings.guiData").put("itemMessages", "advancedSettings.itemMessages").put("entityTargetMessages", "advancedSettings.entitySettings.targetData").put("entityRidingMessages", "advancedSettings.entitySettings.ridingData").put("playerSkinEndpoint", "advancedSettings.playerSkinEndpoint").put("languageId", "accessibilitySettings.languageId").put("stripTranslationColors", "accessibilitySettings.stripTranslationColors").put("stripExtraGuiElements", "accessibilitySettings.stripExtraGuiElements").put("renderTooltips", "accessibilitySettings.renderTooltips").put("configGuiKeybind", "accessibilitySettings.configKeyCode").put("gameStateMessageFormat", "displaySettings.presenceData.gameState").put("detailsMessageFormat", "displaySettings.presenceData.details").put("largeImageTextFormat", "displaySettings.presenceData.largeImageText").put("smallImageTextFormat", "displaySettings.presenceData.smallImageText").put("largeImageKeyFormat", "displaySettings.presenceData.largeImageKey").put("smallImageKeyFormat", "displaySettings.presenceData.smallImageKey").put("extraButtonMessages", "displaySettings.presenceData.buttons").put("dynamicIcons", "displaySettings.dynamicIcons").build();
    private final List<String> excludedOptions = StringUtils.newArrayList("schemaVersion", "splitCharacter", "guiBackgroundColor", "tooltipBackgroundColor", "tooltipBorderColor");

    public Legacy2Modern(File configFile, String encoding) {
        this.configFile = configFile;
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config apply(Config instance, JsonElement rawJson, Object ... args) {
        String splitCharacter;
        try {
            try (InputStreamReader configReader = new InputStreamReader(Files.newInputStream(this.configFile.toPath(), new OpenOption[0]), Charset.forName(this.encoding));){
                this.properties.load(configReader);
            }
            splitCharacter = this.properties.getProperty("splitCharacter", ";");
        }
        catch (Exception ex) {
            String splitCharacter2;
            try {
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
                Constants.LOG.debugError(ex);
                splitCharacter2 = this.properties.getProperty("splitCharacter", ";");
            }
            catch (Throwable throwable) {
                String splitCharacter3 = this.properties.getProperty("splitCharacter", ";");
                for (String property : this.properties.stringPropertyNames()) {
                    Map<String, Object> currentValue;
                    String originalName = StringUtils.formatToCamel(property);
                    if (this.excludedOptions.contains(originalName)) continue;
                    String newName = this.configNameMappings.getOrDefault(originalName, originalName);
                    Object originalValue = this.properties.get(property);
                    Map<String, Object> newValue = currentValue = instance.getProperty(newName);
                    if (currentValue == null) continue;
                    Class<?> expectedClass = currentValue.getClass();
                    if (expectedClass == Boolean.class && StringUtils.isValidBoolean(originalValue)) {
                        newValue = Boolean.parseBoolean(originalValue.toString());
                    } else if (expectedClass == Integer.class && StringUtils.getValidInteger(originalValue).getFirst().booleanValue()) {
                        Pair<Boolean, Integer> boolData = StringUtils.getValidInteger(originalValue);
                        if (boolData.getFirst().booleanValue()) {
                            newValue = boolData.getSecond();
                        }
                    } else if (currentValue instanceof Map) {
                        String preArrayString;
                        String convertedString = StringUtils.removeMatches(StringUtils.getMatches("\\[([^\\s]+?)\\]", originalValue), null, 1);
                        Map<String, Object> newData = StringUtils.newHashMap((Map)currentValue);
                        Class<?> expectedSecondaryClass = newData.get("default").getClass();
                        String[] oldArray = !StringUtils.isNullOrEmpty(convertedString) && convertedString.startsWith("[") && convertedString.endsWith("]") ? ((preArrayString = convertedString.replaceAll("\\[", "").replaceAll("]", "")).contains(", ") ? preArrayString.split(", ") : (preArrayString.contains(",") ? preArrayString.split(",") : new String[]{preArrayString})) : null;
                        if (oldArray != null) {
                            newData.clear();
                            for (void var39_53 : oldArray) {
                                String[] part;
                                if (StringUtils.isNullOrEmpty((String)var39_53) || StringUtils.isNullOrEmpty((part = var39_53.split(splitCharacter3))[0])) continue;
                                if (expectedSecondaryClass == Pair.class) {
                                    newData.put(part[0], new Pair<String, Object>(part.length >= 2 ? this.process(part[1], originalName, "text") : null, (part.length >= 3 ? this.process(part[2], originalName, "icon") : null)));
                                    continue;
                                }
                                if (expectedSecondaryClass == Tuple.class) {
                                    newData.put(part[0], new Tuple<String, String, Object>(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "text") : null, (part.length >= 4 ? this.process(part[3], originalName, "text") : null)));
                                    continue;
                                }
                                if (expectedSecondaryClass == ModuleData.class) {
                                    newData.put(part[0], new ModuleData(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "icon") : null));
                                    continue;
                                }
                                if (expectedSecondaryClass == Button.class) {
                                    newData.put(part[0], new Button(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "text") : null));
                                    continue;
                                }
                                newData.put(part[0], part.length >= 2 ? this.process(part[1], originalName, "text") : null);
                            }
                            newValue = newData;
                        }
                    } else {
                        newValue = this.process(originalValue.toString(), originalName, originalName.contains("ImageKey") ? "icon" : "text");
                    }
                    if (((Object)currentValue).equals(newValue)) continue;
                    Constants.LOG.debugInfo("Migrating modified legacy property " + originalName + " to JSON property " + newName, new Object[0]);
                    instance.setProperty(newName, newValue);
                }
                throw throwable;
            }
            for (String property : this.properties.stringPropertyNames()) {
                Map<String, Object> currentValue;
                String originalName = StringUtils.formatToCamel(property);
                if (this.excludedOptions.contains(originalName)) continue;
                String newName = this.configNameMappings.getOrDefault(originalName, originalName);
                Object originalValue = this.properties.get(property);
                Map<String, Object> newValue = currentValue = instance.getProperty(newName);
                if (currentValue == null) continue;
                Class<?> expectedClass = currentValue.getClass();
                if (expectedClass == Boolean.class && StringUtils.isValidBoolean(originalValue)) {
                    newValue = Boolean.parseBoolean(originalValue.toString());
                } else if (expectedClass == Integer.class && StringUtils.getValidInteger(originalValue).getFirst().booleanValue()) {
                    Pair<Boolean, Integer> boolData = StringUtils.getValidInteger(originalValue);
                    if (boolData.getFirst().booleanValue()) {
                        newValue = boolData.getSecond();
                    }
                } else if (currentValue instanceof Map) {
                    String preArrayString;
                    String convertedString = StringUtils.removeMatches(StringUtils.getMatches("\\[([^\\s]+?)\\]", originalValue), null, 1);
                    Map<String, Object> newData = StringUtils.newHashMap((Map)currentValue);
                    Class<?> expectedSecondaryClass = newData.get("default").getClass();
                    String[] oldArray = !StringUtils.isNullOrEmpty(convertedString) && convertedString.startsWith("[") && convertedString.endsWith("]") ? ((preArrayString = convertedString.replaceAll("\\[", "").replaceAll("]", "")).contains(", ") ? preArrayString.split(", ") : (preArrayString.contains(",") ? preArrayString.split(",") : new String[]{preArrayString})) : null;
                    if (oldArray != null) {
                        newData.clear();
                        for (void var20_40 : oldArray) {
                            String[] part;
                            if (StringUtils.isNullOrEmpty((String)var20_40) || StringUtils.isNullOrEmpty((part = var20_40.split(splitCharacter2))[0])) continue;
                            if (expectedSecondaryClass == Pair.class) {
                                newData.put(part[0], new Pair<String, Object>(part.length >= 2 ? this.process(part[1], originalName, "text") : null, (part.length >= 3 ? this.process(part[2], originalName, "icon") : null)));
                                continue;
                            }
                            if (expectedSecondaryClass == Tuple.class) {
                                newData.put(part[0], new Tuple<String, String, Object>(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "text") : null, (part.length >= 4 ? this.process(part[3], originalName, "text") : null)));
                                continue;
                            }
                            if (expectedSecondaryClass == ModuleData.class) {
                                newData.put(part[0], new ModuleData(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "icon") : null));
                                continue;
                            }
                            if (expectedSecondaryClass == Button.class) {
                                newData.put(part[0], new Button(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "text") : null));
                                continue;
                            }
                            newData.put(part[0], part.length >= 2 ? this.process(part[1], originalName, "text") : null);
                        }
                        newValue = newData;
                    }
                } else {
                    newValue = this.process(originalValue.toString(), originalName, originalName.contains("ImageKey") ? "icon" : "text");
                }
                if (((Object)currentValue).equals(newValue)) continue;
                Constants.LOG.debugInfo("Migrating modified legacy property " + originalName + " to JSON property " + newName, new Object[0]);
                instance.setProperty(newName, newValue);
            }
        }
        for (String property : this.properties.stringPropertyNames()) {
            Map<String, Object> currentValue;
            String originalName = StringUtils.formatToCamel(property);
            if (this.excludedOptions.contains(originalName)) continue;
            String newName = this.configNameMappings.getOrDefault(originalName, originalName);
            Object originalValue = this.properties.get(property);
            Map<String, Object> newValue = currentValue = instance.getProperty(newName);
            if (currentValue == null) continue;
            Class<?> expectedClass = currentValue.getClass();
            if (expectedClass == Boolean.class && StringUtils.isValidBoolean(originalValue)) {
                newValue = Boolean.parseBoolean(originalValue.toString());
            } else if (expectedClass == Integer.class && StringUtils.getValidInteger(originalValue).getFirst().booleanValue()) {
                Pair<Boolean, Integer> boolData = StringUtils.getValidInteger(originalValue);
                if (boolData.getFirst().booleanValue()) {
                    newValue = boolData.getSecond();
                }
            } else if (currentValue instanceof Map) {
                String[] preArrayString;
                String convertedString = StringUtils.removeMatches(StringUtils.getMatches("\\[([^\\s]+?)\\]", originalValue), null, 1);
                Map<String, Object> newData = StringUtils.newHashMap((Map)currentValue);
                Class<?> expectedSecondaryClass = newData.get("default").getClass();
                String[] oldArray = !StringUtils.isNullOrEmpty(convertedString) && convertedString.startsWith("[") && convertedString.endsWith("]") ? ((preArrayString = convertedString.replaceAll("\\[", "").replaceAll("]", "")).contains(", ") ? preArrayString.split(", ") : (preArrayString.contains(",") ? preArrayString.split(",") : new String[]{preArrayString})) : null;
                if (oldArray != null) {
                    newData.clear();
                    preArrayString = oldArray;
                    int n = preArrayString.length;
                    for (int i = 0; i < n; ++i) {
                        String[] part;
                        String string = preArrayString[i];
                        if (StringUtils.isNullOrEmpty(string) || StringUtils.isNullOrEmpty((part = string.split(splitCharacter))[0])) continue;
                        if (expectedSecondaryClass == Pair.class) {
                            newData.put(part[0], new Pair<String, Object>(part.length >= 2 ? this.process(part[1], originalName, "text") : null, (part.length >= 3 ? this.process(part[2], originalName, "icon") : null)));
                            continue;
                        }
                        if (expectedSecondaryClass == Tuple.class) {
                            newData.put(part[0], new Tuple<String, String, Object>(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "text") : null, (part.length >= 4 ? this.process(part[3], originalName, "text") : null)));
                            continue;
                        }
                        if (expectedSecondaryClass == ModuleData.class) {
                            newData.put(part[0], new ModuleData(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "icon") : null));
                            continue;
                        }
                        if (expectedSecondaryClass == Button.class) {
                            newData.put(part[0], new Button(part.length >= 2 ? this.process(part[1], originalName, "text") : null, part.length >= 3 ? this.process(part[2], originalName, "text") : null));
                            continue;
                        }
                        newData.put(part[0], part.length >= 2 ? this.process(part[1], originalName, "text") : null);
                    }
                    newValue = newData;
                }
            } else {
                newValue = this.process(originalValue.toString(), originalName, originalName.contains("ImageKey") ? "icon" : "text");
            }
            if (((Object)currentValue).equals(newValue)) continue;
            Constants.LOG.debugInfo("Migrating modified legacy property " + originalName + " to JSON property " + newName, new Object[0]);
            instance.setProperty(newName, newValue);
        }
        if (!this.configFile.delete()) {
            Constants.LOG.error("Failed to remove: " + this.configFile.getName(), new Object[0]);
        }
        instance._schemaVersion = Config.getSchemaVersion();
        instance.save();
        return instance;
    }

    private String process(String input, String originalName, String argumentType) {
        String result = input;
        for (Tuple<Pair<String, String>, Predicate<String>, Predicate<String>> entry : this.placeholderMappings) {
            Pair<String, String> replacer = entry.getFirst();
            String original = replacer.getFirst();
            String newValue = replacer.getSecond();
            Predicate<String> typeCheck = entry.getSecond();
            Predicate<String> optionCheck = entry.getThird();
            if (!typeCheck.test(argumentType) || !optionCheck.test(originalName) || !result.toLowerCase().contains(original.toLowerCase())) continue;
            Constants.LOG.debugInfo("Replacing statement in property \"%1$s\" (%2$s): \"%3$s\" => \"%4$s\"", originalName, argumentType, original, newValue);
            result = StringUtils.replace(result, original, newValue, false, false, true);
        }
        Pair<String, List<String>> operatorMatches = StringUtils.getMatches("\\{[^{}]*}[|]\\{[^{}]*}", result);
        if (!operatorMatches.getSecond().isEmpty()) {
            for (String match : operatorMatches.getSecond()) {
                String[] split = match.split("\\|");
                split[0] = split[0].replaceAll("[{}]", "");
                split[1] = split[1].replaceAll("[{}]", "");
                String replacement = String.format("{getOrDefault(%1$s, %2$s)}", split[0], split[1]);
                Constants.LOG.debugInfo("Replacing statement in property \"%1$s\" (%2$s): \"%3$s\" => \"%4$s\"", originalName, argumentType, match, replacement);
                result = result.replace(match, replacement);
            }
        }
        return result;
    }

    private Tuple<Pair<String, String>, Predicate<String>, Predicate<String>> generatePair(String original, String name, Predicate<String> typeCheck, Predicate<String> optionCheck) {
        return new Tuple<Pair<String, String>, Predicate<String>, Predicate<String>>(new Pair<String, String>(original, name), typeCheck, optionCheck);
    }

    private Tuple<Pair<String, String>, Predicate<String>, Predicate<String>> generatePair(String original, String name, Predicate<String> typeCheck) {
        return this.generatePair(original, name, typeCheck, e -> true);
    }
}

