/*
 * Decompiled with CFR 0.152.
 */
package remoteio.core.transform;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import remoteio.core.MappingHelper;
import remoteio.core.transform.ITransformer;
import remoteio.core.transform.TransformTessellator;

public class CoreTransformer
implements IClassTransformer {
    public List<ITransformer> transformerList = Lists.newArrayList();

    private void addTransformer(ITransformer transformer) {
        this.transformerList.add(transformer);
        MappingHelper.logger.info("Adding transformer for: " + Arrays.toString(transformer.getClasses()));
    }

    public CoreTransformer() {
        this.addTransformer(new TransformTessellator());
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        for (ITransformer transformer : this.transformerList) {
            for (String string : transformer.getClasses()) {
                if (!transformedName.equals(string)) continue;
                MappingHelper.logger.info("Beginning to transform '" + transformedName + "'");
                return transformer.transform(transformedName, basicClass);
            }
        }
        return basicClass;
    }
}

