/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.client.lib.UtilsFX;

public class InfusionRecipeHandler
extends TemplateRecipeHandler {
    protected ArrayList<AspectList> aspectsAmount = new ArrayList();
    String username;

    public InfusionRecipeHandler() {
        this.username = Minecraft.func_71410_x().field_71439_g.getDisplayName();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(26, -14, 110, 13), this.getOverlayIdentifier(), new Object[0]));
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.type.infusion");
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getOverlayIdentifier() {
        return "infusionCrafting";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                if (o == null || !(o instanceof InfusionRecipe)) continue;
                InfusionRecipe tcRecipe = (InfusionRecipe)o;
                if (tcRecipe.getRecipeInput() != null) {
                    InfusionCachedRecipe recipe = new InfusionCachedRecipe(tcRecipe);
                    if (recipe == null || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.getResearch())) continue;
                    recipe.computeVisuals();
                    this.arecipes.add(recipe);
                    this.aspectsAmount.add(recipe.aspects);
                    continue;
                }
                break;
            }
        } else if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        InfusionRecipe tcRecipe = ThaumcraftApi.getInfusionRecipe((ItemStack)result);
        if (tcRecipe != null && ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.getResearch())) {
            InfusionCachedRecipe recipe = new InfusionCachedRecipe(tcRecipe);
            recipe.computeVisuals();
            recipe.setIngredientPermutation(recipe.ingredients, result);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(recipe.aspects);
        }
    }

    private static boolean constainsItemStack(ItemStack[] array, ItemStack item) {
        if (array == null || item == null) {
            return false;
        }
        for (ItemStack is : array) {
            if (!ItemStack.func_77989_b((ItemStack)is, (ItemStack)item)) continue;
            return true;
        }
        return false;
    }

    private static List<InfusionRecipe> getInfusionRecipeByInput(ItemStack input) {
        ArrayList<InfusionRecipe> list = new ArrayList<InfusionRecipe>();
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            InfusionRecipe tcRecipe;
            if (r == null || !(r instanceof InfusionRecipe) || ((tcRecipe = (InfusionRecipe)r).getRecipeInput() == null || !tcRecipe.getRecipeInput().func_77969_a(input)) && !InfusionRecipeHandler.constainsItemStack(((InfusionRecipe)r).getComponents(), input)) continue;
            list.add((InfusionRecipe)r);
        }
        return list;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<InfusionRecipe> tcRecipeList = InfusionRecipeHandler.getInfusionRecipeByInput(ingredient);
        for (InfusionRecipe tcRecipe : tcRecipeList) {
            if (tcRecipe == null || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.getResearch())) continue;
            InfusionCachedRecipe recipe = new InfusionCachedRecipe(tcRecipe);
            recipe.computeVisuals();
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(recipe.aspects);
        }
    }

    public String getGuiTexture() {
        return null;
    }

    public void drawBackground(int recipe) {
        int x = 34;
        int y = -24;
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)(y + 19), (float)0.0f);
        GL11.glScalef((float)1.75f, (float)1.75f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)3, (int)56, (int)17);
        GL11.glTranslatef((float)0.0f, (float)19.0f, (float)0.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)200, (int)77, (int)60, (int)44);
        GL11.glPopMatrix();
        this.drawAspects(recipe, x - 7, y - 20);
    }

    public void drawForeground(int recipe) {
        this.drawExtras(recipe);
        this.drawInstability(recipe, 27, -145);
    }

    public void drawAspects(int recipe, int x, int y) {
        AspectList aspects = this.aspectsAmount.get(recipe);
        int aspectsPerRow = 9;
        int total = 0;
        int rows = aspects.size() / aspectsPerRow;
        int shift = (5 - aspects.size() % aspectsPerRow) * 10;
        int sx = x + 8;
        int sy = y + 158 - 10 * rows;
        for (Aspect tag : aspects.getAspectsSortedAmount()) {
            int m = 0;
            if (total / aspectsPerRow >= rows && (rows > 1 || aspects.size() < aspectsPerRow)) {
                m = 1;
            }
            int vx = sx + total % aspectsPerRow * 20 + shift * m;
            int vy = sy + total / aspectsPerRow * 20;
            UtilsFX.drawTag((int)vx, (int)vy, (Aspect)tag, (float)aspects.getAmount(tag), (int)0, (double)GuiDraw.gui.getZLevel());
            ++total;
        }
    }

    public void drawInstability(int recipe, int x, int y) {
        InfusionCachedRecipe infusionRecipe = (InfusionCachedRecipe)((Object)this.arecipes.get(recipe));
        int inst = Math.min(5, infusionRecipe.getInstability() / 2);
        String text = StatCollector.func_74838_a((String)("tc.inst." + inst));
        GuiDraw.drawString((String)text, (int)(x + 56 - GuiDraw.fontRenderer.func_78256_a(text) / 2), (int)(y + 194), (int)0xFFFFFF, (boolean)false);
    }

    private class InfusionCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private AspectList aspects;
        private PositionedStack result;
        private List<PositionedStack> ingredients;
        private int instability;

        public InfusionCachedRecipe(InfusionRecipe recipe) {
            super((TemplateRecipeHandler)InfusionRecipeHandler.this);
            this.setIngredients(recipe);
            this.setOutput(recipe);
            this.aspects = recipe.getAspects();
            this.setInstability(recipe.getInstability());
            NEIHelper.addAspectsToIngredients(this.aspects, this.ingredients, 1);
        }

        protected void setInstability(int inst) {
            this.instability = inst;
        }

        protected int getInstability() {
            return this.instability;
        }

        protected void setIngredients(InfusionRecipe recipe) {
            this.ingredients = new ArrayList<PositionedStack>();
            ItemStack stack = NEIHelper.getAssociatedItemStack(recipe.getRecipeInput());
            this.ingredients.add(new PositionedStack((Object)stack, 75, 58));
            int x = 27;
            int y = -35;
            int le = recipe.getComponents().length;
            ArrayList<Point> coords = new ArrayList<Point>();
            float pieSlice = 360 / le;
            float currentRot = -90.0f;
            for (int a = 0; a < le; ++a) {
                int xx = (int)(MathHelper.func_76134_b((float)(currentRot / 180.0f * 3.141593f)) * 40.0f) - 8;
                int yy = (int)(MathHelper.func_76126_a((float)(currentRot / 180.0f * 3.141593f)) * 40.0f) - 8;
                currentRot += pieSlice;
                coords.add(new Point(xx, yy));
            }
            int total = 0;
            int sx = x + 56;
            int sy = y + 102;
            for (ItemStack ingredient : recipe.getComponents()) {
                ingredient = NEIHelper.getAssociatedItemStack(ingredient);
                ingredient.field_77994_a = 1;
                int vx = sx + ((Point)coords.get((int)total)).x;
                int vy = sy + ((Point)coords.get((int)total)).y;
                this.ingredients.add(new PositionedStack((Object)ingredient, vx, vy));
                ++total;
            }
        }

        protected void setOutput(InfusionRecipe recipe) {
            ItemStack res = null;
            if (recipe.getRecipeOutput() instanceof ItemStack) {
                res = NEIHelper.getAssociatedItemStack((ItemStack)recipe.getRecipeOutput());
            } else {
                res = NEIHelper.getAssociatedItemStack(recipe.getRecipeInput()).func_77946_l();
                Object[] obj = (Object[])recipe.getRecipeOutput();
                NBTBase tag = (NBTBase)obj[1];
                res.func_77983_a((String)obj[0], tag);
            }
            this.result = new PositionedStack((Object)res, 75, 1);
        }

        public AspectList getAspectList() {
            return this.aspects;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            return this.ingredients;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return false;
            }
            return super.contains(ingredients, ingredient);
        }
    }
}

