/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.genetics.EnumBeeBooleanModifier;
import binnie.core.genetics.EnumBeeModifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeeModifierLogic {
    private Map<EnumBeeModifier, Float[]> modifiers = new HashMap<EnumBeeModifier, Float[]>();
    private List<EnumBeeBooleanModifier> booleanModifiers = new ArrayList<EnumBeeBooleanModifier>();

    public float getModifier(EnumBeeModifier modifier, float currentModifier) {
        if (modifier == EnumBeeModifier.PRODUCTION) {
            if (!this.modifiers.containsKey((Object)modifier)) {
                return 0.0f;
            }
            Float[] values = this.modifiers.get((Object)modifier);
            float offset = values[0].floatValue();
            float max = values[1].floatValue();
            if (offset < 0.0f) {
                return offset;
            }
            if (currentModifier >= max) {
                return 0.0f;
            }
            return Math.min(offset, max - currentModifier);
        }
        if (!this.modifiers.containsKey((Object)modifier)) {
            return 1.0f;
        }
        Float[] values = this.modifiers.get((Object)modifier);
        float mult = values[0].floatValue();
        float max = values[1].floatValue();
        if (max >= 1.0f) {
            if (max <= currentModifier) {
                return 1.0f;
            }
            return Math.min(max / currentModifier, mult);
        }
        if (max >= currentModifier) {
            return 1.0f;
        }
        return Math.max(max / currentModifier, mult);
    }

    public boolean getModifier(EnumBeeBooleanModifier modifier) {
        return this.booleanModifiers.contains((Object)modifier);
    }

    public void setModifier(EnumBeeBooleanModifier modifier) {
        this.booleanModifiers.add(modifier);
    }

    public void setModifier(EnumBeeModifier modifier, float mult, float max) {
        this.modifiers.put(modifier, new Float[]{Float.valueOf(mult), Float.valueOf(max)});
    }
}

