/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.Mods;
import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.block.DoorType;
import binnie.extratrees.block.IFenceProvider;
import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.block.decor.FenceDescription;
import binnie.extratrees.block.decor.FenceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WoodManager {
    private static List<IPlankType> allPlankTypes;

    public static IPlankType getPlankType(int index) {
        IDesignMaterial wood = CarpentryManager.carpentryInterface.getWoodMaterial(index);
        if (wood instanceof IPlankType) {
            return (IPlankType)wood;
        }
        return PlankType.ExtraTreePlanks.Fir;
    }

    public static int getPlankTypeIndex(IPlankType type) {
        int index = CarpentryManager.carpentryInterface.getCarpentryWoodIndex(type);
        return index < 0 ? 0 : index;
    }

    public static FenceType getFenceType(ItemStack stack) {
        FenceDescription desc = WoodManager.getFenceDescription(stack);
        return desc == null ? null : desc.getFenceType();
    }

    public static FenceDescription getFenceDescription(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)ExtraTrees.blockMultiFence)) {
            int damage = TileEntityMetadata.getItemDamage(stack);
            return WoodManager.getFenceDescription(damage);
        }
        for (IPlankType type : WoodManager.getAllPlankTypes()) {
            ItemStack f;
            if (!(type instanceof IFenceProvider) || (f = ((IFenceProvider)((Object)type)).getFence()) == null || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)f)) continue;
            return new FenceDescription(new FenceType(0), type, type);
        }
        return null;
    }

    public static FenceDescription getFenceDescription(int meta) {
        return new FenceDescription(meta);
    }

    public static FenceType getFenceType(int meta) {
        return WoodManager.getFenceDescription(meta).getFenceType();
    }

    public static ItemStack getGate(IPlankType plank) {
        if (plank == PlankType.VanillaPlanks.OAK) {
            return new ItemStack(Blocks.field_150396_be);
        }
        return TileEntityMetadata.getItemStack(ExtraTrees.blockGate, WoodManager.getPlankTypeIndex(plank));
    }

    public static ItemStack getFence(IPlankType plank, FenceType type, int amount) {
        return WoodManager.getFence(plank, plank, type, amount);
    }

    public static ItemStack getFence(IPlankType plank, IPlankType plank2, FenceType type, int amount) {
        ItemStack original;
        if (plank instanceof IFenceProvider && plank == plank2 && type.isPlain() && (original = ((IFenceProvider)((Object)plank)).getFence()) != null) {
            original.field_77994_a = amount;
            return original;
        }
        int ord = type.ordinal();
        int i = WoodManager.getPlankTypeIndex(plank) + 256 * ord;
        ItemStack stack = TileEntityMetadata.getItemStack((Block)ExtraTrees.blockMultiFence, i + 65536 * WoodManager.getPlankTypeIndex(plank2));
        stack.field_77994_a = amount;
        return stack;
    }

    public static ItemStack getDoor(IPlankType plank, DoorType type) {
        return TileEntityMetadata.getItemStack(ExtraTrees.blockDoor, type.ordinal() * 256 + WoodManager.getPlankTypeIndex(plank));
    }

    public static List<IPlankType> getAllPlankTypes() {
        if (allPlankTypes != null) {
            return allPlankTypes;
        }
        ArrayList<IPlankType> list = new ArrayList<IPlankType>();
        Collections.addAll(list, PlankType.ExtraTreePlanks.values());
        Collections.addAll(list, PlankType.ForestryPlanks.values());
        if (Mods.extraBiomes.active()) {
            Collections.addAll(list, PlankType.ExtraBiomesPlank.values());
        }
        Collections.addAll(list, PlankType.VanillaPlanks.values());
        allPlankTypes = list;
        return list;
    }

    public static IPlankType get(ItemStack species) {
        for (IPlankType type : WoodManager.getAllPlankTypes()) {
            if (type.getStack() == null || !type.getStack().func_77969_a(species)) continue;
            return type;
        }
        return null;
    }
}

