/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ItemStackUtils {
    public static int tryAddItemStacksToInvenotry(IInventory inventory, ItemStack[] items, int startSlot, int slotCount) {
        int itemsAdded = 0;
        for (ItemStack item : items) {
            itemsAdded += ItemStackUtils.addItemToInventory(inventory, item, startSlot, slotCount);
        }
        return itemsAdded;
    }

    public static boolean tryAddAllItemStacksToInventory(IInventory inventory, ItemStack[] items, int startSlot, int slotCount) {
        int itemsToAdd = 0;
        int itemsAdded = 0;
        for (ItemStack item : items) {
            itemsToAdd += item.field_77994_a;
            itemsAdded += ItemStackUtils.addItemToInventory(inventory, item, startSlot, slotCount);
        }
        return itemsToAdd == itemsAdded;
    }

    public static int addItemToInventory(IInventory inventory, ItemStack item, int startSlot, int slotCount) {
        int itemsAdded = 0;
        itemsAdded = ItemStackUtils.addToExistingSlot(inventory, item, startSlot, slotCount);
        if (itemsAdded < item.field_77994_a) {
            item.field_77994_a -= itemsAdded;
            itemsAdded += ItemStackUtils.addToEmptySlot(inventory, item, startSlot, slotCount);
        }
        return itemsAdded;
    }

    private static int addToExistingSlot(IInventory inventory, ItemStack item, int startSlot, int slotCount) {
        int itemsAdded = 0;
        for (int slotIndex = startSlot; slotIndex < startSlot + slotCount; ++slotIndex) {
            ItemStack slotStack = inventory.func_70301_a(slotIndex);
            if (slotStack != null && ItemStackUtils.areItemsEqualNBT(item, slotStack)) {
                int spaceAvailable = slotStack.func_77976_d() - slotStack.field_77994_a;
                if (spaceAvailable > item.field_77994_a) {
                    slotStack.field_77994_a += item.field_77994_a;
                    inventory.func_70299_a(slotIndex, slotStack);
                    itemsAdded += item.field_77994_a;
                    item.field_77994_a = 0;
                } else if (spaceAvailable > 0) {
                    slotStack.field_77994_a = slotStack.func_77976_d();
                    inventory.func_70299_a(slotIndex, slotStack);
                    itemsAdded += spaceAvailable;
                    item.field_77994_a -= spaceAvailable;
                }
            }
            if (item.field_77994_a == 0) break;
        }
        return itemsAdded;
    }

    private static int addToEmptySlot(IInventory inventory, ItemStack item, int startSlot, int slotCount) {
        for (int slotIndex = startSlot; slotIndex < startSlot + slotCount; ++slotIndex) {
            ItemStack slotStack = inventory.func_70301_a(slotIndex);
            if (slotStack != null) continue;
            inventory.func_70299_a(slotIndex, item);
            return item.field_77994_a;
        }
        return 0;
    }

    public static boolean areItemsEqualNBT(ItemStack item, ItemStack otherItem) {
        return item.func_77969_a(otherItem) && ItemStack.func_77970_a((ItemStack)item, (ItemStack)otherItem);
    }
}

