/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.block;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.network.Environment;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.block.BlockMachineSidedIcon;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileCipherBlock;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;

@Optional.InterfaceList(value={@Optional.Interface(iface="powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode", modid="MineFactoryReloaded")})
public class BlockCipher
extends BlockMachineSidedIcon
implements IRedNetOmniNode {
    private IIcon mFront;

    public BlockCipher() {
        super("bundled", "cipher");
        this.func_149663_c("computronics.cipher");
        this.setGuiProvider(Computronics.guiCipher);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileCipherBlock();
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        boolean isLocked = false;
        if (!world.field_72995_K && Config.CIPHER_CAN_LOCK) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile != null) {
                isLocked = ((TileCipherBlock)tile).isLocked();
            }
            if (isLocked) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.computronics.cipher.locked", new Object[0]));
            }
        }
        return isLocked || super.func_149727_a(world, x, y, z, player, par6, par7, par8, par9);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (Mods.isLoaded("ProjRed|Core")) {
            ((TileCipherBlock)tile).onProjectRedBundledInputChanged();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getAbsoluteSideIcon(int sideNumber, int metadata) {
        return sideNumber == 2 ? this.mFront : super.getAbsoluteSideIcon(sideNumber, metadata);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister r) {
        super.func_149651_a(r);
        this.mFront = r.func_94245_a("computronics:cipher_front");
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public void onInputsChanged(World world, int x, int y, int z, ForgeDirection side, int[] inputValues) {
        ((TileCipherBlock)world.func_147438_o(x, y, z)).updateRedNet(inputValues);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public void onInputChanged(World world, int x, int y, int z, ForgeDirection side, int inputValue) {
        ((TileCipherBlock)world.func_147438_o(x, y, z)).updateRedNet(inputValue);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        return RedNetConnectionType.PlateAll;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public int[] getOutputValues(World world, int x, int y, int z, ForgeDirection side) {
        return ((TileCipherBlock)world.func_147438_o((int)x, (int)y, (int)z)).redNetMultiOutput;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public int getOutputValue(World world, int x, int y, int z, ForgeDirection side, int subnet) {
        return ((TileCipherBlock)world.func_147438_o((int)x, (int)y, (int)z)).redNetSingleOutput;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Class<? extends Environment> getTileEntityClass(int meta) {
        return TileCipherBlock.class;
    }
}

