/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import openmods.utils.ITester;
import openmods.utils.ObjectTester;

public class MagnetWhitelists {
    public static final MagnetWhitelists instance = new MagnetWhitelists();
    public final ObjectTester<Entity> entityWhitelist = ObjectTester.create();
    public final ObjectTester<BlockCoords> blockWhitelist = ObjectTester.create();
    public final ObjectTester<TileEntity> tileEntityWhitelist = ObjectTester.create();

    private MagnetWhitelists() {
    }

    public static ITester<BlockCoords> createBlockIdentityTester(final Block template) {
        return new ITester<BlockCoords>(){

            public ITester.Result test(BlockCoords o) {
                return o.block == template ? ITester.Result.ACCEPT : ITester.Result.CONTINUE;
            }
        };
    }

    public static ITester<BlockCoords> createBlockClassTester(final Class<? extends Block> cls) {
        return new ITester<BlockCoords>(){

            public ITester.Result test(BlockCoords o) {
                return cls.isInstance(o.block) ? ITester.Result.ACCEPT : ITester.Result.CONTINUE;
            }
        };
    }

    public void initTesters() {
        this.entityWhitelist.addTester((ITester)new ObjectTester.ClassTester(EntityItem.class));
        this.entityWhitelist.addTester((ITester)new ObjectTester.ClassTester(EntityBoat.class));
        this.entityWhitelist.addTester((ITester)new ObjectTester.ClassTester(EntityMinecart.class));
        MinecraftForge.EVENT_BUS.post((Event)new EntityRegisterEvent(this.entityWhitelist));
        this.blockWhitelist.addTester((ITester)new ITester<BlockCoords>(){

            public ITester.Result test(BlockCoords o) {
                float hardness = o.block.func_149712_f(o.world, o.x, o.y, o.z);
                return hardness < 0.0f ? ITester.Result.REJECT : ITester.Result.CONTINUE;
            }
        });
        this.blockWhitelist.addTester((ITester)new ITester<BlockCoords>(){

            public ITester.Result test(BlockCoords o) {
                return o.block.func_149645_b() == 0 ? ITester.Result.ACCEPT : ITester.Result.CONTINUE;
            }
        });
        this.blockWhitelist.addTester(MagnetWhitelists.createBlockClassTester(BlockSand.class));
        this.blockWhitelist.addTester(MagnetWhitelists.createBlockClassTester(BlockStairs.class));
        this.blockWhitelist.addTester(MagnetWhitelists.createBlockClassTester(BlockFence.class));
        this.blockWhitelist.addTester(MagnetWhitelists.createBlockClassTester(BlockFenceGate.class));
        this.blockWhitelist.addTester(MagnetWhitelists.createBlockIdentityTester(Blocks.field_150434_aF));
        MinecraftForge.EVENT_BUS.post((Event)new BlockRegisterEvent(this.blockWhitelist));
        this.tileEntityWhitelist.addTester((ITester)new ObjectTester.ClassTester(TileEntityBeacon.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityBrewingStand.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityChest.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityCommandBlock.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityDispenser.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityEnchantmentTable.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityEnderChest.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityFurnace.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityHopper.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityNote.class)).addTester((ITester)new ObjectTester.ClassTester(BlockJukebox.TileEntityJukebox.class));
    }

    public boolean testBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (block instanceof BlockContainer) {
            TileEntity te = world.func_147438_o(x, y, z);
            return te != null ? this.tileEntityWhitelist.check((Object)te) : false;
        }
        return this.blockWhitelist.check((Object)new BlockCoords(block, world, x, y, z));
    }

    public static class TileEntityRegisterEvent
    extends WhitelistRegisterEvent<TileEntity> {
        protected TileEntityRegisterEvent(ObjectTester<TileEntity> tester) {
            super(tester);
        }
    }

    public static class BlockRegisterEvent
    extends WhitelistRegisterEvent<BlockCoords> {
        protected BlockRegisterEvent(ObjectTester<BlockCoords> tester) {
            super(tester);
        }
    }

    public static class EntityRegisterEvent
    extends WhitelistRegisterEvent<Entity> {
        protected EntityRegisterEvent(ObjectTester<Entity> tester) {
            super(tester);
        }
    }

    public static class WhitelistRegisterEvent<T>
    extends Event {
        protected final ObjectTester<T> tester;

        protected WhitelistRegisterEvent(ObjectTester<T> tester) {
            this.tester = tester;
        }

        public void addClass(Class<? extends T> cls) {
            this.tester.addTester((ITester)new ObjectTester.ClassTester(cls));
        }

        public void addClassNames(Class<? extends T> ... cls) {
            this.tester.addTester((ITester)new ObjectTester.ClassNameTester().addClasses((Class[])cls));
        }

        public void addClassNames(String ... names) {
            this.tester.addTester((ITester)new ObjectTester.ClassNameTester().addClasses(names));
        }
    }

    public static class BlockCoords {
        public final Block block;
        public final World world;
        public final int x;
        public final int y;
        public final int z;

        public BlockCoords(Block block, World world, int x, int y, int z) {
            this.block = block;
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

