/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.OpenBlocks;
import openmods.item.ItemOpenBlock;
import openmods.utils.ColorUtils;
import openmods.utils.ItemUtils;

public class ItemPaintCan
extends ItemOpenBlock {
    public static final String TAG_AMOUNT = "amount";
    public static final String TAG_COLOR = "color";
    public static final int FULL_CAN_SIZE = 30;

    public ItemPaintCan(Block block) {
        super(block);
        this.func_77656_e(30);
        this.func_77625_d(1);
    }

    public static int getColorFromStack(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null ? tag.func_74762_e(TAG_COLOR) : 0;
    }

    public static int getAmountFromStack(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null ? tag.func_74762_e(TAG_AMOUNT) : 0;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List result) {
        for (ColorUtils.ColorMeta meta : ColorUtils.getAllColors()) {
            result.add(ItemPaintCan.createStack(meta.rgb, 30));
        }
    }

    public static ItemStack createStack(int color, int amount) {
        ItemStack stack = new ItemStack((Block)OpenBlocks.Blocks.paintCan);
        ItemPaintCan.setColorAndAmount(stack, color, amount);
        return stack;
    }

    public static void setColorAndAmount(ItemStack stack, int color, int amount) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74768_a(TAG_COLOR, color);
        tag.func_74768_a(TAG_AMOUNT, amount);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extended) {
        list.add(String.format("#%06X", ItemPaintCan.getColorFromStack(stack)));
    }

    public int getDamage(ItemStack stack) {
        return 30 - ItemPaintCan.getAmountFromStack(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemPaintCan.getAmountFromStack(stack) / 30.0;
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77942_o() && ItemPaintCan.getAmountFromStack(stack) < 30;
    }
}

