/*
 * Decompiled with CFR 0.152.
 */
package vexatos.tgregworks.integration;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Property;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.FluidType;
import vexatos.tgregworks.TGregworks;
import vexatos.tgregworks.integration.recipe.tconstruct.TGregFluidType;
import vexatos.tgregworks.item.ItemTGregPart;
import vexatos.tgregworks.reference.Config;
import vexatos.tgregworks.reference.PartTypes;

public class TGregRegistry {
    private int latestAvailableNumber = 1500;
    private boolean addMaterialsAnyway = false;
    public ArrayList<Materials> toolMaterials = new ArrayList();
    public ArrayList<String> toolMaterialNames = new ArrayList();
    public HashMap<Materials, Integer> matIDs = new HashMap();
    public HashMap<Integer, Materials> materialIDMap = new HashMap();
    public final HashMap<Materials, Property> configProps = new HashMap();
    public final ArrayList<Integer> configIDs = new ArrayList();
    public HashMap<Materials, TGregFluidType> toolMaterialFluidTypes = new HashMap();
    private final HashMap<String, Float> globalMultipliers = new HashMap();
    private List<Materials> stonebound1Mats = Arrays.asList(Materials.Titanium, Materials.Tungsten);
    private List<Materials> spiny1Mats = Arrays.asList(Materials.Uranium, Materials.Uranium235);
    private List<Materials> reinforced1Mats = Arrays.asList(Materials.SteelMagnetic, Materials.BlackSteel, Materials.BlueSteel, Materials.Titanium, Materials.DamascusSteel, Materials.StainlessSteel, Materials.RedSteel, Materials.MeteoricSteel, Materials.TungstenSteel);
    private List<Materials> reinforced2Mats = Arrays.asList(Materials.Osmium, Materials.Iridium);
    public HashMap<PartTypes, ItemTGregPart> toolParts = new HashMap();

    private int getLatestAvailableNumber() {
        for (int i = this.latestAvailableNumber; i < 16383; ++i) {
            if (TConstructRegistry.toolMaterials.containsKey(i) || this.configIDs.contains(i)) continue;
            this.latestAvailableNumber = i + 1;
            return i;
        }
        throw new RuntimeException("TConstruct tool material registry ran out of IDs!");
    }

    public int getMaterialID(Materials m) {
        int configID;
        Property configProp = this.configProps.get(m);
        if (configProp == null) {
            configProp = TGregworks.config.get(Config.onMaterial("material-id"), m.name(), 0, null, 0, 30000);
        }
        if ((configID = configProp.getInt()) > 0) {
            return configID;
        }
        int newID = this.getLatestAvailableNumber();
        configProp.set(newID);
        return newID;
    }

    public TGregRegistry() {
        this.latestAvailableNumber = TGregworks.config.getInt("materialIDRangeStart", "general", 1500, 300, 15000, "The lowest ID for TGregworks materials. Only material IDs higher than this will be used, and only if the ID has not been registered before. Other mods might not check if the material ID is already in use and thus crash, if the crash occurs with a TGregworks material, changing this number may fix it.");
        this.addMaterialsAnyway = TGregworks.config.getBoolean("addMaterialsAnyway", "general", false, "Register Materials even if a material with the same name already exists. May override any material with the same name added by other mods.");
    }

    public void registerToolParts() {
        TGregworks.log.info("Registering TGregworks tool parts.");
        List<Materials> gtMaterials = Arrays.asList(GregTech_API.sGeneratedMaterials);
        for (Materials m : Materials.values()) {
            if ((m.mTypes & 0x40) != 64 || this.doesMaterialExist(m) || !gtMaterials.contains(m) || !TGregworks.config.get("enable", m.name(), true).getBoolean(true)) continue;
            this.toolMaterials.add(m);
            Property configProp = TGregworks.config.get(Config.onMaterial("material-id"), m.name(), 0, null, 0, 100000);
            this.configProps.put(m, configProp);
            this.configIDs.add(configProp.getInt());
        }
        for (Materials m : this.toolMaterials) {
            this.toolMaterialNames.add(m.mDefaultLocalName);
            int matID = this.getMaterialID(m);
            this.addToolMaterial(matID, m);
            this.addBowMaterial(matID, m);
            this.addArrowMaterial(matID, m);
            this.matIDs.put(m, matID);
            this.materialIDMap.put(matID, m);
        }
        this.configProps.clear();
        this.configIDs.clear();
        ItemTGregPart.toolMaterialNames = this.toolMaterialNames;
    }

    public void addToolMaterial(int matID, Materials m) {
        TConstructRegistry.addToolMaterial((int)matID, (String)m.name(), (String)m.mLocalizedName, (int)m.mToolQuality, (int)((int)((float)m.mDurability * this.getGlobalMultiplier("durability") * this.getMultiplier(m, "durability"))), (int)((int)(m.mToolSpeed * 100.0f * this.getGlobalMultiplier("miningspeed") * this.getMultiplier(m, "miningspeed"))), (int)((int)((float)m.mToolQuality * this.getGlobalMultiplier("attack") * this.getMultiplier(m, "attack"))), (float)(((float)TGregRegistry.sanitizeToolQuality(m.mToolQuality) - 0.5f) * this.getGlobalMultiplier("handlemodifier") * this.getMultiplier(m, "handlemodifier")), (int)this.getReinforcedLevel(m), (float)this.getStoneboundLevel(m), (String)"", (int)(m.getRGBA()[0] << 16 | m.getRGBA()[1] << 8 | m.getRGBA()[2]));
    }

    public void addBowMaterial(int matID, Materials m) {
        TConstructRegistry.addBowMaterial((int)matID, (int)((int)((float)TGregRegistry.sanitizeToolQuality(m.mToolQuality) * 10.0f * this.getGlobalMultiplier("bowdrawspeed") * this.getMultiplier(m, "bowdrawspeed"))), (float)(((float)TGregRegistry.sanitizeToolQuality(m.mToolQuality) - 0.5f) * this.getGlobalMultiplier("bowflightspeed") * this.getMultiplier(m, "bowflightspeed")));
    }

    public void addArrowMaterial(int matID, Materials m) {
        TConstructRegistry.addArrowMaterial((int)matID, (float)((float)((double)m.getMass() / 10.0 * (double)this.getGlobalMultiplier("arrowmass") * (double)this.getMultiplier(m, "arrowmass"))), (float)(this.getGlobalMultiplier("arrowfragility", 0.9) * this.getMultiplier(m, "arrowfragility")));
    }

    private static int sanitizeToolQuality(int toolQuality) {
        return Math.max(toolQuality, 1);
    }

    public void registerFluids() {
        for (Materials m : this.toolMaterials) {
            if (m.mStandardMoltenFluid == null) continue;
            TGregFluidType fluidType = new TGregFluidType(m, m.mStandardMoltenFluid.getBlock(), 0, m.mStandardMoltenFluid.getTemperature(), m.mStandardMoltenFluid, true, this.matIDs.get(m));
            this.toolMaterialFluidTypes.put(m, fluidType);
            FluidType.registerFluidType((String)m.mStandardMoltenFluid.getName(), (FluidType)fluidType);
        }
    }

    public float getMultiplier(Materials m, String key) {
        return (float)TGregworks.config.get(Config.onMaterial(key), m.name(), 1.0, null, 0.0, 10000.0).getDouble(1.0);
    }

    public float getGlobalMultiplier(String key) {
        return this.getGlobalMultiplier(key, 1.0);
    }

    public float getGlobalMultiplier(String key, double def) {
        Float multiplier = this.globalMultipliers.get(key);
        if (multiplier == null) {
            multiplier = Float.valueOf((float)TGregworks.config.get("global", key, def, null, 0.0, 10000.0).getDouble(def));
            this.globalMultipliers.put(key, multiplier);
        }
        return multiplier.floatValue();
    }

    public float getStoneboundLevel(Materials m) {
        return TGregworks.config.get("materials.stoneboundlevel", m.name(), this.stonebound1Mats.contains(m) ? 1 : (this.spiny1Mats.contains(m) ? -1 : 0), null, -3, 3).getInt(this.stonebound1Mats.contains(m) ? 1 : (this.spiny1Mats.contains(m) ? -1 : 0));
    }

    public int getReinforcedLevel(Materials m) {
        return TGregworks.config.get("materials.reinforcedlevel", m.name(), this.reinforced1Mats.contains(m) ? 1 : (this.reinforced2Mats.contains(m) ? 2 : (m == Materials.Osmiridium ? 3 : 0)), null, 0, 3).getInt(this.reinforced1Mats.contains(m) ? 1 : (this.reinforced2Mats.contains(m) ? 2 : (m == Materials.Osmiridium ? 3 : 0)));
    }

    private boolean doesMaterialExist(Materials m) {
        return !this.addMaterialsAnyway && TConstructRegistry.toolMaterialStrings.containsKey(m.name());
    }

    public void registerItems() {
        for (PartTypes p : PartTypes.VALUES) {
            ItemTGregPart item = new ItemTGregPart(p);
            this.toolParts.put(p, item);
            GameRegistry.registerItem((Item)item, (String)("tGregToolPart" + item.getType().name()));
        }
    }

    public void registerModifiers() {
    }
}

