/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.google.common.primitives.Ints;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.NumberFormat;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.TextRenderer;
import com.gtnewhorizons.modularui.api.fluids.FluidTankLong;
import com.gtnewhorizons.modularui.api.fluids.FluidTankLongDelegate;
import com.gtnewhorizons.modularui.api.fluids.FluidTanksHandler;
import com.gtnewhorizons.modularui.api.fluids.IFluidTankLong;
import com.gtnewhorizons.modularui.api.fluids.IFluidTanksHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.FluidInteractionUtil;
import com.gtnewhorizons.modularui.api.widget.IDragAndDropHandler;
import com.gtnewhorizons.modularui.api.widget.IHasStackUnderMouse;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.Theme;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularGui;
import com.gtnewhorizons.modularui.common.widget.SyncedWidget;
import gregtech.api.util.GT_Utility;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class FluidSlotWidget
extends SyncedWidget
implements Interactable,
IDragAndDropHandler,
IHasStackUnderMouse,
FluidInteractionUtil {
    public static final Size SIZE = new Size(18, 18);
    private static final int PACKET_REAL_CLICK = 1;
    private static final int PACKET_SCROLL = 2;
    private static final int PACKET_CONTROLS_AMOUNT = 3;
    private static final int PACKET_DRAG_AND_DROP = 4;
    private static final int PACKET_SYNC_FLUID = 5;
    @Nullable
    private IDrawable overlayTexture;
    private final TextRenderer textRenderer = new TextRenderer();
    private final IFluidTanksHandler handler;
    private final int tank;
    @Nullable
    private IFluidTankLong lastStoredFluid;
    private IFluidTankLong lastStoredPhantomFluid;
    private Pos2d contentOffset = new Pos2d(1, 1);
    private boolean alwaysShowFull = true;
    private boolean canDrainSlot = true;
    private boolean canFillSlot = true;
    private boolean phantom = false;
    private boolean controlsAmount = false;
    private boolean lastShift = false;
    private boolean playClickSound = false;
    private Function<Fluid, Boolean> filter = fluid -> true;
    private Consumer<FluidSlotWidget> onClickContainer;
    private Consumer<Widget> onDragAndDropComplete;

    public FluidSlotWidget(IFluidTanksHandler handler, int tank) {
        this.handler = handler;
        this.tank = tank;
        this.textRenderer.setColor(Color.WHITE.normal);
        this.textRenderer.setShadow(true);
    }

    public FluidSlotWidget(IFluidTanksHandler singleSlotHandler) {
        this(singleSlotHandler, 0);
    }

    public FluidSlotWidget(IFluidTank fluidTank) {
        this(new FluidTanksHandler(new FluidTankLongDelegate(fluidTank)));
    }

    public static FluidSlotWidget phantom(IFluidTanksHandler handler, int tank, boolean controlsAmount) {
        FluidSlotWidget slot = new FluidSlotWidget(handler, tank);
        slot.phantom = true;
        slot.controlsAmount = controlsAmount;
        return slot;
    }

    public static FluidSlotWidget phantom(IFluidTank fluidTank, boolean controlsAmount) {
        return FluidSlotWidget.phantom(new FluidTanksHandler(new FluidTankLongDelegate(fluidTank)), 0, controlsAmount);
    }

    public static FluidSlotWidget phantom(int capacity) {
        return FluidSlotWidget.phantom((IFluidTank)new FluidTank(capacity > 0 ? capacity : 1), capacity > 1);
    }

    public FluidStack getContent() {
        return this.handler.getFluidStackInTank(this.tank);
    }

    @Override
    public void onInit() {
        if (this.isClient()) {
            this.textRenderer.setShadow(true);
            this.textRenderer.setScale(0.5f);
        }
        if (this.getBackground() == null) {
            this.setBackground(ModularUITextures.FLUID_SLOT);
        }
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return SIZE;
    }

    public void setPhantom(boolean phantom) {
        this.phantom = phantom;
    }

    public void setControlsAmount(boolean controlsAmount, boolean sync) {
        if (this.controlsAmount != controlsAmount) {
            this.controlsAmount = controlsAmount;
            if (sync) {
                if (this.isClient()) {
                    this.syncToServer(3, buffer -> buffer.writeBoolean(controlsAmount));
                } else {
                    this.syncToClient(3, buffer -> buffer.writeBoolean(controlsAmount));
                }
            }
        }
    }

    @Override
    public void buildTooltip(List<Text> tooltip) {
        super.buildTooltip(tooltip);
        FluidStack fluid = this.handler.getFluidStackInTank(this.tank);
        if (this.phantom) {
            if (fluid != null) {
                this.addFluidNameInfo(tooltip, fluid);
                if (this.controlsAmount) {
                    tooltip.add(Text.localised("modularui.fluid.phantom.amount", this.handler.getTankStoredAmount(this.tank)));
                    this.addAdditionalFluidInfo(tooltip, fluid);
                    tooltip.add(Text.localised("modularui.fluid.phantom.control", new Object[0]));
                } else {
                    this.addAdditionalFluidInfo(tooltip, fluid);
                    tooltip.add(Text.localised("modularui.phantom.single.clear", new Object[0]));
                }
                if (!Interactable.hasShiftDown()) {
                    tooltip.add(Text.EMPTY);
                    tooltip.add(Text.localised("modularui.tooltip.shift", new Object[0]));
                }
            } else {
                tooltip.add(Text.localised("modularui.fluid.empty", new Object[0]).format(EnumChatFormatting.WHITE));
            }
        } else {
            if (fluid != null) {
                this.addFluidNameInfo(tooltip, fluid);
                tooltip.add(Text.localised("modularui.fluid.amount", this.handler.getTankStoredAmount(this.tank), this.handler.getTankCapacity(this.tank)));
                this.addAdditionalFluidInfo(tooltip, fluid);
            } else {
                tooltip.add(Text.localised("modularui.fluid.empty", new Object[0]).format(EnumChatFormatting.WHITE));
                tooltip.add(Text.localised("modularui.fluid.capacity", this.handler.getTankCapacity(this.tank)));
            }
            if (this.canFillSlot || this.canDrainSlot) {
                tooltip.add(Text.EMPTY);
                if (Interactable.hasShiftDown()) {
                    if (this.canFillSlot && this.canDrainSlot) {
                        tooltip.add(Text.localised("modularui.fluid.click_combined", new Object[0]));
                    } else if (this.canDrainSlot) {
                        tooltip.add(Text.localised("modularui.fluid.click_to_fill", new Object[0]));
                    } else if (this.canFillSlot) {
                        tooltip.add(Text.localised("modularui.fluid.click_to_empty", new Object[0]));
                    }
                } else {
                    tooltip.add(Text.localised("modularui.tooltip.shift", new Object[0]));
                }
            }
        }
    }

    @Override
    @Nullable
    public String getBackgroundColorKey() {
        return "fluidslot";
    }

    @Override
    public void draw(float partialTicks) {
        FluidStack content = this.handler.getFluidStackInTank(this.tank);
        if (content != null) {
            float y = this.contentOffset.y;
            float height = this.size.height - this.contentOffset.y * 2;
            if (!this.alwaysShowFull) {
                float newHeight = height * (float)this.handler.getTankStoredAmount(this.tank) * 1.0f / (float)this.handler.getTankCapacity(this.tank);
                y += height - newHeight;
                height = newHeight;
            }
            GuiHelper.drawFluidTexture(content, this.contentOffset.x, y, this.size.width - this.contentOffset.x * 2, height, 0.0f);
        }
        if (this.overlayTexture != null) {
            this.overlayTexture.draw(Pos2d.ZERO, this.size, partialTicks);
        }
        if (content != null && (!this.phantom || this.controlsAmount)) {
            String s = NumberFormat.formatLong(this.handler.getTankStoredAmount(this.tank)) + "L";
            this.textRenderer.setAlignment(Alignment.CenterLeft, (float)(this.size.width - this.contentOffset.x) - 1.0f);
            this.textRenderer.setPos((int)((float)this.contentOffset.x + 0.5f), (int)((float)this.size.height - 4.5f));
            this.textRenderer.draw(s);
        }
        if (this.isHovering() && !this.getContext().getCursor().hasDraggable()) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GlStateManager.colorMask(true, true, true, false);
            ModularGui.drawSolidRect(1.0f, 1.0f, 16.0f, 16.0f, Theme.INSTANCE.getSlotHighlight());
            GlStateManager.colorMask(true, true, true, true);
            GL11.glDisable((int)3042);
        }
    }

    @Override
    public void onScreenUpdate() {
        if (this.lastShift != Interactable.hasShiftDown()) {
            this.lastShift = Interactable.hasShiftDown();
            this.notifyTooltipChange();
        }
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        if (!this.canFillSlot && !this.canDrainSlot) {
            return Interactable.ClickResult.ACKNOWLEDGED;
        }
        ItemStack cursorStack = this.getContext().getCursor().getItemStack();
        if (this.phantom || cursorStack != null) {
            Widget.ClickData clickData = Widget.ClickData.create(buttonId, doubleClick);
            ItemStack verifyToken = this.tryClickContainer(clickData);
            if (this.onClickContainer != null) {
                this.onClickContainer.accept(this);
            }
            this.syncToServer(1, buffer -> {
                clickData.writeToPacket((PacketBuffer)buffer);
                NetworkUtils.writeItemStack(buffer, verifyToken);
            });
            if (this.playClickSound) {
                Interactable.playButtonClickSound();
            }
            return Interactable.ClickResult.ACCEPT;
        }
        return Interactable.ClickResult.ACKNOWLEDGED;
    }

    @Override
    public boolean onMouseScroll(int direction) {
        if (this.phantom) {
            if (direction > 0 && !this.canFillSlot || direction < 0 && !this.canDrainSlot) {
                return false;
            }
            if (Interactable.hasShiftDown()) {
                direction *= 10;
            }
            if (Interactable.hasControlDown()) {
                direction *= 100;
            }
            int finalDirection = direction;
            this.syncToServer(2, buffer -> buffer.func_150787_b(finalDirection));
            return true;
        }
        return false;
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        IFluidTankLong currentFluid = this.handler.getFluidTank(this.tank);
        if (init || FluidSlotWidget.fluidChanged(currentFluid, this.lastStoredFluid)) {
            this.lastStoredFluid = currentFluid == null ? null : currentFluid.copy();
            this.syncToClient(5, buffer -> IFluidTankLong.writeToBuffer(buffer, currentFluid));
            this.markForUpdate();
        }
    }

    public static boolean fluidChanged(@Nullable IFluidTankLong currentFluid, @Nullable IFluidTankLong cached) {
        return currentFluid == null ^ cached == null || currentFluid != null && (currentFluid.getFluidAmountLong() != cached.getFluidAmountLong() || !currentFluid.isFluidEqual(cached));
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 5) {
            IFluidTankLong.readFromBuffer(buf, this.handler.getFluidTank(this.tank));
            this.notifyTooltipChange();
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 1) {
            this.onClickServer(Widget.ClickData.readPacket(buf), NetworkUtils.readItemStack(buf));
        } else if (id == 2) {
            if (this.phantom) {
                this.tryScrollPhantom(buf.func_150792_a());
            }
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        } else if (id == 4) {
            this.tryClickPhantom(Widget.ClickData.readPacket(buf), NetworkUtils.readItemStack(buf));
            if (this.onDragAndDropComplete != null) {
                this.onDragAndDropComplete.accept(this);
            }
        }
        this.markForUpdate();
    }

    protected void onClickServer(Widget.ClickData clickData, ItemStack clientVerifyToken) {
        ItemStack serverVerifyToken = this.tryClickContainer(clickData);
        if (this.onClickContainer != null) {
            this.onClickContainer.accept(this);
        }
        if (!ItemStack.func_77989_b((ItemStack)clientVerifyToken, (ItemStack)serverVerifyToken)) {
            ((EntityPlayerMP)this.getContext().getPlayer()).func_71120_a((Container)this.getContext().getContainer());
        }
    }

    protected ItemStack tryClickContainer(Widget.ClickData clickData) {
        if (this.phantom) {
            this.tryClickPhantom(clickData);
            return null;
        }
        return this.transferFluid(clickData);
    }

    protected ItemStack transferFluid(Widget.ClickData clickData) {
        EntityPlayer player = this.getContext().getPlayer();
        boolean processFullStack = clickData.mouseButton == 0;
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return null;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.handler.getFluidStackInTank(this.tank);
        FluidStack heldFluid = this.getFluidForRealItem(heldItemSizedOne);
        if (heldFluid != null && heldFluid.amount <= 0) {
            heldFluid = null;
        }
        if (currentFluid == null) {
            if (!this.canFillSlot) {
                return null;
            }
            if (heldFluid == null) {
                return null;
            }
            return this.fillFluid(heldFluid, processFullStack);
        }
        if (heldFluid != null && this.handler.getTankStoredAmount(this.tank) < this.handler.getTankCapacity(this.tank)) {
            if (this.canFillSlot) {
                return this.fillFluid(heldFluid, processFullStack);
            }
            if (!this.canDrainSlot) {
                return null;
            }
            return this.drainFluid(processFullStack);
        }
        if (!this.canDrainSlot) {
            return null;
        }
        return this.drainFluid(processFullStack);
    }

    protected ItemStack drainFluid(boolean processFullStack) {
        EntityPlayer player = this.getContext().getPlayer();
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return null;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.handler.getFluidStackInTank(this.tank);
        if (currentFluid == null) {
            return null;
        }
        currentFluid = currentFluid.copy();
        long originalFluidAmount = this.handler.getTankStoredAmount(this.tank);
        ItemStack filledContainer = this.fillFluidContainer(currentFluid, heldItemSizedOne);
        if (filledContainer != null) {
            long filledAmount = originalFluidAmount - (long)currentFluid.amount;
            if (filledAmount < 1L) {
                ModularUI.logger.warn("Item {} returned filled item {}, but no fluid was actually drained.", new Object[]{heldItemSizedOne.func_82833_r(), filledContainer.func_82833_r()});
                return null;
            }
            this.handler.drain(this.tank, filledAmount, false);
            if (processFullStack) {
                long additionalParallel = Math.min((long)(heldItem.field_77994_a - 1), (long)currentFluid.amount / filledAmount);
                this.handler.drain(this.tank, filledAmount * additionalParallel, false);
                filledContainer.field_77994_a = (int)((long)filledContainer.field_77994_a + additionalParallel);
            }
            this.replaceCursorItemStack(filledContainer);
            this.playSound(currentFluid, false);
        }
        return filledContainer;
    }

    protected ItemStack fillFluid(@NotNull FluidStack heldFluid, boolean processFullStack) {
        IFluidContainerItem container;
        FluidStack tDrained;
        EntityPlayer player = this.getContext().getPlayer();
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return null;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.handler.getFluidStackInTank(this.tank);
        if (currentFluid != null && !currentFluid.isFluidEqual(heldFluid)) {
            return null;
        }
        if (!this.filter.apply(heldFluid.getFluid()).booleanValue()) {
            return null;
        }
        long freeSpace = this.handler.getTankCapacity(this.tank) - this.handler.getTankStoredAmount(this.tank);
        if (freeSpace <= 0L) {
            return null;
        }
        ItemStack itemStackEmptied = null;
        int fluidAmountTaken = 0;
        if (freeSpace >= (long)heldFluid.amount) {
            itemStackEmptied = this.getContainerForFilledItemWithoutIFluidContainerItem(heldItemSizedOne);
            fluidAmountTaken = heldFluid.amount;
        }
        if (itemStackEmptied == null && heldItemSizedOne.func_77973_b() instanceof IFluidContainerItem && (tDrained = (container = (IFluidContainerItem)heldItemSizedOne.func_77973_b()).drain(heldItemSizedOne, Ints.saturatedCast((long)freeSpace), true)) != null && tDrained.amount > 0) {
            itemStackEmptied = heldItemSizedOne;
            fluidAmountTaken = tDrained.amount;
        }
        if (itemStackEmptied == null) {
            return null;
        }
        long parallel = processFullStack ? Math.min(freeSpace / (long)fluidAmountTaken, (long)heldItem.field_77994_a) : 1L;
        FluidStack copiedFluidStack = heldFluid.copy();
        this.handler.fill(this.tank, copiedFluidStack.getFluid(), (long)fluidAmountTaken * parallel, false);
        itemStackEmptied.field_77994_a = Ints.saturatedCast((long)parallel);
        this.replaceCursorItemStack(itemStackEmptied);
        this.playSound(heldFluid, true);
        return itemStackEmptied;
    }

    protected void replaceCursorItemStack(ItemStack resultStack) {
        EntityPlayer player = this.getContext().getPlayer();
        int resultStackMaxStackSize = resultStack.func_77976_d();
        while (resultStack.field_77994_a > resultStackMaxStackSize) {
            player.field_71071_by.func_70445_o().field_77994_a -= resultStackMaxStackSize;
            FluidSlotWidget.addItemToPlayerInventory(player, resultStack.func_77979_a(resultStackMaxStackSize));
        }
        if (player.field_71071_by.func_70445_o().field_77994_a == resultStack.field_77994_a) {
            player.field_71071_by.func_70437_b(resultStack);
        } else {
            ItemStack tStackHeld = player.field_71071_by.func_70445_o();
            tStackHeld.field_77994_a -= resultStack.field_77994_a;
            FluidSlotWidget.addItemToPlayerInventory(player, resultStack);
        }
    }

    protected void tryClickPhantom(Widget.ClickData clickData) {
        this.tryClickPhantom(clickData, this.getContext().getCursor().getItemStack());
    }

    protected void tryClickPhantom(Widget.ClickData clickData, ItemStack cursorStack) {
        FluidStack currentFluid = this.handler.getFluidStackInTank(this.tank);
        if (clickData.mouseButton == 0) {
            if (cursorStack == null) {
                if (this.canDrainSlot) {
                    this.handler.drain(this.tank, clickData.shift ? Integer.MAX_VALUE : 1000L, false);
                }
            } else {
                ItemStack heldItemSizedOne = cursorStack.func_77946_l();
                heldItemSizedOne.field_77994_a = 1;
                FluidStack heldFluid = this.getFluidForPhantomItem(heldItemSizedOne);
                if ((this.controlsAmount || currentFluid == null) && heldFluid != null) {
                    if (this.canFillSlot) {
                        if (!this.controlsAmount) {
                            heldFluid.amount = 1;
                        }
                        if (this.handler.fill((int)this.tank, (Fluid)heldFluid.getFluid(), (long)((long)heldFluid.amount), (boolean)true).amount > 0) {
                            this.lastStoredPhantomFluid = new FluidTankLong(heldFluid, this.handler.getTankCapacity(this.tank), this.handler.getTankStoredAmount(this.tank));
                        }
                    }
                } else if (this.canDrainSlot) {
                    this.handler.drain(this.tank, clickData.shift ? Integer.MAX_VALUE : 1000L, false);
                }
            }
        } else if (clickData.mouseButton == 1) {
            if (this.canFillSlot) {
                if (currentFluid != null) {
                    if (this.controlsAmount) {
                        FluidStack toFill = currentFluid.copy();
                        toFill.amount = 1000;
                        this.handler.fill(this.tank, toFill.getFluid(), toFill.amount, false);
                    }
                } else if (this.lastStoredPhantomFluid != null) {
                    this.handler.fill(this.tank, this.lastStoredPhantomFluid.getStoredFluid(), this.controlsAmount ? 1000L : 1L, false);
                }
            }
        } else if (clickData.mouseButton == 2 && currentFluid != null && this.canDrainSlot) {
            this.handler.drain(this.tank, clickData.shift ? Integer.MAX_VALUE : 1000L, false);
        }
    }

    protected void tryScrollPhantom(int direction) {
        FluidStack currentFluid = this.handler.getFluidStackInTank(this.tank);
        if (currentFluid == null) {
            if (direction > 0 && this.lastStoredPhantomFluid != null) {
                this.handler.fill(this.tank, this.lastStoredPhantomFluid.getStoredFluid(), this.controlsAmount ? (long)direction : 1L, false);
            }
            return;
        }
        if (direction > 0 && this.controlsAmount) {
            FluidStack toFill = currentFluid.copy();
            toFill.amount = direction;
            this.handler.fill(this.tank, toFill.getFluid(), toFill.amount, false);
        } else if (direction < 0) {
            this.handler.drain(this.tank, direction, false);
        }
    }

    protected void playSound(FluidStack fluid, boolean fill) {
    }

    @Override
    public boolean handleDragAndDrop(ItemStack draggedStack, int button) {
        if (!this.isPhantom()) {
            return false;
        }
        Widget.ClickData clickData = Widget.ClickData.create(button, false);
        this.tryClickPhantom(clickData, draggedStack);
        this.syncToServer(4, buffer -> {
            clickData.writeToPacket((PacketBuffer)buffer);
            NetworkUtils.writeItemStack(buffer, draggedStack);
        });
        draggedStack.field_77994_a = 0;
        return true;
    }

    protected static void addItemToPlayerInventory(EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack) && !player.field_70170_p.field_72995_K) {
            EntityItem dropItem = player.func_70099_a(stack, 0.0f);
            dropItem.field_145804_b = 0;
        }
    }

    public boolean canFillSlot() {
        return this.canFillSlot;
    }

    public boolean canDrainSlot() {
        return this.canDrainSlot;
    }

    public boolean alwaysShowFull() {
        return this.alwaysShowFull;
    }

    public Pos2d getContentOffset() {
        return this.contentOffset;
    }

    public boolean controlsAmount() {
        return this.controlsAmount;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    @Nullable
    public IDrawable getOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public ItemStack getStackUnderMouse() {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.getFluidDisplayStack((FluidStack)this.handler.getFluidStackInTank(this.tank), (boolean)false);
        }
        return null;
    }

    public FluidSlotWidget setInteraction(boolean canDrainSlot, boolean canFillSlot) {
        this.canDrainSlot = canDrainSlot;
        this.canFillSlot = canFillSlot;
        return this;
    }

    public FluidSlotWidget setAlwaysShowFull(boolean alwaysShowFull) {
        this.alwaysShowFull = alwaysShowFull;
        return this;
    }

    public FluidSlotWidget setContentOffset(Pos2d contentOffset) {
        this.contentOffset = contentOffset;
        return this;
    }

    public FluidSlotWidget setOverlayTexture(@Nullable IDrawable overlayTexture) {
        this.overlayTexture = overlayTexture;
        return this;
    }

    public FluidSlotWidget setPlayClickSound(boolean playClickSound) {
        this.playClickSound = playClickSound;
        return this;
    }

    public FluidSlotWidget setFilter(Function<Fluid, Boolean> filter) {
        this.filter = filter;
        return this;
    }

    public FluidSlotWidget setOnClickContainer(Consumer<FluidSlotWidget> onClickContainer) {
        this.onClickContainer = onClickContainer;
        return this;
    }

    public FluidSlotWidget setOnDragAndDropComplete(Consumer<Widget> onDragAndDropComplete) {
        this.onDragAndDropComplete = onDragAndDropComplete;
        return this;
    }
}

