/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerEnder<T extends IInventory>
extends Container {
    protected Map<Slot, Point> playerSlotLocations = Maps.newLinkedHashMap();
    protected final int startPlayerSlot;
    protected final int endPlayerSlot;
    protected final int startHotBarSlot;
    protected final int endHotBarSlot;
    @Nonnull
    private final T inv;
    @Nonnull
    private final InventoryPlayer playerInv;

    @Nonnull
    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public ContainerEnder(InventoryPlayer playerInv, T inv) {
        int i;
        this.inv = (IInventory)ContainerEnder.checkNotNull(inv);
        this.playerInv = ContainerEnder.checkNotNull(playerInv);
        this.addSlots(playerInv);
        int x = this.getPlayerInventoryOffset().x;
        int y = this.getPlayerInventoryOffset().y;
        this.startPlayerSlot = this.field_75151_b.size();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                Point loc = new Point(x + j * 18, y + i * 18);
                Slot slot = new Slot((IInventory)playerInv, j + i * 9 + 9, loc.x, loc.y);
                this.func_75146_a(slot);
                this.playerSlotLocations.put(slot, loc);
            }
        }
        this.endPlayerSlot = this.field_75151_b.size();
        this.startHotBarSlot = this.field_75151_b.size();
        for (i = 0; i < 9; ++i) {
            Point loc = new Point(x + i * 18, y + 58);
            Slot slot = new Slot((IInventory)playerInv, i, loc.x, loc.y);
            this.func_75146_a(slot);
            this.playerSlotLocations.put(slot, loc);
        }
        this.endHotBarSlot = this.field_75151_b.size();
    }

    protected void addSlots(InventoryPlayer playerInv) {
    }

    public Point getPlayerInventoryOffset() {
        return new Point(8, 84);
    }

    public Point getUpgradeOffset() {
        return new Point(12, 60);
    }

    @Nonnull
    public T getInv() {
        return this.inv;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.getInv().func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer p_82846_1_, int p_82846_2_) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(p_82846_2_);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int minPlayerSlot = this.field_75151_b.size() - this.playerInv.field_70462_a.length;
            if (p_82846_2_ < minPlayerSlot ? !this.func_75135_a(itemstack1, minPlayerSlot, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, minPlayerSlot, false)) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    protected boolean func_75135_a(ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reversOrder) {
        ItemStack itemstack1;
        Slot slot;
        boolean result = false;
        int checkIndex = fromIndex;
        if (reversOrder) {
            checkIndex = toIndex - 1;
        }
        if (par1ItemStack.func_77985_e()) {
            while (par1ItemStack.field_77994_a > 0 && (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex)) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 != null && itemstack1.func_77973_b() == par1ItemStack.func_77973_b() && (!par1ItemStack.func_77981_g() || par1ItemStack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)par1ItemStack, (ItemStack)itemstack1) && slot.func_75214_a(par1ItemStack) && par1ItemStack != itemstack1) {
                    int mergedSize = itemstack1.field_77994_a + par1ItemStack.field_77994_a;
                    int maxStackSize = Math.min(par1ItemStack.func_77976_d(), slot.func_75219_a());
                    if (mergedSize <= maxStackSize) {
                        par1ItemStack.field_77994_a = 0;
                        itemstack1.field_77994_a = mergedSize;
                        slot.func_75218_e();
                        result = true;
                    } else if (itemstack1.field_77994_a < maxStackSize) {
                        par1ItemStack.field_77994_a -= maxStackSize - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = maxStackSize;
                        slot.func_75218_e();
                        result = true;
                    }
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        if (par1ItemStack.field_77994_a > 0) {
            checkIndex = reversOrder ? toIndex - 1 : fromIndex;
            while (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 == null && slot.func_75214_a(par1ItemStack)) {
                    ItemStack in = par1ItemStack.func_77946_l();
                    in.field_77994_a = Math.min(in.field_77994_a, slot.func_75219_a());
                    slot.func_75215_d(in);
                    slot.func_75218_e();
                    par1ItemStack.field_77994_a = in.field_77994_a >= par1ItemStack.field_77994_a ? 0 : (par1ItemStack.field_77994_a -= in.field_77994_a);
                    result = true;
                    break;
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        return result;
    }
}

