/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.handler.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Triplet;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class EntityDeathHandler {
    private static final HashMap<Class, AutoMap<Triplet<ItemStack, Integer, Integer>>> mMobDropMap = new HashMap();
    private static final HashSet<Class> mInternalClassKeyCache = new HashSet();

    public static void registerDropsForMob(Class aMobClass, ItemStack aStack, int aMaxAmount, int aChance) {
        Triplet<ItemStack, Integer, Integer> aData = new Triplet<ItemStack, Integer, Integer>(aStack, aMaxAmount, aChance);
        AutoMap<Triplet<Object, Integer, Integer>> aDataMap = mMobDropMap.get(aMobClass);
        if (aDataMap == null) {
            aDataMap = new AutoMap();
        }
        aDataMap.put(aData);
        mMobDropMap.put(aMobClass, aDataMap);
        Logger.INFO("[Loot] Registered " + aStack.func_82833_r() + " (1-" + aMaxAmount + ") as a valid drop for " + aMobClass.getCanonicalName());
        mInternalClassKeyCache.add(aMobClass);
    }

    private static ItemStack processItemDropTriplet(Triplet<ItemStack, Integer, Integer> aData) {
        ItemStack aLoot = aData.getValue_1();
        int aMaxDrop = aData.getValue_2();
        int aChanceOutOf10000 = aData.getValue_3();
        if (MathUtils.randInt(0, 10000) <= aChanceOutOf10000 && ItemUtils.checkForInvalidItems(aLoot = ItemUtils.getSimpleStack(aLoot, MathUtils.randInt(1, aMaxDrop)))) {
            return aLoot;
        }
        return null;
    }

    private static boolean processDropsForMob(EntityLivingBase entityLiving) {
        AutoMap<Triplet<ItemStack, Integer, Integer>> aMobData = mMobDropMap.get(entityLiving.getClass());
        boolean aDidDrop = false;
        if (aMobData != null && !aMobData.isEmpty()) {
            for (Triplet<ItemStack, Integer, Integer> g : aMobData) {
                ItemStack aPossibleDrop = EntityDeathHandler.processItemDropTriplet(g);
                if (aPossibleDrop == null || entityLiving.func_70099_a(aPossibleDrop, MathUtils.randFloat(0.0f, 1.0f)) == null) continue;
                aDidDrop = true;
            }
        }
        return aDidDrop;
    }

    private static void dropMeatFromPlayer(EntityPlayer aPlayer) {
        int aBigMeatStackSize1 = MathUtils.randInt(4, 8);
        aPlayer.func_70099_a(ItemUtils.simpleMetaStack((Item)ModItems.itemMetaFood, 0, aBigMeatStackSize1), (float)MathUtils.randInt(0, 1));
        if (MathUtils.randInt(0, 10) < 7) {
            int aBigMeatStackSize2 = MathUtils.randInt(4, 8);
            aPlayer.func_70099_a(ItemUtils.simpleMetaStack((Item)ModItems.itemMetaFood, 0, aBigMeatStackSize2), (float)MathUtils.randInt(0, 1));
        }
        if (MathUtils.randInt(0, 10) < 4) {
            int aBigMeatStackSize3 = MathUtils.randInt(4, 8);
            aPlayer.func_70099_a(ItemUtils.simpleMetaStack((Item)ModItems.itemMetaFood, 0, aBigMeatStackSize3), (float)MathUtils.randInt(0, 1));
        }
        if (MathUtils.randInt(0, 10) < 2) {
            int aBigMeatStackSize4 = MathUtils.randInt(4, 8);
            aPlayer.func_70099_a(ItemUtils.simpleMetaStack((Item)ModItems.itemMetaFood, 0, aBigMeatStackSize4), (float)MathUtils.randInt(0, 1));
        }
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        if (event == null || event.entityLiving == null) {
            return;
        }
        if (PlayerUtils.isRealPlayer(event.entityLiving)) {
            EntityPlayer aPlayer = (EntityPlayer)event.entityLiving;
            EntityDeathHandler.dropMeatFromPlayer(aPlayer);
        } else {
            for (Class c : mInternalClassKeyCache) {
                if (!c.isInstance(event.entityLiving)) continue;
                EntityDeathHandler.processDropsForMob(event.entityLiving);
            }
        }
    }
}

