/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.recipe;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.HotFuel;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.item.chemistry.GenericChem;
import gtPlusPlus.core.item.chemistry.IonParticles;
import gtPlusPlus.core.item.crafting.ItemDummyResearch;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.ALLOY;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.material.ORES;
import gtPlusPlus.core.material.Particle;
import gtPlusPlus.core.material.nuclear.FLUORIDES;
import gtPlusPlus.core.recipe.RECIPES_RareEarthProcessing;
import gtPlusPlus.core.recipe.RECIPES_SeleniumProcessing;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.EnchantingUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.xmod.bop.blocks.BOP_Block_Registrator;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RECIPES_GREGTECH {
    public static void run() {
        Logger.INFO("Loading Recipes through GregAPI for Industrial Multiblocks.");
        RECIPES_GREGTECH.execute();
    }

    private static void execute() {
        RECIPES_GREGTECH.electrolyzerRecipes();
        RECIPES_GREGTECH.assemblerRecipes();
        RECIPES_GREGTECH.distilleryRecipes();
        RECIPES_GREGTECH.extractorRecipes();
        RECIPES_GREGTECH.fluidExtractorRecipes();
        RECIPES_GREGTECH.chemicalReactorRecipes();
        RECIPES_GREGTECH.dehydratorRecipes();
        RECIPES_GREGTECH.blastFurnaceRecipes();
        RECIPES_GREGTECH.largeChemReactorRecipes();
        RECIPES_GREGTECH.fusionRecipes();
        RECIPES_GREGTECH.compressorRecipes();
        RECIPES_GREGTECH.mixerRecipes();
        RECIPES_GREGTECH.macerationRecipes();
        RECIPES_GREGTECH.centrifugeRecipes();
        RECIPES_GREGTECH.cyclotronRecipes();
        RECIPES_GREGTECH.blastSmelterRecipes();
        RECIPES_GREGTECH.extruderRecipes();
        RECIPES_GREGTECH.cuttingSawRecipes();
        RECIPES_GREGTECH.breweryRecipes();
        RECIPES_GREGTECH.laserEngraverRecipes();
        RECIPES_GREGTECH.assemblyLineRecipes();
        RECIPES_GREGTECH.fluidHeaterRecipes();
        RECIPES_GREGTECH.chemplantRecipes();
        RECIPES_GREGTECH.alloySmelterRecipes();
        RECIPES_SeleniumProcessing.init();
        RECIPES_RareEarthProcessing.init();
        RECIPES_GREGTECH.addFuels();
    }

    private static void alloySmelterRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{MISC_MATERIALS.WOODS_GLASS.getDust(5), ItemList.Shape_Mold_Ball.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{GregtechItemList.Laser_Lens_WoodsGlass.get(1L, new Object[0])}).duration(6000).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.alloySmelterRecipes);
    }

    private static void chemplantRecipes() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(17), CI.getPinkCatalyst(0)}, new FluidStack[]{Materials.NitrogenDioxide.getFluid(4000L), FluidUtils.getAir(4000), FluidUtils.getWater(2000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack("nitricacid", 4000)}, 200, 480L, 3);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(17), CI.getPurpleCatalyst(0), ItemUtils.getSimpleStack(Blocks.field_150322_A, 64), ItemUtils.getSimpleStack(Blocks.field_150322_A, 64)}, new FluidStack[]{FluidUtils.getFluidStack("nitricacid", 4000), FluidUtils.getAir(8000)}, new ItemStack[]{FLUORIDES.FLUORITE.getOre(8), FLUORIDES.FLUORITE.getOre(4), FLUORIDES.FLUORITE.getOre(4), FLUORIDES.FLUORITE.getOre(4)}, new FluidStack[0], new int[]{0, 2500, 2000, 1500}, 200, 1024L, 5);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(17), CI.getPurpleCatalyst(0), ItemUtils.getSimpleStack((Block)Blocks.field_150354_m, 64), ItemUtils.getSimpleStack((Block)Blocks.field_150354_m, 64)}, new FluidStack[]{FluidUtils.getFluidStack("nitricacid", 5000), FluidUtils.getAir(12000)}, new ItemStack[]{FLUORIDES.FLUORITE.getOre(4), FLUORIDES.FLUORITE.getOre(2), FLUORIDES.FLUORITE.getOre(2), FLUORIDES.FLUORITE.getOre(2)}, new FluidStack[0], new int[]{7500, 1500, 1000, 500}, 200, 1024L, 5);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(16), CI.getPinkCatalyst(0)}, new FluidStack[]{Materials.NitrogenDioxide.getFluid(3000L), FluidUtils.getDistilledWater(1000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack("nitricacid", 2000), Materials.NitricOxide.getFluid(1000L)}, 200, 480L, 2);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(21), ItemUtils.getItemStackOfAmountFromOreDict("dustBorax", 23)}, new FluidStack[]{FluidUtils.getFluidStack(GenericChem.HydrochloricAcid, 2000)}, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustSalt", 4)}, new FluidStack[]{FluidUtils.getFluidStack("boricacid", 4000), FluidUtils.getWater(5000)}, 600, MaterialUtils.getVoltageForTier(3), 3);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(22), ELEMENT.getInstance().THORIUM.getDust(16)}, new FluidStack[]{FluidUtils.getDistilledWater(2000), FluidUtils.getFluidStack("boricacid", 1500)}, new ItemStack[]{ELEMENT.getInstance().THORIUM.getSmallDust(32), ELEMENT.getInstance().THORIUM232.getDust(2), ELEMENT.getInstance().THORIUM232.getSmallDust(2), ELEMENT.getInstance().URANIUM232.getDust(1)}, new FluidStack[0], new int[]{0, 0, 1000, 250}, 6000, MaterialUtils.getVoltageForTier(4), 4);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedBioCircuit(6), ItemUtils.getSimpleStack(Blocks.field_150345_g, 32)}, new FluidStack[]{FluidUtils.getFluidStack("fluid.geneticmutagen", 2000), FluidUtils.getDistilledWater(8000)}, new ItemStack[]{ItemUtils.getSimpleStack(BOP_Block_Registrator.sapling_Pine, 16)}, new FluidStack[0], 2400, 64L, 2);
        int aLaureniumTier = ALLOY.LAURENIUM.vTier;
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(12), CI.getTieredMachineCasing(aLaureniumTier - 1), ALLOY.LAURENIUM.getPlate(8), CI.getGear(aLaureniumTier, 2)}, new FluidStack[]{CI.getTieredFluid(aLaureniumTier, 288), CI.getAlternativeTieredFluid(aLaureniumTier - 1, 576), CI.getTertiaryTieredFluid(aLaureniumTier - 2, 864)}, new ItemStack[]{GregtechItemList.Casing_Machine_Custom_3.get(1L, new Object[0])}, new FluidStack[0], 400, MaterialUtils.getVoltageForTier(aLaureniumTier - 2), 5);
        int aBotmiumTier = ALLOY.BOTMIUM.vTier;
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(12), CI.getTieredMachineCasing(aBotmiumTier - 1), ALLOY.BOTMIUM.getPlate(8), CI.getGear(aBotmiumTier, 2)}, new FluidStack[]{CI.getTieredFluid(aBotmiumTier, 288), CI.getAlternativeTieredFluid(aBotmiumTier - 1, 576), CI.getTertiaryTieredFluid(aBotmiumTier - 2, 864)}, new ItemStack[]{GregtechItemList.Casing_Machine_Custom_4.get(1L, new Object[0])}, new FluidStack[0], 400, MaterialUtils.getVoltageForTier(aBotmiumTier - 2), 6);
        if (FluidUtils.doesHydrofluoricAcidGtExist()) {
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(22)}, new FluidStack[]{FluidUtils.getHydrofluoricAcid(2000), FluidUtils.getHydrofluoricAcidGT(5000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getHydrofluoricAcid(4500)}, 600, 480L, 3);
        }
    }

    private static void fluidHeaterRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)20)}).fluidInputs(new FluidStack[]{Materials.Water.getFluid(1000L)}).fluidOutputs(new FluidStack[]{FluidUtils.getHotWater(1000)}).duration(30).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.fluidHeaterRecipes);
    }

    private static void fusionRecipes() {
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{ELEMENT.STANDALONE.DRAGON_METAL.getFluidStack(144), ELEMENT.STANDALONE.RHUGNOR.getFluidStack(288)}).fluidOutputs(new FluidStack[]{ELEMENT.STANDALONE.HYPOGEN.getFluidStack(36)}).duration(8192).eut(TierEU.RECIPE_UHV).metadata(GT_RecipeConstants.FUSION_THRESHOLD, (Object)1200000000).addTo((IRecipeMap)RecipeMaps.fusionRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{MaterialUtils.getMaterial("Infinity", "Neutronium").getMolten(144L), ALLOY.QUANTUM.getFluidStack(288)}).fluidOutputs(new FluidStack[]{ELEMENT.STANDALONE.RHUGNOR.getFluidStack(144)}).duration(512).eut(TierEU.RECIPE_UV).metadata(GT_RecipeConstants.FUSION_THRESHOLD, (Object)2000000000).addTo((IRecipeMap)RecipeMaps.fusionRecipes);
    }

    private static void assemblyLineRecipes() {
        GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_1_CONTAINMENT, 1)).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)36000).itemInputs(new Object[]{ItemList.Field_Generator_IV.get(32L, new Object[0]), ItemList.Electric_Motor_EV.get(64L, new Object[0]), ItemList.Energy_LapotronicOrb.get(32L, new Object[0]), CI.getTieredComponent(OrePrefixes.cableGt12, 7, 32), CI.getTieredComponent(OrePrefixes.wireGt16, 6, 64), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Naquadria, (long)64L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Gadolinium, (long)32L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Samarium, (long)16L), ALLOY.ARCANITE.getGear(8), new Object[]{CI.getTieredCircuitOreDictName(5), 64}, new Object[]{CI.getTieredCircuitOreDictName(6), 32}, new Object[]{CI.getTieredCircuitOreDictName(7), 16}, GregtechItemList.Laser_Lens_Special.get(1L, new Object[0]), ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 3, 64)}).fluidInputs(new FluidStack[]{ALLOY.NITINOL_60.getFluidStack(5184), ALLOY.ENERGYCRYSTAL.getFluidStack(10368), ALLOY.TUMBAGA.getFluidStack(41472), Materials.Nichrome.getMolten(2304L)}).itemOutputs(new ItemStack[]{ItemUtils.getSimpleStack(ModBlocks.blockCasings3Misc, 15, 32)}).eut(TierEU.RECIPE_LuV).duration(24000).addTo(GT_RecipeConstants.AssemblyLine);
        GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_8_TURBINE_AUTOMATION, 1)).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)1728000).itemInputs(new Object[]{CI.getTieredMachineHull(8, 4), CI.getConveyor(8, 24), CI.getElectricMotor(7, 32), CI.getElectricPiston(7, 16), CI.getEnergyCore(6, 8), CI.getPlate(8, 24), CI.getTieredComponent(OrePrefixes.screw, 8, 48), CI.getTieredComponent(OrePrefixes.bolt, 7, 32), CI.getTieredComponent(OrePrefixes.rod, 6, 12), new Object[]{CI.getTieredCircuitOreDictName(7), 20}, CI.getTieredComponent(OrePrefixes.rotor, 6, 16)}).fluidInputs(new FluidStack[]{CI.getTieredFluid(8, 4608), CI.getAlternativeTieredFluid(7, 2304), CI.getTertiaryTieredFluid(7, 2304), ALLOY.BABBIT_ALLOY.getFluidStack(18432)}).itemOutputs(new ItemStack[]{GregtechItemList.Hatch_Input_TurbineHousing.get(4L, new Object[0])}).eut(TierEU.RECIPE_UV).duration(144000).addTo(GT_RecipeConstants.AssemblyLine);
        ItemStack[] aCoilWire = new ItemStack[]{ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 0, 64), ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 1, 64), ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 2, 64), ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 3, 64)};
        ItemStack[] aGemCasings = new ItemStack[]{GregtechItemList.Battery_Casing_Gem_1.get(1L, new Object[0]), GregtechItemList.Battery_Casing_Gem_2.get(1L, new Object[0]), GregtechItemList.Battery_Casing_Gem_3.get(1L, new Object[0]), GregtechItemList.Battery_Casing_Gem_4.get(1L, new Object[0])};
        ItemStack[] aResearch = new ItemStack[]{Particle.getBaseParticle(Particle.UNKNOWN), GregtechItemList.Battery_Casing_Gem_1.get(1L, new Object[0]), GregtechItemList.Battery_Casing_Gem_2.get(1L, new Object[0]), GregtechItemList.Battery_Casing_Gem_3.get(1L, new Object[0])};
        int aCasingSlot = 0;
        for (int j = 6; j < 10; ++j) {
            GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)aResearch[aCasingSlot]).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)72000).itemInputs(new ItemStack[]{CI.getTieredComponent(OrePrefixes.plate, j - 1, 16), CI.getTieredComponent(OrePrefixes.cableGt08, j + 1, 32), CI.getTieredComponent(OrePrefixes.gearGt, j - 1, 4), aCoilWire[aCasingSlot]}).fluidInputs(new FluidStack[]{CI.getTieredFluid(j, 1152), CI.getTertiaryTieredFluid(j - 2, 2304), CI.getAlternativeTieredFluid(j, 2304)}).itemOutputs(new ItemStack[]{aGemCasings[aCasingSlot++]}).eut(GT_Values.V[j]).duration(2400).addTo(GT_RecipeConstants.AssemblyLine);
        }
        ItemStack[] aGemBatteries = new ItemStack[]{GregtechItemList.Battery_Gem_1.get(1L, new Object[0]), GregtechItemList.Battery_Gem_2.get(1L, new Object[0]), GregtechItemList.Battery_Gem_3.get(1L, new Object[0]), GregtechItemList.Battery_Gem_4.get(1L, new Object[0])};
        ItemStack[] aExoticInputs = new ItemStack[]{Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.ELECTRON), Particle.getBaseParticle(Particle.CHARM), Particle.getBaseParticle(Particle.GRAVITON)};
        aCasingSlot = 0;
        for (int j = 6; j < 10; ++j) {
            GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)aExoticInputs[aCasingSlot]).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)360000).itemInputs(new Object[]{aGemCasings[aCasingSlot], ItemUtils.getSimpleStack(aExoticInputs[aCasingSlot], 16), CI.getTieredComponent(OrePrefixes.plate, j, 16), new Object[]{CI.getTieredCircuitOreDictName(j), 8}, CI.getTieredComponent(OrePrefixes.wireGt16, j + 1, 32), CI.getTieredComponent(OrePrefixes.bolt, j, 8), CI.getTieredComponent(OrePrefixes.screw, j - 1, 8)}).fluidInputs(new FluidStack[]{CI.getTieredFluid(j, 2304), CI.getTertiaryTieredFluid(j - 2, 4608), CI.getAlternativeTieredFluid(j, 2304), CI.getTertiaryTieredFluid(j - 1, 2304)}).itemOutputs(new ItemStack[]{aGemBatteries[aCasingSlot++]}).eut(GT_Values.V[j]).duration(2400).addTo(GT_RecipeConstants.AssemblyLine);
        }
        if (Mods.Baubles.isModLoaded()) {
            GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)ItemUtils.simpleMetaStack(Items.field_151153_ao, 1, 1)).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)12000).itemInputs(new Object[]{ItemUtils.getSimpleStack(aGemCasings[2], 4), CI.getTieredComponent(OrePrefixes.plate, 8, 32), new Object[]{CI.getTieredCircuitOreDictName(7), 16}, CI.getTieredComponent(OrePrefixes.cableGt02, 7, 16), CI.getTieredComponent(OrePrefixes.gearGt, 6, 6), CI.getTieredComponent(OrePrefixes.screw, 7, 16), CI.getTieredComponent(OrePrefixes.bolt, 5, 24), CI.getTieredComponent(OrePrefixes.frameGt, 4, 12), ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 3, 64)}).fluidInputs(new FluidStack[]{CI.getTieredFluid(7, 41472), CI.getTertiaryTieredFluid(7, 41472), CI.getAlternativeTieredFluid(6, 41472), CI.getAlternativeTieredFluid(7, 41472)}).itemOutputs(new ItemStack[]{ItemUtils.getItemStackFromFQRN("miscutils:personalHealingDevice", 1)}).eut(TierEU.RECIPE_ZPM).duration(72000).addTo(GT_RecipeConstants.AssemblyLine);
            ItemStack[] aChargeResearch = new ItemStack[]{ItemUtils.getItemStackFromFQRN("miscutils:item.itemBufferCore7", 1), ItemUtils.getItemStackFromFQRN("miscutils:item.itemBufferCore8", 1), ItemUtils.getItemStackFromFQRN("miscutils:item.itemBufferCore9", 1), ItemUtils.getItemStackFromFQRN("miscutils:item.itemBufferCore10", 1)};
            ItemStack[] aChargeOutputs = new ItemStack[]{ItemUtils.getSimpleStack(ModItems.itemChargePack_High_1, 1), ItemUtils.getSimpleStack(ModItems.itemChargePack_High_2, 1), ItemUtils.getSimpleStack(ModItems.itemChargePack_High_3, 1), ItemUtils.getSimpleStack(ModItems.itemChargePack_High_4, 1)};
            int aCurrSlot = 0;
            for (int h = 6; h < 10; ++h) {
                GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)aChargeResearch[aCurrSlot]).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)(10 * (aCurrSlot + 1) * 1200)).itemInputs(new Object[]{ItemUtils.getSimpleStack(aGemBatteries[aCurrSlot], 2), aCoilWire[aCurrSlot], CI.getTieredComponent(OrePrefixes.plate, h, 8), new Object[]{CI.getTieredCircuitOreDictName(h), 4}, new Object[]{CI.getTieredCircuitOreDictName(h - 1), 8}, CI.getTieredComponent(OrePrefixes.cableGt12, h - 1, 16), CI.getTieredComponent(OrePrefixes.screw, h, 16), CI.getTieredComponent(OrePrefixes.bolt, h - 2, 32), CI.getFieldGenerator(h - 1, 1)}).fluidInputs(new FluidStack[]{CI.getTieredFluid(h, 4608), CI.getTertiaryTieredFluid(h - 1, 4608), CI.getAlternativeTieredFluid(h - 1, 4608), CI.getAlternativeTieredFluid(h - 2, 4608)}).itemOutputs(new ItemStack[]{aChargeOutputs[aCurrSlot]}).eut(GT_Values.V[h]).duration((aCurrSlot + 1) * 72000).addTo(GT_RecipeConstants.AssemblyLine);
                ++aCurrSlot;
            }
            GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_9_CLOAKING, 1)).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)12000).itemInputs(new Object[]{ItemUtils.getSimpleStack(aGemCasings[3], 4), CI.getTieredComponent(OrePrefixes.plate, 8, 32), new Object[]{CI.getTieredCircuitOreDictName(7), 16}, CI.getTieredComponent(OrePrefixes.cableGt04, 8, 16), CI.getTieredComponent(OrePrefixes.gearGt, 7, 6), CI.getTieredComponent(OrePrefixes.screw, 8, 16), CI.getTieredComponent(OrePrefixes.bolt, 7, 24), CI.getTieredComponent(OrePrefixes.frameGt, 5, 12), ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 3, 64)}).fluidInputs(new FluidStack[]{CI.getTieredFluid(8, 41472), CI.getTertiaryTieredFluid(8, 41472), CI.getAlternativeTieredFluid(7, 41472), CI.getAlternativeTieredFluid(8, 41472)}).itemOutputs(new ItemStack[]{ItemUtils.getItemStackFromFQRN("miscutils:personalCloakingDevice-0.0", 1)}).eut(TierEU.RECIPE_UV).duration(72000).addTo(GT_RecipeConstants.AssemblyLine);
        }
        GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)GregtechItemList.Industrial_AlloyBlastSmelter.get(1L, new Object(){})).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)36000).itemInputs(new Object[]{GregtechItemList.Industrial_AlloyBlastSmelter.get(64L, new Object(){}), GregtechItemList.Industrial_AlloyBlastSmelter.get(64L, new Object(){}), GregtechItemList.Industrial_AlloyBlastSmelter.get(64L, new Object(){}), GregtechItemList.Industrial_AlloyBlastSmelter.get(64L, new Object(){}), ItemList.UV_Coil.get(16L, new Object[]{new Object(){}}), ItemList.Conveyor_Module_UV.get(4L, new Object[]{new Object(){}}), new Object[]{OrePrefixes.circuit.get((Object)Materials.SuperconductorUHV), 8}, new Object[]{OrePrefixes.circuit.get((Object)Materials.Ultimate), 16}, ItemList.Circuit_Chip_PPIC.get(16L, new Object[]{new Object(){}}), ALLOY.PIKYONIUM.getPlate(16), ALLOY.CINOBITE.getScrew(32)}).fluidInputs(new FluidStack[]{ALLOY.PIKYONIUM.getFluidStack(1152), ALLOY.INDALLOY_140.getFluidStack(1296), Materials.SolderingAlloy.getMolten(1440L)}).itemOutputs(new ItemStack[]{GregtechItemList.Mega_AlloyBlastSmelter.get(1L, new Object[0])}).eut(TierEU.RECIPE_UHV / 2L).duration(1200).addTo(GT_RecipeConstants.AssemblyLine);
    }

    private static void laserEngraverRecipes() {
        GregtechItemList[] aTransParts = new GregtechItemList[]{GregtechItemList.TransmissionComponent_LV, GregtechItemList.TransmissionComponent_MV, GregtechItemList.TransmissionComponent_HV, GregtechItemList.TransmissionComponent_EV, GregtechItemList.TransmissionComponent_IV, GregtechItemList.TransmissionComponent_LuV, GregtechItemList.TransmissionComponent_ZPM, GregtechItemList.TransmissionComponent_UV, GregtechItemList.TransmissionComponent_UHV};
        for (int i = 1; i < aTransParts.length; ++i) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.getEmitter(i, 2), CI.getSensor(i, 2)}).itemOutputs(new ItemStack[]{aTransParts[i - 1].get(1L, new Object[0])}).duration(100).eut(GT_Values.VP[i]).addTo((IRecipeMap)RecipeMaps.laserEngraverRecipes);
        }
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Tungsten, (long)6L), GregtechItemList.Laser_Lens_Special.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{ELEMENT.STANDALONE.CELESTIAL_TUNGSTEN.getDust(1)}).duration(3600).eut(MaterialUtils.getVoltageForTier(ELEMENT.STANDALONE.CELESTIAL_TUNGSTEN.vTier)).addTo((IRecipeMap)RecipeMaps.laserEngraverRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Titanium, (long)8L), GregtechItemList.Laser_Lens_Special.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{ELEMENT.STANDALONE.ASTRAL_TITANIUM.getDust(1)}).duration(2400).eut(MaterialUtils.getVoltageForTier(ELEMENT.STANDALONE.ASTRAL_TITANIUM.vTier)).addTo((IRecipeMap)RecipeMaps.laserEngraverRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ALLOY.NITINOL_60.getBlock(2), GregtechItemList.Laser_Lens_Special.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{ELEMENT.STANDALONE.ADVANCED_NITINOL.getBlock(1)}).duration(1200).eut(MaterialUtils.getVoltageForTier(ELEMENT.STANDALONE.ADVANCED_NITINOL.vTier)).addTo((IRecipeMap)RecipeMaps.laserEngraverRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Glass, (long)64L), GregtechItemList.Laser_Lens_Special.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{ELEMENT.STANDALONE.CHRONOMATIC_GLASS.getDust(1)}).duration(6000).eut(MaterialUtils.getVoltageForTier(ELEMENT.STANDALONE.CHRONOMATIC_GLASS.vTier)).addTo((IRecipeMap)RecipeMaps.laserEngraverRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.getFieldGenerator(6, 1), CI.getEmitter(7, 2)}).itemOutputs(new ItemStack[]{ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_1_CONTAINMENT, 1)}).duration(6000).eut(TierEU.RECIPE_IV).addTo((IRecipeMap)RecipeMaps.laserEngraverRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GregtechItemList.Laser_Lens_WoodsGlass.get(0L, new Object[0]), ItemUtils.simpleMetaStack(AgriculturalChem.mBioCircuit, 20, 1)}).itemOutputs(new ItemStack[]{GregtechItemList.Distillus_Upgrade_Chip.get(1L, new Object[0])}).duration(6000).eut(TierEU.RECIPE_IV).addTo((IRecipeMap)RecipeMaps.laserEngraverRecipes);
    }

    private static void breweryRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)14)}).fluidInputs(new FluidStack[]{EnchantingUtils.getMobEssence(100)}).fluidOutputs(new FluidStack[]{EnchantingUtils.getLiquidXP(1332)}).duration(100).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.brewingRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)14)}).fluidInputs(new FluidStack[]{EnchantingUtils.getLiquidXP(1332)}).fluidOutputs(new FluidStack[]{EnchantingUtils.getMobEssence(100)}).duration(100).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.brewingRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getSimpleStack(BOP_Block_Registrator.sapling_Rainforest)}).fluidInputs(new FluidStack[]{Materials.Water.getFluid(100L)}).fluidOutputs(new FluidStack[]{Materials.Biomass.getFluid(100L)}).duration(1200).eut(3).addTo((IRecipeMap)RecipeMaps.brewingRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getSimpleStack(BOP_Block_Registrator.sapling_Rainforest)}).fluidInputs(new FluidStack[]{Materials.Honey.getFluid(100L)}).fluidOutputs(new FluidStack[]{Materials.Biomass.getFluid(100L)}).duration(1200).eut(3).addTo((IRecipeMap)RecipeMaps.brewingRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getSimpleStack(BOP_Block_Registrator.sapling_Rainforest)}).fluidInputs(new FluidStack[]{FluidUtils.getFluidStack("juice", 100)}).fluidOutputs(new FluidStack[]{Materials.Biomass.getFluid(100L)}).duration(1200).eut(3).addTo((IRecipeMap)RecipeMaps.brewingRecipes);
    }

    private static void cuttingSawRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("blockMeatRaw", 1)}).itemOutputs(new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("plateMeatRaw", 9)}).duration(16).eut(TierEU.RECIPE_ULV).addTo((IRecipeMap)RecipeMaps.cutterRecipes);
    }

    private static void electrolyzerRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getSimpleStack(ModItems.dustDecayedRadium226, 1)}).fluidOutputs(new FluidStack[]{FluidUtils.getFluidStack("radon", 144)}).duration(1800).eut(TierEU.RECIPE_HV / 2L).addTo((IRecipeMap)RecipeMaps.electrolyzerRecipes);
    }

    private static void extruderRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("blockOsmium", 1), ItemList.Shape_Mold_Credit.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{ItemList.Credit_Greg_Osmium.get(1L, new Object[0])}).duration(7600).eut(TierEU.RECIPE_EV / 2L).addTo((IRecipeMap)RecipeMaps.extruderRecipes);
    }

    private static void blastSmelterRecipes() {
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(6), ELEMENT.getInstance().IRON.getDust(4), ALLOY.KANTHAL.getDust(1), ALLOY.INVAR.getDust(5), ELEMENT.getInstance().SULFUR.getDust(1), ELEMENT.getInstance().CARBON.getDust(1), ELEMENT.getInstance().SILICON.getDust(4)}, ALLOY.EGLIN_STEEL.getFluidStack(2304), 0, 900, 120);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(5), ELEMENT.getInstance().BARIUM.getDust(2), ELEMENT.getInstance().CALCIUM.getDust(2), ELEMENT.getInstance().COPPER.getDust(3)}, new FluidStack[]{ELEMENT.getInstance().OXYGEN.getFluidStack(8000), ELEMENT.getInstance().MERCURY.getFluidStack(1000)}, ALLOY.HG1223.getFluidStack(2304), null, new int[]{10000}, 2400, 30720);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(2), ELEMENT.getInstance().TITANIUM.getDust(3), ELEMENT.getInstance().NICKEL.getDust(2)}, ALLOY.NITINOL_60.getFluidStack(720), 0, 1500, 7680);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(5), ELEMENT.getInstance().BISMUTH.getDust(47), ELEMENT.getInstance().LEAD.getDust(25), ELEMENT.getInstance().TIN.getDust(13), ELEMENT.getInstance().CADMIUM.getDust(10), ELEMENT.getInstance().INDIUM.getDust(5)}, ALLOY.INDALLOY_140.getFluidStack(14400), 0, 800, 7680);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(15), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedSphalerite", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(2000L), ELEMENT.getInstance().GERMANIUM.getFluidStack(288), 0, 6000, 4000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(20), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedScheelite", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(10000L), ELEMENT.getInstance().RHENIUM.getFluidStack(144), 0, 6000, 4000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(20), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedMolybdenite", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(7500L), ELEMENT.getInstance().RHENIUM.getFluidStack(144), 0, 6000, 4000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(20), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedMolybdenum", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(5000L), ELEMENT.getInstance().RHENIUM.getFluidStack(288), 0, 6000, 4000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(21), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedZinc", 3), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedPyrite", 4), ELEMENT.getInstance().CARBON.getDust(16)}, Materials.SulfuricAcid.getFluid(1250L), ELEMENT.getInstance().THALLIUM.getFluidStack(288), new ItemStack[0], new int[]{0}, 1500, 8000, 3700, false);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(21), MISC_MATERIALS.STRONTIUM_OXIDE.getDust(8), ELEMENT.getInstance().ALUMINIUM.getDust(8)}, (FluidStack)null, ELEMENT.getInstance().OXYGEN.getFluidStack(8000), new ItemStack[]{ELEMENT.getInstance().ALUMINIUM.getIngot(8), ELEMENT.getInstance().STRONTIUM.getIngot(8)}, new int[]{10000, 10000}, 2400, 1920);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(4), ItemUtils.getItemStackOfAmountFromOreDict("dustNitinol60", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustOsmium", 6), ItemUtils.getItemStackOfAmountFromOreDict("dustRuthenium", 6), ItemUtils.getItemStackOfAmountFromOreDict("dustThallium", 3)}, GT_Values.NF, ALLOY.BOTMIUM.getFluidStack(2304), 0, 2400, 491520);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(6), ItemUtils.getItemStackOfAmountFromOreDict("dustRuthenium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRhodium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustPalladium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustPlatinum", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustOsmium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustIridium", 1)}, GT_Values.NF, FluidUtils.getFluidStack("molten.precious metals alloy", 864), 0, 10800, 0x780000);
    }

    private static void dehydratorRecipes() {
        Logger.INFO("Loading Recipes for Chemical Dehydrator.");
        ItemStack cropGrape = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cropGrape", 1);
        ItemStack foodRaisins = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("foodRaisins", 1);
        if (cropGrape != null && foodRaisins != null) {
            CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(20), cropGrape}, null, null, new ItemStack[]{foodRaisins}, new int[]{10000}, 10, 2);
        }
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(21)}, FluidUtils.getFluidStack("fluid.sludge", 1000), FluidUtils.getFluidStack("nitricacid", 10), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustTinyIron", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyCopper", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyTin", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyNickel", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyCobalt", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyAluminium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinySilver", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyGold", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyIridium", 1)}, new int[]{10, 5, 5, 4, 4, 3, 2, 2, 1}, 40, 500);
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(18), CI.emptyCells(3)}, FluidUtils.getFluidStack("fluid.ethylbenzene", 1000), null, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellStyrene", 1), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrogen", 2)}, new int[]{10000, 10000}, 60, 30);
        if (Mods.Backpack.isModLoaded()) {
            CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(18), new ItemStack(Items.field_151116_aA, 2)}, FluidUtils.getFluidStack("fluid.ethylbenzene", 1000), null, new ItemStack[]{ItemUtils.getCorrectStacktype("Backpack:tannedLeather", 1)}, new int[]{10000}, 100, 180);
            if (Mods.NewHorizonsCoreMod.isModLoaded()) {
                CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(18), GT_ModHandler.getModItem((String)Mods.NewHorizonsCoreMod.ID, (String)"item.ArtificialLeather", (long)2L, (int)0)}, FluidUtils.getFluidStack("fluid.ethylbenzene", 1000), null, new ItemStack[]{ItemUtils.getCorrectStacktype("Backpack:tannedLeather", 1)}, new int[]{10000}, 100, 180);
            }
        }
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(18), CI.emptyCells(1)}, FluidUtils.getFluidStack("aceticacid", 2000), MISC_MATERIALS.ACETIC_ANHYDRIDE.getFluidStack(1000), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellWater", 1)}, new int[]{10000}, 600, 480);
    }

    private static void largeChemReactorRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)24)}).itemOutputs(new ItemStack[0]).fluidInputs(new FluidStack[]{FluidUtils.getFluidStack("fluid.ethylbenzene", 1000)}).fluidOutputs(new FluidStack[]{Materials.Styrene.getFluid(1000L), Materials.Hydrogen.getGas(2000L)}).duration(30).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.multiblockChemicalReactorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)24)}).itemOutputs(new ItemStack[0]).fluidInputs(new FluidStack[]{Materials.Ethylene.getGas(500L), Materials.Benzene.getFluid(500L)}).fluidOutputs(new FluidStack[]{Materials.Styrene.getFluid(500L), Materials.Hydrogen.getGas(1000L)}).duration(240).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.multiblockChemicalReactorRecipes);
    }

    private static void assemblerRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Vanadium, (long)32L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.VanadiumSteel, (long)8L)}).itemOutputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemHalfCompleteCasings, 0, 4)}).fluidInputs(new FluidStack[]{Materials.Oxygen.getGas(8000L)}).duration(320).eut(TierEU.RECIPE_MV / 2L).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemHalfCompleteCasings, 0, 2), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.VanadiumGallium, (long)8L)}).itemOutputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemHalfCompleteCasings, 1, 8)}).fluidInputs(new FluidStack[]{Materials.Tantalum.getMolten(576L)}).duration(640).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemHalfCompleteCasings, 1, 1), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Lead, (long)4L), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(3), 4), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorHV, (long)2L)}).itemOutputs(new ItemStack[]{ItemUtils.getSimpleStack(GregtechItemList.Casing_Vanadium_Redox.get(1L, new Object[0]), 1)}).fluidInputs(new FluidStack[]{Materials.Oxygen.getGas(16000L)}).duration(64).eut(TierEU.RECIPE_HV / 2L).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GregtechItemList.Casing_Vanadium_Redox.get(1L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Titanium, (long)4L), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(4), 4), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorEV, (long)2L)}).itemOutputs(new ItemStack[]{GregtechItemList.Casing_Vanadium_Redox_IV.get(1L, new Object[0])}).fluidInputs(new FluidStack[]{Materials.Nitrogen.getGas(16000L)}).duration(120).eut(TierEU.RECIPE_EV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GregtechItemList.Casing_Vanadium_Redox_IV.get(1L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.TungstenSteel, (long)4L), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(5), 4), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorIV, (long)2L)}).itemOutputs(new ItemStack[]{GregtechItemList.Casing_Vanadium_Redox_LuV.get(1L, new Object[0])}).fluidInputs(new FluidStack[]{Materials.Helium.getGas(8000L)}).duration(250).eut(TierEU.RECIPE_IV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GregtechItemList.Casing_Vanadium_Redox_LuV.get(1L, new Object[0]), ItemUtils.getItemStackOfAmountFromOreDict("plateAlloyIridium", 16), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(6), 4), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorLuV, (long)2L)}).itemOutputs(new ItemStack[]{GregtechItemList.Casing_Vanadium_Redox_ZPM.get(1L, new Object[0])}).fluidInputs(new FluidStack[]{Materials.Argon.getGas(4000L)}).duration(500).eut(TierEU.RECIPE_LuV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GregtechItemList.Casing_Vanadium_Redox_ZPM.get(1L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Naquadah, (long)4L), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(7), 4), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorZPM, (long)2L)}).itemOutputs(new ItemStack[]{GregtechItemList.Casing_Vanadium_Redox_UV.get(1L, new Object[0])}).fluidInputs(new FluidStack[]{Materials.Radon.getGas(4000L)}).duration(1000).eut(TierEU.RECIPE_ZPM).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GregtechItemList.Casing_Vanadium_Redox_UV.get(1L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Americium, (long)4L), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(8), 4), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorUV, (long)2L)}).itemOutputs(new ItemStack[]{GregtechItemList.Casing_Vanadium_Redox_MAX.get(1L, new Object[0])}).fluidInputs(new FluidStack[]{FluidUtils.getFluidStack("krypton", 500)}).duration(2000).eut(TierEU.RECIPE_UV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getSimpleStack(CI.explosiveITNT, 2), ItemUtils.getSimpleStack(CI.explosiveTNT, 4), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Sulfur, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.Iron, (long)1L)}).itemOutputs(new ItemStack[]{ItemUtils.getSimpleStack(ModBlocks.blockMiningExplosive, 3)}).duration(100).eut(TierEU.RECIPE_MV / 2L).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.NetherStar, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.TungstenSteel, (long)8L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.BlackSteel, (long)8L)}).itemOutputs(new ItemStack[]{ItemUtils.getSimpleStack(ModBlocks.blockWitherGuard, 64)}).duration(600).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.fluidRegulator_LV, CI.electricMotor_LV, CI.getTieredComponent(OrePrefixes.bolt, 1, 8), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ring, (Object)Materials.Brass, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.Brass, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Steel, (long)2L)}).itemOutputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 1, 1)}).duration(200).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.fluidRegulator_MV, CI.electricMotor_MV, CI.getTieredComponent(OrePrefixes.bolt, 2, 8), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ring, (Object)Materials.Invar, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.Invar, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Aluminium, (long)2L)}).itemOutputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 2, 1)}).duration(400).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.fluidRegulator_HV, CI.electricMotor_HV, CI.getTieredComponent(OrePrefixes.bolt, 3, 8), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ring, (Object)Materials.Chrome, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.Chrome, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.StainlessSteel, (long)2L)}).itemOutputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 3, 1)}).duration(600).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.fluidRegulator_EV, CI.electricMotor_EV, CI.getTieredComponent(OrePrefixes.bolt, 4, 8), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ring, (Object)Materials.Titanium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.Titanium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.TungstenSteel, (long)2L)}).itemOutputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 4, 1)}).duration(800).eut(TierEU.RECIPE_EV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 1, 1), GT_Utility.getIntegratedCircuit((int)20)}).itemOutputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.toolGregtechPump, 1000, 1)}).duration(30).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 2, 1), GT_Utility.getIntegratedCircuit((int)20)}).itemOutputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.toolGregtechPump, 1001, 1)}).duration(120).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 3, 1), GT_Utility.getIntegratedCircuit((int)20)}).itemOutputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.toolGregtechPump, 1002, 1)}).duration(480).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 4, 1), GT_Utility.getIntegratedCircuit((int)20)}).itemOutputs(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.toolGregtechPump, 1003, 1)}).duration(1920).eut(TierEU.RECIPE_EV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        ItemStack[] aPackBatteries = new ItemStack[]{ItemList.Battery_RE_LV_Lithium.get(4L, new Object[0]), ItemList.Battery_RE_MV_Lithium.get(4L, new Object[0]), ItemList.Battery_RE_HV_Lithium.get(4L, new Object[0]), GregtechItemList.Battery_RE_EV_Lithium.get(4L, new Object[0]), ItemList.Energy_LapotronicOrb.get(4L, new Object[0])};
        ItemStack[] aPackPlates = new ItemStack[]{CI.getPlate(1, 8), CI.getPlate(2, 8), CI.getPlate(3, 8), CI.getPlate(4, 8), CI.getPlate(5, 8)};
        ItemStack[] aPackWire = new ItemStack[]{CI.getTieredComponent(OrePrefixes.wireGt02, 1, 6), CI.getTieredComponent(OrePrefixes.wireGt04, 2, 6), CI.getTieredComponent(OrePrefixes.wireGt08, 3, 6), CI.getTieredComponent(OrePrefixes.wireGt12, 4, 6), CI.getTieredComponent(OrePrefixes.wireGt16, 5, 6)};
        ItemStack[] aPackCircuit = new ItemStack[]{CI.getTieredComponent(OrePrefixes.circuit, 1, 4), CI.getTieredComponent(OrePrefixes.circuit, 2, 4), CI.getTieredComponent(OrePrefixes.circuit, 3, 4), CI.getTieredComponent(OrePrefixes.circuit, 4, 4), CI.getTieredComponent(OrePrefixes.circuit, 5, 4)};
        ItemStack[] aPackRing = new ItemStack[]{CI.getTieredComponent(OrePrefixes.ring, 1, 12), CI.getTieredComponent(OrePrefixes.ring, 2, 12), CI.getTieredComponent(OrePrefixes.ring, 3, 12), CI.getTieredComponent(OrePrefixes.ring, 4, 12), CI.getTieredComponent(OrePrefixes.ring, 5, 12)};
        ItemStack[] aPackOutput = new ItemStack[]{ItemUtils.getSimpleStack(ModItems.itemChargePack_Low_1), ItemUtils.getSimpleStack(ModItems.itemChargePack_Low_2), ItemUtils.getSimpleStack(ModItems.itemChargePack_Low_3), ItemUtils.getSimpleStack(ModItems.itemChargePack_Low_4), ItemUtils.getSimpleStack(ModItems.itemChargePack_Low_5)};
        for (int i = 1; i < 6; ++i) {
            int aAS = i - 1;
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{aPackPlates[aAS], aPackRing[aAS], aPackWire[aAS], aPackCircuit[aAS], aPackBatteries[aAS], CI.getSensor(i, 4)}).itemOutputs(new ItemStack[]{aPackOutput[aAS]}).fluidInputs(new FluidStack[]{CI.getTieredFluid(i, 576)}).duration(30 * i * 20).eut(GT_Values.V[i]).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        if (Mods.Baubles.isModLoaded()) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)17), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Trinium, (long)64L), CI.getSensor(6, 6), CI.getBolt(7, 64), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.Platinum, (long)64L), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(7), 12)}).itemOutputs(new ItemStack[]{ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_8_TURBINE_AUTOMATION, 1)}).fluidInputs(new FluidStack[]{CI.getAlternativeTieredFluid(7, 4608)}).duration(6000).eut(TierEU.RECIPE_LuV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)17), ItemUtils.getSimpleStack(ModItems.itemCircuitLFTR, 4), CI.getFieldGenerator(6, 16), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.Palladium, (long)32L), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(6), 12)}).itemOutputs(new ItemStack[]{ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_9_CLOAKING, 1)}).fluidInputs(new FluidStack[]{CI.getAlternativeTieredFluid(7, 4608)}).duration(12000).eut(TierEU.RECIPE_ZPM).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
    }

    private static void distilleryRecipes() {
        Logger.INFO("Registering Distillery/Distillation Tower Recipes.");
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)4)}).fluidInputs(new FluidStack[]{Materials.Air.getGas(1000L)}).fluidOutputs(new FluidStack[]{Materials.Helium.getGas(1L)}).duration(400).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.distilleryRecipes);
        GT_Values.RA.stdBuilder().itemOutputs(new ItemStack[]{ItemUtils.getSimpleStack(ModItems.itemHydrogenBlob, 1)}).fluidInputs(new FluidStack[]{Materials.Air.getGas(20000L)}).fluidOutputs(new FluidStack[]{Materials.Helium.getGas(25L)}).duration(200).eut(TierEU.RECIPE_MV / 2L).addTo((IRecipeMap)RecipeMaps.distillationTowerRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{FluidUtils.getFluidStack("sulfuricapatite", 5200)}).fluidOutputs(new FluidStack[]{FluidUtils.getFluidStack("sulfurousacid", 3800), FluidUtils.getFluidStack("hydrogenchloride", 1000), FluidUtils.getFluidStack("hydrofluoricacid", 400)}).duration(900).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.distillationTowerRecipes);
        GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{FluidUtils.getFluidStack("sulfurousacid", 1000)}).fluidOutputs(new FluidStack[]{Materials.SulfurDioxide.getGas(500L), Materials.Water.getFluid(500L)}).duration(200).eut(TierEU.RECIPE_MV / 2L).addTo((IRecipeMap)RecipeMaps.distillationTowerRecipes);
    }

    private static void addFuels() {
        Logger.INFO("Registering New Fuels.");
        HotFuel.addNewHotFuel(FluidUtils.getLava(83), FluidUtils.getPahoehoeLava(83), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("nuggetCopper", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetTin", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetGold", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetSilver", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetTantalum", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallTungstate", 1), ItemUtils.getSimpleStack(Blocks.field_150343_Z)}, new int[]{2000, 1000, 250, 250, 250, 250, 500}, 0);
        HotFuel.addNewHotFuel(FluidUtils.getPahoehoeLava(83), GT_Values.NF, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("nuggetBronze", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetElectrum", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetTantalum", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallTungstate", 1), ItemUtils.getSimpleStack(Blocks.field_150343_Z)}, new int[]{750, 250, 250, 250, 1850}, 0);
        HotFuel.addNewHotFuel(MISC_MATERIALS.SOLAR_SALT_HOT.getFluidStack(100), MISC_MATERIALS.SOLAR_SALT_COLD.getFluidStack(100), FluidUtils.getSuperHeatedSteam(100000), 0);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getSimpleStack(Items.field_151129_at)}).metadata(GT_RecipeConstants.FUEL_VALUE, (Object)32).metadata(GT_RecipeConstants.FUEL_TYPE, (Object)2).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getIC2Cell(2)}).metadata(GT_RecipeConstants.FUEL_VALUE, (Object)32).metadata(GT_RecipeConstants.FUEL_TYPE, (Object)2).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getIC2Cell(11)}).metadata(GT_RecipeConstants.FUEL_VALUE, (Object)24).metadata(GT_RecipeConstants.FUEL_TYPE, (Object)2).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
    }

    private static void extractorRecipes() {
        Logger.INFO("Registering Extractor Recipes.");
        GT_ModHandler.addExtractionRecipe((ItemStack)GregtechItemList.Battery_RE_EV_Sodium.get(1L, new Object[0]), (ItemStack)ItemList.Battery_Hull_HV.get(4L, new Object[0]));
        GT_ModHandler.addExtractionRecipe((ItemStack)GregtechItemList.Battery_RE_EV_Cadmium.get(1L, new Object[0]), (ItemStack)ItemList.Battery_Hull_HV.get(4L, new Object[0]));
        GT_ModHandler.addExtractionRecipe((ItemStack)GregtechItemList.Battery_RE_EV_Lithium.get(1L, new Object[0]), (ItemStack)ItemList.Battery_Hull_HV.get(4L, new Object[0]));
    }

    private static void fluidExtractorRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Cryotheum, (long)1L)}).fluidOutputs(new FluidStack[]{FluidUtils.getFluidStack("cryotheum", 250)}).duration(200).eut(TierEU.RECIPE_HV / 2L).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getSimpleStack(Items.field_151079_bi)}).fluidOutputs(new FluidStack[]{FluidUtils.getFluidStack("ender", 250)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Pyrotheum, (long)1L)}).fluidOutputs(new FluidStack[]{FluidUtils.getFluidStack("pyrotheum", 250)}).duration(200).eut(TierEU.RECIPE_HV / 2L).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
    }

    private static void centrifugeRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.getNumberedAdvancedCircuit(2), MISC_MATERIALS.SOLAR_SALT_COLD.getCell(1)}).itemOutputs(new ItemStack[]{MISC_MATERIALS.SODIUM_NITRATE.getDust(3), MISC_MATERIALS.POTASSIUM_NITRATE.getDust(2), CI.emptyCells(1)}).duration(120).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
    }

    private static void mixerRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.getNumberedAdvancedCircuit(2), CI.emptyCells(1), MISC_MATERIALS.SODIUM_NITRATE.getDust(3), MISC_MATERIALS.POTASSIUM_NITRATE.getDust(2)}).itemOutputs(new ItemStack[]{MISC_MATERIALS.SOLAR_SALT_COLD.getCell(1)}).duration(40).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.getNumberedAdvancedCircuit(2), Materials.Titanium.getDust(9), Materials.Carbon.getDust(9), Materials.Potassium.getDust(9), Materials.Lithium.getDust(9), Materials.Sulfur.getDust(9)}).itemOutputs(new ItemStack[]{ALLOY.LEAGRISIUM.getDust(50)}).fluidInputs(new FluidStack[]{Materials.Hydrogen.getGas(5000L)}).duration(1200).eut(TierEU.RECIPE_EV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.getNumberedAdvancedCircuit(2), Materials.Steel.getDust(16), Materials.Molybdenum.getDust(1), Materials.Titanium.getDust(1), Materials.Nickel.getDust(4), Materials.Cobalt.getDust(2)}).itemOutputs(new ItemStack[]{ALLOY.MARAGING250.getDust(24)}).duration(1200).eut(TierEU.RECIPE_EV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
    }

    private static void chemicalReactorRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{CI.getNumberedAdvancedCircuit(21), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Apatite, (long)32L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustSmall, (Object)Materials.Sulfur, (long)8L)}).fluidInputs(new FluidStack[]{FluidUtils.getFluidStack("sulfuricacid", 4000)}).fluidOutputs(new FluidStack[]{FluidUtils.getFluidStack("sulfuricapatite", 8000)}).duration(400).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getSimpleStack(GenericChem.mPotassiumHydroxide, 3), CI.getNumberedAdvancedCircuit(1)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.PotassiumNitrade, (long)5L)}).fluidInputs(new FluidStack[]{Materials.NitricAcid.getFluid(1000L)}).fluidOutputs(new FluidStack[]{Materials.Water.getFluid(1000L)}).duration(100).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 6), CI.getNumberedAdvancedCircuit(1)}).itemOutputs(new ItemStack[]{MISC_MATERIALS.SODIUM_NITRATE.getDust(10)}).fluidInputs(new FluidStack[]{Materials.NitricAcid.getFluid(2000L)}).fluidOutputs(new FluidStack[]{Materials.CarbonDioxide.getGas(1000L)}).duration(100).eut(TierEU.RECIPE_LV).addTo(GT_RecipeConstants.UniversalChemical);
    }

    private static void blastFurnaceRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ALLOY.SILICON_CARBIDE.getDust(16), GT_Utility.getIntegratedCircuit((int)22)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Graphite, (long)8L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustSmall, (Object)Materials.Silicon, (long)8L)}).fluidInputs(new FluidStack[]{Materials.Nitrogen.getGas(4000L)}).fluidOutputs(new FluidStack[0]).duration(1200).eut(TierEU.RECIPE_IV).metadata(GT_RecipeConstants.COIL_HEAT, (Object)4500).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
    }

    private static void compressorRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Clay, (long)1L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Clay, (long)1L)}).duration(300).eut(2).addTo((IRecipeMap)RecipeMaps.compressorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.MeatRaw, (long)9L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.block, (Object)Materials.MeatRaw, (long)1L)}).duration(300).eut(2).addTo((IRecipeMap)RecipeMaps.compressorRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.FusionComputer_UV.get(9L, new Object[0])}).itemOutputs(new ItemStack[]{GregtechItemList.Compressed_Fusion_Reactor.get(1L, new Object[0])}).duration(132000).eut(TierEU.RECIPE_UV).addTo((IRecipeMap)RecipeMaps.compressorRecipes);
    }

    private static void macerationRecipes() {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.block, (Object)Materials.MeatRaw, (long)1L)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.MeatRaw, (long)9L)}).duration(880).eut(4).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
        if (ItemUtils.simpleMetaStack("chisel:limestone", 0, 1) != null) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("limestone", 1)}).itemOutputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Calcite, (long)4L)}).duration(400).eut(2).addTo((IRecipeMap)RecipeMaps.maceratorRecipes);
        }
    }

    private static void cyclotronRecipes() {
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.bismuth", 1), new ItemStack[]{GregtechItemList.Pellet_RTG_PO210.get(1L, new Object[0])}, null, new int[]{100}, 600000, 8160, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.americium", 1), new ItemStack[]{GregtechItemList.Pellet_RTG_AM241.get(4L, new Object[0])}, null, new int[]{2500}, 600000, 4080, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.uranium235", 10), new ItemStack[]{GregtechItemList.Pellet_RTG_SR90.get(1L, new Object[0])}, null, new int[]{570}, 600000, 4080, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.uranium233", 10), new ItemStack[]{GregtechItemList.Pellet_RTG_SR90.get(1L, new Object[0])}, null, new int[]{660}, 600000, 4080, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.plutonium", 10), new ItemStack[]{GregtechItemList.Pellet_RTG_SR90.get(1L, new Object[0])}, null, new int[]{220}, 600000, 4080, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.plutonium238", 1), new ItemStack[]{GregtechItemList.Pellet_RTG_PU238.get(2L, new Object[0])}, null, new int[]{780}, 600000, 4080, 10000);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{ELEMENT.getInstance().URANIUM238.getDust(1)}, FluidUtils.getFluidStack("deuterium", 400), new ItemStack[]{ItemUtils.getSimpleStack(ModItems.dustNeptunium238)}, null, new int[]{500}, 100, 2000, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(3), FluidUtils.getFluidStack("plasma.hydrogen", 100), new ItemStack[]{Particle.getBaseParticle(Particle.UP), Particle.getBaseParticle(Particle.DOWN), Particle.getBaseParticle(Particle.CHARM), Particle.getBaseParticle(Particle.STRANGE), Particle.getBaseParticle(Particle.TOP), Particle.getBaseParticle(Particle.BOTTOM)}, null, new int[]{50, 50, 50, 50, 50, 50}, 54000, MaterialUtils.getVoltageForTier(7), 15000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(6), FluidUtils.getFluidStack("plasma.helium", 1500), new ItemStack[]{Particle.getBaseParticle(Particle.ELECTRON), Particle.getBaseParticle(Particle.MUON), Particle.getBaseParticle(Particle.TAU), Particle.getBaseParticle(Particle.ELECTRON_NEUTRINO), Particle.getBaseParticle(Particle.MUON_NEUTRINO), Particle.getBaseParticle(Particle.TAU_NEUTRINO)}, null, new int[]{600, 40, 20, 15, 10, 5}, 48000, MaterialUtils.getVoltageForTier(7), 15000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(9), FluidUtils.getFluidStack("plasma.helium", 1500), new ItemStack[]{Particle.getBaseParticle(Particle.GLUON), Particle.getBaseParticle(Particle.PHOTON), Particle.getBaseParticle(Particle.Z_BOSON), Particle.getBaseParticle(Particle.W_BOSON), Particle.getBaseParticle(Particle.HIGGS_BOSON)}, null, new int[]{160, 260, 150, 150, 1}, 36000, MaterialUtils.getVoltageForTier(7), 15000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(12), Materials.Americium.getPlasma(2500L), new ItemStack[]{Particle.getBaseParticle(Particle.GRAVITON), Particle.getBaseParticle(Particle.ETA_MESON), Particle.getBaseParticle(Particle.PION), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.NEUTRON), Particle.getBaseParticle(Particle.LAMBDA), Particle.getBaseParticle(Particle.OMEGA), Particle.getBaseParticle(Particle.HIGGS_BOSON)}, null, new int[]{50, 50, 50, 40, 30, 20, 20, 10}, 20000, MaterialUtils.getVoltageForTier(8), 15000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(12), new FluidStack(ELEMENT.STANDALONE.CELESTIAL_TUNGSTEN.getPlasma(), 2500), new ItemStack[]{Particle.getBaseParticle(Particle.GRAVITON), Particle.getBaseParticle(Particle.ETA_MESON), Particle.getBaseParticle(Particle.PION), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.NEUTRON), Particle.getBaseParticle(Particle.LAMBDA), Particle.getBaseParticle(Particle.OMEGA), Particle.getBaseParticle(Particle.HIGGS_BOSON)}, null, new int[]{5000, 200, 200, 100, 80, 60, 40, 30}, 2000, MaterialUtils.getVoltageForTier(8), 15000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(15), FluidUtils.getFluidStack("plasma.hydrogen", 100), new ItemStack[]{Particle.getBaseParticle(Particle.GRAVITON), Particle.getBaseParticle(Particle.UNKNOWN)}, null, new int[]{1000, 100}, 1800, MaterialUtils.getVoltageForTier(6), 20000);
        FluidStack aPlasma = Materials.Duranium.getMolten(40L);
        FluidStack aPlasma_NULL = Materials._NULL.getPlasma(1L);
        if (aPlasma == null || aPlasma.isFluidEqual(aPlasma_NULL)) {
            aPlasma = Materials.Americium.getMolten(20L);
        }
        CORE.RA.addCyclotronRecipe(new ItemStack[]{CI.getNumberedCircuit(24), Particle.getBaseParticle(Particle.UNKNOWN)}, aPlasma, new ItemStack[]{GregtechItemList.Laser_Lens_Special.get(1L, new Object[0])}, null, new int[]{100}, 500, MaterialUtils.getVoltageForTier(8), 10000);
        int IonCount = 2;
        int tenCountA = 2;
        int tenCountB = 0;
        for (String y : IonParticles.MetaToNameMap.values()) {
            FluidStack aPlasma3;
            if (y.toLowerCase().contains("hydrogen")) continue;
            FluidStack aPlasma2 = FluidUtils.getFluidStack("plasma." + y.toLowerCase(), 2);
            Materials aTestMat = MaterialUtils.getMaterial(y);
            FluidStack fluidStack = aPlasma3 = aTestMat != null ? aTestMat.getPlasma(2L) : aPlasma2;
            if (aPlasma2 != null && !aPlasma2.isFluidEqual(aPlasma_NULL) || aPlasma3 != null && !aPlasma3.isFluidEqual(aPlasma_NULL)) {
                CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1 + (tenCountA - 1)), aPlasma2 != null ? aPlasma2 : aPlasma3, new ItemStack[]{Particle.getIon(y, 1), Particle.getIon(y, 2), Particle.getIon(y, 3), Particle.getIon(y, -1), Particle.getIon(y, -2), Particle.getIon(y, -3), Particle.getIon(y, 1), Particle.getIon(y, 2), Particle.getIon(y, -1)}, null, new int[]{275, 250, 225, 275, 250, 225, 275, 250, 275}, 400 * IonCount++ * tenCountA, MaterialUtils.getVoltageForTier(7), 30000 * tenCountA);
            } else {
                Logger.INFO("Plasma for " + y + " does not exist, please report this to Alkalus.");
            }
            if (tenCountB == 12) {
                tenCountB = 0;
                ++tenCountA;
                continue;
            }
            ++tenCountB;
        }
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(24), FluidUtils.getWildcardFluidStack("hydrogen", 1000), new ItemStack[]{Particle.getIon("Hydrogen", 1), Particle.getIon("Hydrogen", 2), Particle.getIon("Hydrogen", 3), Particle.getIon("Hydrogen", 1), Particle.getIon("Hydrogen", 2), Particle.getIon("Hydrogen", 3), Particle.getIon("Hydrogen", -1), Particle.getIon("Hydrogen", -2), Particle.getIon("Hydrogen", -3)}, null, new int[]{500, 500, 500, 500, 500, 500, 500, 500, 500}, 400, MaterialUtils.getVoltageForTier(6), 2500);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{Particle.getIon("Hydrogen", 0), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrogen", 1)}, null, new ItemStack[]{Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.NEUTRON), Particle.getBaseParticle(Particle.ELECTRON), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), CI.emptyCells(1)}, FluidUtils.getFluidStack("plasma.hydrogen", 100), new int[]{1250, 1250, 1250, 750, 750, 750, 10000}, 2400, MaterialUtils.getVoltageForTier(6), 15000);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{CI.getNumberedCircuit(21), Particle.getIon("Hydrogen", 0)}, FluidUtils.getFluidStack("hydrogen", 1000), new ItemStack[]{Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.NEUTRON), Particle.getBaseParticle(Particle.ELECTRON), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN)}, FluidUtils.getFluidStack("plasma.hydrogen", 100), new int[]{1250, 1250, 1250, 750, 750, 750}, 2400, MaterialUtils.getVoltageForTier(6), 15000);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{CI.getNumberedCircuit(20), Particle.getIon("Hydrogen", 0)}, FluidUtils.getWildcardFluidStack("hydrogen", 100), new ItemStack[]{Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON)}, null, new int[]{750, 750, 750, 750, 750, 750, 750, 750, 750}, 400, MaterialUtils.getVoltageForTier(6), 1500);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{CI.getNumberedCircuit(22), Particle.getBaseParticle(Particle.UNKNOWN)}, FluidUtils.getWildcardFluidStack("hydrogen", 100), new ItemStack[]{Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON)}, null, new int[]{375, 375, 375, 375, 375, 375, 375, 375, 375}, 400, MaterialUtils.getVoltageForTier(6), 1500);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{ELEMENT.getInstance().PLUTONIUM238.getDust(1), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN)}, FluidUtils.getFluidStack(FluidUtils.getWildcardFluidStack("ender", 1000), 1000), new ItemStack[]{ORES.DEEP_EARTH_REACTOR_FUEL_DEPOSIT.getDust(1)}, null, new int[]{2500}, 18000, MaterialUtils.getVoltageForTier(7), 250);
    }
}

