/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.items.Gregtech_MetaItem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class Gregtech_MetaItem_X32
extends Gregtech_MetaItem {
    protected final OrePrefixes[] mGeneratedPrefixList;

    public Gregtech_MetaItem_X32(String aUnlocalized, OrePrefixes ... aGeneratedPrefixList) {
        super(aUnlocalized, (short)32000, (short)766);
        this.mGeneratedPrefixList = Arrays.copyOf(aGeneratedPrefixList, 32);
        for (int i = 0; i < 32000; ++i) {
            Materials tMaterial;
            OrePrefixes tPrefix = this.mGeneratedPrefixList[i / 1000];
            if (tPrefix == null || (tMaterial = GregTech_API.sGeneratedMaterials[i % 1000]) == null || !this.doesMaterialAllowGeneration(tPrefix, tMaterial)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            GT_LanguageManager.addStringLocalization((String)(this.func_77667_c(tStack) + ".name"), (String)this.getDefaultLocalization(tPrefix, tMaterial, i));
            GT_LanguageManager.addStringLocalization((String)(this.func_77667_c(tStack) + ".tooltip"), (String)tMaterial.getToolTip(tPrefix.mMaterialAmount / 3628800L));
            if (tPrefix.mIsUnificatable) {
                GT_OreDictUnificator.set((OrePrefixes)tPrefix, (Materials)tMaterial, (ItemStack)tStack);
            } else {
                GT_OreDictUnificator.registerOre((Object)tPrefix.get((Object)tMaterial), (ItemStack)tStack);
            }
            if (tPrefix != OrePrefixes.stick && tPrefix != OrePrefixes.wireFine || tMaterial != Materials.Lead && tMaterial != Materials.Tin && tMaterial != Materials.SolderingAlloy) continue;
            GregTech_API.sSolderingMetalList.add(tStack);
        }
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        Materials tMaterial = GregTech_API.sGeneratedMaterials[this.getDamage(aStack) % 1000];
        return tMaterial == null ? Materials._NULL.mRGBa : tMaterial.mRGBa;
    }

    public boolean doesMaterialAllowGeneration(OrePrefixes aPrefix, Materials aMaterial) {
        return aPrefix != null && aMaterial != null && aPrefix.doGenerateItem(aMaterial);
    }

    public String getDefaultLocalization(OrePrefixes aPrefix, Materials aMaterial, int aMetaData) {
        return aPrefix.getDefaultLocalNameForItem(aMaterial);
    }

    public final IIconContainer getIconContainer(int aMetaData, Materials aMaterial) {
        return this.mGeneratedPrefixList[aMetaData / 1000] != null && this.mGeneratedPrefixList[aMetaData / 1000].mTextureIndex >= 0 ? aMaterial.mIconSet.mTextures[this.mGeneratedPrefixList[aMetaData / 1000].mTextureIndex] : null;
    }

    public boolean doesShowInCreative(OrePrefixes aPrefix, Materials aMaterial, boolean aDoShowAllItems) {
        return true;
    }

    @Override
    public ItemStack getContainerItem(ItemStack aStack) {
        OrePrefixes aPrefix;
        Materials aMaterial;
        int aDamage = aStack.func_77960_j();
        if (aDamage < 32000 && aDamage >= 0 && (aMaterial = GregTech_API.sGeneratedMaterials[aDamage % 1000]) != null && aMaterial != Materials.Empty && aMaterial != Materials._NULL && (aPrefix = this.mGeneratedPrefixList[aDamage / 1000]) != null) {
            return GT_Utility.copyAmount((int)1, (ItemStack)aPrefix.mContainerItem);
        }
        return null;
    }

    @Override
    public final IIconContainer getIconContainer(int aMetaData) {
        return GregTech_API.sGeneratedMaterials[aMetaData % 1000] == null ? null : this.getIconContainer(aMetaData, GregTech_API.sGeneratedMaterials[aMetaData % 1000]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        for (int i = 0; i < 32000; ++i) {
            if (!this.doesMaterialAllowGeneration(this.mGeneratedPrefixList[i / 1000], GregTech_API.sGeneratedMaterials[i % 1000]) || !this.doesShowInCreative(this.mGeneratedPrefixList[i / 1000], GregTech_API.sGeneratedMaterials[i % 1000], GregTech_API.sDoShowAllItemsInCreative)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
        super.func_150895_a(var1, aCreativeTab, aList);
    }

    @Override
    public final IIcon func_77617_a(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        if (aMetaData < 32000) {
            Materials tMaterial = GregTech_API.sGeneratedMaterials[aMetaData % 1000];
            if (tMaterial == null) {
                return null;
            }
            IIconContainer tIcon = this.getIconContainer(aMetaData, tMaterial);
            if (tIcon != null) {
                return tIcon.getIcon();
            }
            return null;
        }
        return aMetaData - 32000 < this.mIconList.length ? this.mIconList[aMetaData - 32000][0] : null;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        int tDamage = this.getDamage(aStack);
        if (tDamage < 32000 && this.mGeneratedPrefixList[tDamage / 1000] != null) {
            return Math.min(super.getItemStackLimit(aStack), this.mGeneratedPrefixList[tDamage / 1000].mDefaultStackSize);
        }
        return super.getItemStackLimit(aStack);
    }

    @Override
    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        int aMeta = stack.func_77960_j();
        HEX_OxFFFFFF = stack.func_82833_r().contains("Sodium") ? Utils.rgbtoHexValue(90, 90, 255) : (stack.func_82833_r().contains("Cadmium") ? Utils.rgbtoHexValue(150, 150, 80) : (stack.func_82833_r().contains("Lithium") ? Utils.rgbtoHexValue(225, 220, 255) : (stack.func_82833_r().contains("Wrought") ? Utils.rgbtoHexValue(200, 180, 180) : (stack.func_82833_r().contains("Bronze") ? Utils.rgbtoHexValue(255, 128, 0) : (stack.func_82833_r().contains("Brass") ? Utils.rgbtoHexValue(255, 180, 0) : (stack.func_82833_r().contains("Invar") ? Utils.rgbtoHexValue(180, 180, 120) : (aMeta > 50 && aMeta != 150 ? 0xFFFFFF : (stack.func_82833_r().contains("ULV") ? Utils.rgbtoHexValue(200, 180, 180) : (stack.func_82833_r().contains("LuV") ? 0xFFFFCC : (stack.func_82833_r().contains("ZPM") ? 16770560 : (stack.func_82833_r().contains("UV") ? 16757504 : (stack.func_82833_r().contains("MAX") ? Utils.rgbtoHexValue(MathUtils.randInt(220, 250), MathUtils.randInt(221, 251), MathUtils.randInt(220, 250)) : 0xFFFFFF))))))))))));
        return HEX_OxFFFFFF;
    }
}

