/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.List;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMetaTileEntity_IndustrialMacerator
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialMacerator>
implements ISurvivalConstructable {
    private int controllerTier = 1;
    private int mCasing;
    private int mPerLayer;
    private static IStructureDefinition<GregtechMetaTileEntity_IndustrialMacerator> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialMacerator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialMacerator(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialMacerator(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Macerator/Pulverizer";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller block for the Industrial Maceration Stack").addInfo("60% faster than using single block machines of the same voltage").addInfo("Maximum of n*tier parallels, LV = Tier 1, MV = Tier 2, etc.").addInfo("n=2 initially. n=8 after inserting Maceration Upgrade Chip.").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 6, 3, true).addController("Bottom center").addCasingInfoMin("Maceration Stack Casings (After upgrade)", 26, false).addCasingInfoMin("Stable Titanium Casings (Before upgrade)", 26, false).addInputBus("Bottom casing", new int[]{1}).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).addOutputBus("One per layer except bottom layer", new int[]{2}).addMufflerHatch("Any casing except bottom layer", new int[]{2}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialMacerator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName + "top1", StructureUtility.transpose((String[][])new String[][]{{"ccc", "ccc", "ccc"}})).addShape(this.mName + "mid1", StructureUtility.transpose((String[][])new String[][]{{"ccc", "c-c", "ccc"}})).addShape(this.mName + "bottom1", StructureUtility.transpose((String[][])new String[][]{{"b~b", "bbb", "bbb"}})).addShape(this.mName + "top2", StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}})).addShape(this.mName + "mid2", StructureUtility.transpose((String[][])new String[][]{{"CCC", "C-C", "CCC"}})).addShape(this.mName + "bottom2", StructureUtility.transpose((String[][])new String[][]{{"B~B", "BBB", "BBB"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMacerator.class).anyOf(new IHatchElement[]{GT_HatchElement.OutputBus}).shouldReject(t -> t.mPerLayer + 1 == t.mOutputBusses.size()).disallowOnly(new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN}).casingIndex(TAE.GTPP_INDEX(7)).dot(2).build(), GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMacerator.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy, GT_HatchElement.Maintenance, GT_HatchElement.Muffler}).disallowOnly(new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN}).casingIndex(TAE.GTPP_INDEX(7)).dot(2).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)7))})).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMacerator.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy, GT_HatchElement.Maintenance, GT_HatchElement.InputBus}).disallowOnly(new ForgeDirection[]{ForgeDirection.UP}).casingIndex(TAE.GTPP_INDEX(7)).dot(2).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)7))})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMacerator.class).anyOf(new IHatchElement[]{GT_HatchElement.OutputBus}).shouldReject(t -> t.mPerLayer + 1 == t.mOutputBusses.size()).disallowOnly(new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN}).casingIndex(GT_Utility.getCasingTextureIndex((Block)GregTech_API.sBlockCasings4, (int)2)).dot(2).build(), GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMacerator.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy, GT_HatchElement.Maintenance, GT_HatchElement.Muffler}).disallowOnly(new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN}).casingIndex(GT_Utility.getCasingTextureIndex((Block)GregTech_API.sBlockCasings4, (int)2)).dot(2).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)2))})).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMacerator.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy, GT_HatchElement.Maintenance, GT_HatchElement.InputBus}).disallowOnly(new ForgeDirection[]{ForgeDirection.UP}).casingIndex(GT_Utility.getCasingTextureIndex((Block)GregTech_API.sBlockCasings4, (int)2)).dot(2).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)2))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName + "bottom" + this.controllerTier, stackSize, hintsOnly, 1, 0, 0);
        this.buildPiece(this.mName + "mid" + this.controllerTier, stackSize, hintsOnly, 1, 1, 0);
        this.buildPiece(this.mName + "mid" + this.controllerTier, stackSize, hintsOnly, 1, 2, 0);
        this.buildPiece(this.mName + "mid" + this.controllerTier, stackSize, hintsOnly, 1, 3, 0);
        this.buildPiece(this.mName + "mid" + this.controllerTier, stackSize, hintsOnly, 1, 4, 0);
        this.buildPiece(this.mName + "top" + this.controllerTier, stackSize, hintsOnly, 1, 5, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivialBuildPiece(this.mName + "bottom" + this.controllerTier, stackSize, 1, 0, 0, elementBudget, env, false, true);
        this.mPerLayer = 0;
        if (built >= 0) {
            return built;
        }
        built = this.survivialBuildPiece(this.mName + "mid" + this.controllerTier, stackSize, 1, 1, 0, elementBudget, env, false, true);
        this.mPerLayer = 1;
        if (built >= 0) {
            return built;
        }
        built = this.survivialBuildPiece(this.mName + "mid" + this.controllerTier, stackSize, 1, 2, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        this.mPerLayer = 2;
        built = this.survivialBuildPiece(this.mName + "mid" + this.controllerTier, stackSize, 1, 3, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        this.mPerLayer = 3;
        built = this.survivialBuildPiece(this.mName + "mid" + this.controllerTier, stackSize, 1, 4, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        this.mPerLayer = 4;
        return this.survivialBuildPiece(this.mName + "top" + this.controllerTier, stackSize, 1, 5, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mPerLayer = 0;
        if (this.checkPiece(this.mName + "bottom" + this.controllerTier, 1, 0, 0)) {
            while (this.mPerLayer < 4) {
                if (!this.checkPiece(this.mName + "mid" + this.controllerTier, 1, this.mPerLayer + 1, 0) || this.mPerLayer + 1 != this.mOutputBusses.size()) {
                    return false;
                }
                ++this.mPerLayer;
            }
            return this.checkPiece(this.mName + "top" + this.controllerTier, 1, 5, 0) && this.mOutputBusses.size() == 5 && this.mCasing >= 26 && this.checkHatch();
        }
        return false;
    }

    protected SoundResource getProcessStartSound() {
        return SoundResource.IC2_MACHINES_MACERATOR_OP;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab;
    }

    @Override
    protected int getCasingTextureId() {
        int n;
        switch (this.controllerTier) {
            case 2: {
                n = TAE.GTPP_INDEX(7);
                break;
            }
            default: {
                n = GT_Utility.getCasingTextureIndex((Block)GregTech_API.sBlockCasings4, (int)2);
            }
        }
        return n;
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.maceratorRecipes;
    }

    public int getRecipeCatalystPriority() {
        return -10;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getFrontFacing() != ForgeDirection.UP && aBaseMetaTileEntity.getCoverIDAtSide(ForgeDirection.UP) == 0 && !aBaseMetaTileEntity.getOpacityAtSide(ForgeDirection.UP)) {
            Random tRandom = aBaseMetaTileEntity.getWorld().field_73012_v;
            aBaseMetaTileEntity.getWorld().func_72869_a("smoke", (double)((float)aBaseMetaTileEntity.getXCoord() + 0.8f - tRandom.nextFloat() * 0.6f), (double)((float)aBaseMetaTileEntity.getYCoord() + 0.3f + tRandom.nextFloat() * 0.2f), (double)((float)aBaseMetaTileEntity.getZCoord() + 1.2f - tRandom.nextFloat() * 1.6f), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        ItemStack aGuiStack;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 0L && this.controllerTier == 1 && GregtechItemList.Maceration_Upgrade_Chip.isStackEqual(aGuiStack = this.getControllerSlot(), false, true)) {
            this.controllerTier = 2;
            this.mInventory[1] = ItemUtils.depleteStack(aGuiStack);
            this.func_70296_d();
            this.mUpdated = true;
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        ItemStack heldItem;
        if (this.controllerTier == 1 && !aPlayer.func_70093_af() && GregtechItemList.Maceration_Upgrade_Chip.isStackEqual(heldItem = aPlayer.func_70694_bm(), false, true)) {
            this.controllerTier = 2;
            aPlayer.func_70062_b(0, ItemUtils.depleteStack(heldItem));
            if (this.getBaseMetaTileEntity().isServerSide()) {
                this.func_70296_d();
                aPlayer.field_71071_by.func_70296_d();
                this.mUpdated = true;
            }
            return true;
        }
        return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
    }

    public void onValueUpdate(byte aValue) {
        this.controllerTier = aValue;
    }

    public byte getUpdateData() {
        return (byte)this.controllerTier;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mTier", (byte)this.controllerTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.controllerTier = !aNBT.func_150297_b("mTier", 1) ? 2 : (int)aNBT.func_74771_c("mTier");
    }

    public void initDefaultModes(NBTTagCompound aNBT) {
        super.initDefaultModes(aNBT);
        this.controllerTier = aNBT == null || !aNBT.func_74764_b("mTier") ? 1 : (int)aNBT.func_74771_c("mTier");
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        aNBT.func_74774_a("mTier", (byte)this.controllerTier);
    }

    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        super.addAdditionalTooltipInformation(stack, tooltip);
        NBTTagCompound aNBT = stack.func_77978_p();
        int tier = aNBT == null || !aNBT.func_74764_b("mTier") ? 1 : aNBT.func_74762_e("mTier");
        tooltip.add(StatCollector.func_74837_a((String)"tooltip.large_macerator.tier", (Object[])new Object[]{tier}));
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().setSpeedBonus(0.625f).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public int getMaxParallelRecipes() {
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        return Math.max(1, (this.controllerTier == 1 ? 2 : 8) * tTier);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialMacerator;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public boolean isOverclockerUpgradable() {
        return true;
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("tier", this.controllerTier);
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("tier")) {
            currentTip.add("Tier: " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)tag.func_74762_e("tier")) + EnumChatFormatting.RESET);
        }
    }
}

